/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shetiphian.core.common.MyCreativeTab;
import shetiphian.core.common.RegistryHelper;
import shetiphian.multibeds.Values;
import shetiphian.multibeds.client.gui.GuiBlanketLoom;
import shetiphian.multibeds.client.gui.GuiBuilder;
import shetiphian.multibeds.common.block.BlockEarthBed;
import shetiphian.multibeds.common.block.BlockEarthLadder;
import shetiphian.multibeds.common.crafting.RecipeSpool;
import shetiphian.multibeds.common.inventory.ContainerBlanketLoom;
import shetiphian.multibeds.common.inventory.ContainerBuilder;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemBeddingPackage;
import shetiphian.multibeds.common.item.ItemBlanket;
import shetiphian.multibeds.common.item.ItemBlockLadder;
import shetiphian.multibeds.common.item.ItemBlockMultiBed;
import shetiphian.multibeds.common.item.ItemBuilderKit;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.item.ItemPillowSheet;
import shetiphian.multibeds.common.loot.BannerLootCondition;
import shetiphian.multibeds.common.loot.BannerLootHandler;
import shetiphian.multibeds.common.misc.EnumBedStyle;
import shetiphian.multibeds.common.tileentity.TileEntityLadder;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

@Mod.EventBusSubscriber(modid="multibeds", bus=Mod.EventBusSubscriber.Bus.MOD)
class Register {
    Register() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        for (EnumBedStyle style : EnumBedStyle.values()) {
            Values.blocksEarthBed.put(style, RegistryHelper.register((IForgeRegistry)registry, (Block)new BlockEarthBed(style), (String)("multibeds:" + style.getString())));
        }
        Values.poiHomeBeds = ImmutableSet.copyOf((Collection)Values.blocksEarthBed.values().stream().flatMap(block -> block.m_49965_().m_61056_().stream()).filter(state -> state.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD).collect(Collectors.toSet()));
        Values.blockEarthLadder = RegistryHelper.register((IForgeRegistry)registry, (Block)new BlockEarthLadder(), (String)"multibeds:ladder");
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<BlockEntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        Block[] validBlocks = Values.blocksEarthBed.values().toArray(new Block[0]);
        Values.tileBed = RegistryHelper.register((IForgeRegistry)registry, TileEntityMultiBed::new, (String)"multibeds:bed", (Block[])validBlocks);
        Values.tileLadder = RegistryHelper.register((IForgeRegistry)registry, TileEntityLadder::new, (String)"multibeds:ladder", (Block[])new Block[]{Values.blockEarthLadder});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        Values.tabMultiBeds = new MyCreativeTab("MultiBeds");
        for (Block block : Values.blocksEarthBed.values()) {
            if (!(block instanceof BlockEarthBed)) continue;
            Values.itemsEarthBed.put(((BlockEarthBed)block).getBedStyle(), (Item)RegistryHelper.register((IForgeRegistry)registry, (BlockItem)new ItemBlockMultiBed(block, Register.stackable())));
        }
        Values.itemEarthLadder = RegistryHelper.register((IForgeRegistry)registry, (BlockItem)new ItemBlockLadder(Values.blockEarthLadder, Register.stackable()));
        RegistryHelper.register((IForgeRegistry)registry, (Item)new Item(Register.stackable()), (String)"multibeds:woolen_cloth");
        RegistryHelper.register((IForgeRegistry)registry, (Item)new Item(Register.stackable()), (String)"multibeds:feather_pile");
        RegistryHelper.register((IForgeRegistry)registry, (Item)new Item(Register.stackable()), (String)"multibeds:padding");
        RegistryHelper.register((IForgeRegistry)registry, (Item)new ItemBuilderKit.Bed(Register.stackable()), (String)"multibeds:bed_kit");
        RegistryHelper.register((IForgeRegistry)registry, (Item)new ItemBuilderKit.Ladder(Register.stackable()), (String)"multibeds:ladder_tools");
        RegistryHelper.register((IForgeRegistry)registry, (Item)new ItemEmbroideryThread(Register.unstackable()), (String)"multibeds:embroidery_thread");
        Values.itemBeddingPackage = RegistryHelper.register((IForgeRegistry)registry, (Item)new ItemBeddingPackage(Register.stackable()), (String)"multibeds:bedding_package");
        Values.itemSheet = RegistryHelper.register((IForgeRegistry)registry, (Item)new ItemPillowSheet(Register.stackable(), ItemBedCustomization.EnumType.SHEET), (String)"multibeds:sheet");
        Values.itemPillow = RegistryHelper.register((IForgeRegistry)registry, (Item)new ItemPillowSheet(Register.stackable(), ItemBedCustomization.EnumType.PILLOW), (String)"multibeds:pillow");
        for (DyeColor color : DyeColor.values()) {
            Values.itemsBlanket.add(RegistryHelper.register((IForgeRegistry)registry, (Item)new ItemBlanket(Register.stackable(), color), (String)("multibeds:blanket_" + color.m_41065_())));
        }
        Register.setTabIcon();
    }

    private static Item.Properties stackable() {
        return new Item.Properties().m_41491_((CreativeModeTab)Values.tabMultiBeds);
    }

    private static Item.Properties unstackable() {
        return Register.stackable().m_41487_(1);
    }

    private static void setTabIcon() {
        if (Values.blocksEarthBed.get((Object)EnumBedStyle.COT) != null) {
            Values.tabMultiBeds.setIcon(new ItemStack((ItemLike)Values.blocksEarthBed.get((Object)EnumBedStyle.COT)));
        }
    }

    @SubscribeEvent
    public static void registerModifierSerializers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new BannerLootHandler.Serializer().setRegistryName(new ResourceLocation("multibeds:banner_embroidery")));
        Values.LootConditions.IS_BANNER = (LootItemConditionType)Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)new ResourceLocation("multibeds:is_banner"), (Object)new LootItemConditionType((Serializer)new BannerLootCondition.Serializer()));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<RecipeSerializer<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)((RecipeSerializer)new SimpleRecipeSerializer(RecipeSpool::new).setRegistryName("multibeds:spooling")));
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<MenuType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)((MenuType)IForgeMenuType.create((windowId, invPlayer, data) -> ContainerBuilder.Bed(windowId, invPlayer)).setRegistryName("multibeds:bed_kit")));
        registry.register((IForgeRegistryEntry)((MenuType)IForgeMenuType.create((windowId, invPlayer, data) -> new ContainerBlanketLoom(windowId, invPlayer)).setRegistryName("multibeds:blanket_loom")));
        registry.register((IForgeRegistryEntry)((MenuType)IForgeMenuType.create((windowId, invPlayer, data) -> ContainerBuilder.Ladder(windowId, invPlayer)).setRegistryName("multibeds:ladder_kit")));
    }

    @OnlyIn(value=Dist.CLIENT)
    static void registerScreenFactories() {
        MenuScreens.m_96206_(Values.Container.BED_KIT, GuiBuilder::new);
        MenuScreens.m_96206_(Values.Container.BLANKET_LOOM, GuiBlanketLoom::new);
        MenuScreens.m_96206_(Values.Container.LADDER_KIT, GuiBuilder::new);
    }
}

