/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.model;

import com.google.common.collect.ImmutableMap;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Logger;
import shetiphian.core.client.model.AbstractModelCacheBuilder;
import shetiphian.core.client.model.IPartData;
import shetiphian.multibeds.MultiBeds;
import shetiphian.multibeds.client.model.Parts;

@OnlyIn(value=Dist.CLIENT)
public class CacheBuilder
extends AbstractModelCacheBuilder {
    static CacheBuilder INSTANCE = new CacheBuilder(MultiBeds.LOGGER);

    public CacheBuilder(Logger logger) {
        super(logger);
    }

    static void rebuildCache() {
        INSTANCE.clearCache();
    }

    static void preload() {
        for (IPartData partData : Parts.BED_MODELS) {
            CacheBuilder.INSTANCE.BAKERY.m_119341_(partData.getLocation());
        }
        for (IPartData partData : Parts.LADDER_MODELS) {
            CacheBuilder.INSTANCE.BAKERY.m_119341_(partData.getLocation());
        }
    }

    public void preBakeSetup(ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter) {
        super.preBakeSetup(bakery, spriteGetter);
        CacheBuilder.preload();
    }

    public static BakedModel getBed(String part, String key, Direction facing, String particle) {
        return INSTANCE.get(part, key, facing, particle, Parts.BED_MODELS);
    }

    public static BakedModel getLadder(String part, String key, Direction facing, String particle) {
        return INSTANCE.get(part, key, facing, particle, Parts.LADDER_MODELS);
    }

    protected ImmutableMap<String, String> setTextures(IPartData partData, String texture, String particle) {
        if (partData.getName().contains("mattress")) {
            return new ImmutableMap.Builder().put((Object)"mattress", (Object)Parts.getMattressTexture()).put((Object)"cover", (Object)texture).put((Object)"particle", (Object)particle).build();
        }
        if (partData.getName().contains("blanket")) {
            return new ImmutableMap.Builder().put((Object)"blanket", (Object)texture).put((Object)"particle", (Object)particle).build();
        }
        if (partData.getName().contains("pillow")) {
            return new ImmutableMap.Builder().put((Object)"pillow", (Object)texture).put((Object)"particle", (Object)particle).build();
        }
        if (partData.getName().contains("common/art")) {
            return new ImmutableMap.Builder().put((Object)"art", (Object)texture).put((Object)"particle", (Object)particle).build();
        }
        return new ImmutableMap.Builder().put((Object)"body", (Object)texture).put((Object)"particle", (Object)particle).build();
    }
}

