/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.inventory;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Function;
import shetiphian.multibeds.Values;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemBlanket;
import shetiphian.multibeds.common.misc.EnumBlanket;

public class ContainerBlanketLoom
extends AbstractContainerMenu {
    private final ContainerLevelAccess worldPos;
    private final DataSlot indexSelectedPattern = DataSlot.m_39401_();
    private EnumBlanket enumBlanket = EnumBlanket.NONE;
    private final Slot slotBlanket;
    private final Slot slotDye;
    private final Slot slotString;
    private final Slot slotOutput;
    private final Container invInputs = new SimpleContainer(3){

        public void m_6596_() {
            super.m_6596_();
            ContainerBlanketLoom.this.m_6199_((Container)this);
            if (ContainerBlanketLoom.this.slotOutput.m_7993_().m_41619_()) {
                ItemStack stack = this.m_8020_(0);
                if (stack.m_41619_()) {
                    ContainerBlanketLoom.this.enumBlanket = EnumBlanket.NONE;
                } else if (stack.m_41720_() instanceof ItemBlanket) {
                    DyeColor color = ((ItemBlanket)stack.m_41720_()).getColor(stack);
                    String pattern = ItemBlanket.getPatternName(stack);
                    ContainerBlanketLoom.this.enumBlanket = EnumBlanket.byName(pattern + "_" + color.m_41065_());
                }
            }
        }
    };
    private final Container invOutput = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            ItemStack stack = this.m_8020_(0);
            if (stack.m_41619_() && ContainerBlanketLoom.this.slotBlanket.m_7993_().m_41619_()) {
                ContainerBlanketLoom.this.enumBlanket = EnumBlanket.NONE;
            } else if (stack.m_41720_() instanceof ItemBlanket) {
                DyeColor color = ((ItemBlanket)stack.m_41720_()).getColor(stack);
                String pattern = ItemBlanket.getPatternName(stack);
                ContainerBlanketLoom.this.enumBlanket = EnumBlanket.byName(pattern + "_" + color.m_41065_());
            }
        }
    };

    public ContainerBlanketLoom(int id, Inventory playerInv) {
        this(id, playerInv, ContainerLevelAccess.f_39287_);
    }

    public ContainerBlanketLoom(int id, Inventory playerInv, final ContainerLevelAccess callable) {
        super(Values.Container.BLANKET_LOOM, id);
        this.worldPos = callable;
        this.slotBlanket = this.m_38897_(new Slot(this.invInputs, 0, 16, 88){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof ItemBlanket;
            }

            public void m_5852_(ItemStack stack) {
                ContainerBlanketLoom.this.indexSelectedPattern.m_6422_(ItemBlanket.getBlanket(stack).getPattern().ordinal());
                super.m_5852_(stack);
            }
        });
        this.slotDye = this.m_38897_(new Slot(this.invInputs, 1, 40, 88){

            public boolean m_5857_(ItemStack stack) {
                return DyeHelper.isDye((ItemStack)stack);
            }
        });
        this.slotString = this.m_38897_(new Slot(this.invInputs, 2, 64, 88){

            public boolean m_5857_(ItemStack stack) {
                return Function.getOres((String)"forge:string").contains(stack.m_41720_());
            }
        });
        this.slotOutput = this.m_38897_(new Slot(this.invOutput, 0, 40, 120){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player thePlayer, ItemStack stack) {
                ItemStack stackBlanket = ContainerBlanketLoom.this.slotBlanket.m_7993_();
                if (!ItemBlanket.getPatternName(stack).equals(ItemBlanket.getPatternName(stackBlanket))) {
                    ContainerBlanketLoom.this.slotString.m_6201_(1);
                }
                if (stack.m_41720_() != stackBlanket.m_41720_()) {
                    ContainerBlanketLoom.this.slotDye.m_6201_(1);
                }
                ContainerBlanketLoom.this.slotBlanket.m_6201_(1);
                callable.m_39292_((world, pos) -> world.m_5594_(null, pos, SoundEvents.f_12492_, SoundSource.BLOCKS, 1.0f, 1.0f));
                super.m_142406_(thePlayer, stack);
            }
        });
        int pX = 27;
        int pY = 171;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; col = (int)((byte)(col + 1))) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, pX + col * 18, pY));
            }
            pY += 18;
        }
        pY += 4;
        for (int col = 0; col < 9; col = (int)((byte)(col + 1))) {
            this.m_38897_(new Slot((Container)playerInv, col, pX + col * 18, pY));
        }
        this.m_38895_(this.indexSelectedPattern);
        this.slotBlanket.m_5852_(playerInv.m_36056_().m_41620_(1));
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        if (player.m_150110_().f_35937_ && player.f_36096_.m_142621_().m_41619_()) {
            ItemStack blanket;
            if (slotId == this.slotString.f_40219_) {
                if (!this.slotString.m_6657_()) {
                    this.slotString.m_5852_(new ItemStack((ItemLike)Items.f_42401_));
                    this.updateOutputStack();
                    this.m_38946_();
                    return;
                }
            } else if (slotId == this.slotDye.f_40219_ && !this.slotDye.m_6657_() && (blanket = this.slotBlanket.m_7993_()).m_41720_() instanceof ItemBedCustomization) {
                DyeColor color = DyeColor.m_41053_((int)(((ItemBedCustomization)blanket.m_41720_()).getColor(blanket).m_41060_() + 1));
                this.slotDye.m_5852_(new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)color)));
                this.updateOutputStack();
                this.m_38946_();
                return;
            }
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }

    public boolean m_6875_(Player playerIn) {
        return ContainerBlanketLoom.m_38889_((ContainerLevelAccess)this.worldPos, (Player)playerIn, (Block)Blocks.f_50617_);
    }

    public boolean m_6366_(Player player, int id) {
        if (id >= 0 && id < EnumBlanket.Pattern.values().length) {
            this.indexSelectedPattern.m_6422_(id);
            this.updateOutputStack();
            return true;
        }
        return false;
    }

    public void m_6199_(Container inventory) {
        this.updateOutputStack();
        this.m_38946_();
    }

    private void updateOutputStack() {
        ItemStack stackBlanket = this.slotBlanket.m_7993_();
        ItemStack stackDye = this.slotDye.m_7993_();
        ItemStack stackString = this.slotString.m_7993_();
        ItemStack stackOutput = ItemStack.f_41583_;
        if (!stackBlanket.m_41619_()) {
            if (!stackDye.m_41619_() || !stackString.m_41619_()) {
                DyeColor dyeColor = DyeHelper.getDyeColor((ItemStack)stackDye);
                if (!stackDye.m_41619_() && dyeColor != null) {
                    stackOutput = new ItemStack((ItemLike)Values.itemsBlanket.get(dyeColor.m_41060_()));
                } else {
                    stackOutput = stackBlanket.m_41777_();
                    stackOutput.m_41764_(1);
                }
                CompoundTag tag = stackBlanket.m_41784_().m_6426_();
                stackOutput.m_41751_(tag);
                if (!stackString.m_41619_()) {
                    ItemBlanket.setPatternName(stackOutput, EnumBlanket.Pattern.byIndex(this.indexSelectedPattern.m_6501_()));
                }
            }
        } else {
            this.indexSelectedPattern.m_6422_(0);
        }
        if (!ItemStack.m_41728_((ItemStack)stackOutput, (ItemStack)this.slotOutput.m_7993_())) {
            this.slotOutput.m_5852_(stackOutput);
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == this.slotOutput.f_40219_) {
                if (!this.m_38903_(itemstack1, 4, 40, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index != this.slotDye.f_40219_ && index != this.slotBlanket.f_40219_ && index != this.slotString.f_40219_ ? (itemstack1.m_41720_() instanceof ItemBlanket ? !this.m_38903_(itemstack1, this.slotBlanket.f_40219_, this.slotBlanket.f_40219_ + 1, false) : (DyeHelper.isDye((ItemStack)itemstack1) ? !this.m_38903_(itemstack1, this.slotDye.f_40219_, this.slotDye.f_40219_ + 1, false) : (Function.getOres((String)"forge:string").contains(itemstack1.m_41720_()) ? !this.m_38903_(itemstack1, this.slotString.f_40219_, this.slotString.f_40219_ + 1, false) : (index >= 4 && index < 31 ? !this.m_38903_(itemstack1, 31, 40, false) : index >= 31 && index < 40 && !this.m_38903_(itemstack1, 4, 31, false))))) : !this.m_38903_(itemstack1, 4, 40, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.worldPos.m_39292_((p_217028_2_, p_217028_3_) -> this.m_150411_(player, this.invInputs));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Slot getSlotBlanket() {
        return this.slotBlanket;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Slot getSlotDye() {
        return this.slotDye;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Slot getSlotString() {
        return this.slotString;
    }

    @OnlyIn(value=Dist.CLIENT)
    public EnumBlanket getEnumBlanket() {
        return this.enumBlanket;
    }
}

