/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.multibeds.client.render.RenderRegistry;
import shetiphian.multibeds.common.block.BlockMultiBedBase;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public class ItemBedCustomization
extends Item
implements IColored {
    private final DyeColor color;
    private final EnumType type;

    public ItemBedCustomization(Item.Properties properties, DyeColor color, EnumType type) {
        super(properties);
        this.color = color;
        this.type = type;
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> list) {
        if (this.m_41389_(group)) {
            list.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public InteractionResult m_6225_(UseOnContext data) {
        return ItemBedCustomization.putOnBed(data.m_43722_(), data.m_43723_(), data.m_43725_(), data.m_8083_(), data.m_43719_(), false) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public static boolean putOnBed(ItemStack stack, Player player, Level world, BlockPos pos, Direction face, boolean mirror) {
        TileEntityMultiBed[] bedTiles;
        BlockPos[] bedBlocks;
        EnumType type;
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        EnumType enumType = item instanceof ItemBedCustomization ? ((ItemBedCustomization)item).getType() : (type = item instanceof BannerItem ? EnumType.BLANKET : null);
        if (type == null) {
            return false;
        }
        if (world.m_8055_(pos).m_60734_() instanceof BlockMultiBedBase && player.m_36204_((bedBlocks = BlockMultiBedBase.getBlocks((BlockGetter)world, pos))[0], face, stack) && player.m_36204_(bedBlocks[1], face, stack) && (bedTiles = BlockMultiBedBase.getTiles((BlockGetter)world, pos)) != null) {
            if (!world.f_46443_) {
                if (!player.m_150110_().f_35937_) {
                    ItemStack drop = ItemStack.f_41583_;
                    for (int index = 0; index < 2; ++index) {
                        switch (type) {
                            case SHEET: {
                                if (!bedTiles[index].hasSheet()) break;
                                drop = bedTiles[index].getSheetItem();
                                break;
                            }
                            case PILLOW: {
                                if (!bedTiles[index].hasPillow()) break;
                                drop = bedTiles[index].getPillowItem();
                                break;
                            }
                            case BLANKET: {
                                if (!bedTiles[index].hasBlanket()) break;
                                drop = bedTiles[index].getBlanketItem();
                            }
                        }
                        if (drop.m_41619_()) continue;
                        Function.dropItem((Level)world, (BlockPos)bedBlocks[index], (ItemStack)drop);
                        break;
                    }
                }
                switch (type) {
                    case SHEET: {
                        bedTiles[0].setSheetItem(stack);
                        bedTiles[1].setSheetItem(stack);
                        break;
                    }
                    case PILLOW: {
                        bedTiles[0].setPillowItem(stack);
                        bedTiles[1].setPillowItem(stack);
                        break;
                    }
                    case BLANKET: {
                        bedTiles[0].setBlanketItem(stack, mirror);
                        bedTiles[1].setBlanketItem(stack, mirror);
                    }
                }
                Function.syncTile((BlockEntity)bedTiles[0]);
                Function.syncTile((BlockEntity)bedTiles[1]);
            }
            SoundType soundtype = SoundType.f_56745_;
            world.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    public EnumType getType() {
        return this.type;
    }

    public DyeColor getColor(ItemStack stack) {
        return this.color;
    }

    public int getColorFor(IColored.Data data, int index) {
        return this.color.m_41070_();
    }

    public Component m_7626_(ItemStack stack) {
        return new TranslatableComponent("item.multibeds." + this.getType().getName());
    }

    public static enum EnumType {
        SHEET,
        PILLOW,
        BLANKET;


        public String getName() {
            return this.toString().toLowerCase();
        }
    }
}

