/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.misc;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class BiomeTexture {
    public static final Map<Biome, Block> BIOME_TEXTURE = new HashMap<Biome, Block>();
    private static final ItemStack DEFAULT = new ItemStack((ItemLike)Blocks.f_50705_);

    public static ItemStack getStackFor(Biome biome) {
        if (biome == null) {
            return DEFAULT.m_41777_();
        }
        if (!BIOME_TEXTURE.containsKey(biome)) {
            Block block = BiomeTexture.getBlockFor(biome.getRegistryName());
            if (block == null) {
                block = BiomeTexture.getBlockFor(biome.m_47567_().m_47645_());
            }
            BIOME_TEXTURE.put(biome, block);
        }
        return new ItemStack((ItemLike)BIOME_TEXTURE.getOrDefault(biome, Blocks.f_50705_));
    }

    private static Block getBlockFor(ResourceLocation biome) {
        if (biome != null && "minecraft".equals(biome.m_135827_())) {
            switch (biome.m_135815_()) {
                case "the_void": {
                    return Blocks.f_50259_;
                }
                case "plains": {
                    return Blocks.f_50705_;
                }
                case "sunflower_plains": {
                    return Blocks.f_50705_;
                }
                case "snowy_plains": {
                    return Blocks.f_50741_;
                }
                case "ice_spikes": {
                    return Blocks.f_50354_;
                }
                case "desert": {
                    return Blocks.f_50062_;
                }
                case "swamp": {
                    return Blocks.f_50705_;
                }
                case "forest": {
                    return Blocks.f_50742_;
                }
                case "flower_forest": {
                    return Blocks.f_50742_;
                }
                case "birch_forest": {
                    return Blocks.f_50742_;
                }
                case "dark_forest": {
                    return Blocks.f_50745_;
                }
                case "old_growth_birch_forest": {
                    return Blocks.f_50742_;
                }
                case "old_growth_pine_taiga": {
                    return Blocks.f_50741_;
                }
                case "old_growth_spruce_taiga": {
                    return Blocks.f_50741_;
                }
                case "taiga": {
                    return Blocks.f_50741_;
                }
                case "snowy_taiga": {
                    return Blocks.f_50741_;
                }
                case "savanna": {
                    return Blocks.f_50744_;
                }
                case "savanna_plateau": {
                    return Blocks.f_50744_;
                }
                case "windswept_hills": {
                    return Blocks.f_50705_;
                }
                case "windswept_gravelly_hills": {
                    return Blocks.f_50705_;
                }
                case "windswept_forest": {
                    return Blocks.f_50705_;
                }
                case "windswept_savanna": {
                    return Blocks.f_50744_;
                }
                case "jungle": {
                    return Blocks.f_50743_;
                }
                case "sparse_jungle": {
                    return Blocks.f_50743_;
                }
                case "bamboo_jungle": {
                    return Blocks.f_50743_;
                }
                case "badlands": {
                    return Blocks.f_50352_;
                }
                case "eroded_badlands": {
                    return Blocks.f_50352_;
                }
                case "wooded_badlands": {
                    return Blocks.f_50352_;
                }
                case "meadow": {
                    return Blocks.f_50742_;
                }
                case "grove": {
                    return Blocks.f_50741_;
                }
                case "snowy_slopes": {
                    return Blocks.f_50127_;
                }
                case "frozen_peaks": {
                    return Blocks.f_50354_;
                }
                case "jagged_peaks": {
                    return Blocks.f_50126_;
                }
                case "stony_peaks": {
                    return Blocks.f_50069_;
                }
                case "river": {
                    return Blocks.f_50129_;
                }
                case "frozen_river": {
                    return Blocks.f_50126_;
                }
                case "beach": {
                    return Blocks.f_50069_;
                }
                case "snowy_beach": {
                    return Blocks.f_50069_;
                }
                case "stony_shore": {
                    return Blocks.f_50069_;
                }
                case "warm_ocean": {
                    return Blocks.f_50588_;
                }
                case "lukewarm_ocean": {
                    return Blocks.f_50069_;
                }
                case "deep_lukewarm_ocean": {
                    return Blocks.f_50378_;
                }
                case "ocean": {
                    return Blocks.f_50069_;
                }
                case "deep_ocean": {
                    return Blocks.f_50378_;
                }
                case "cold_ocean": {
                    return Blocks.f_50069_;
                }
                case "deep_cold_ocean": {
                    return Blocks.f_50378_;
                }
                case "frozen_ocean": {
                    return Blocks.f_50126_;
                }
                case "deep_frozen_ocean": {
                    return Blocks.f_50568_;
                }
                case "mushroom_fields": {
                    return Blocks.f_50182_;
                }
                case "dripstone_caves": {
                    return Blocks.f_152537_;
                }
                case "lush_caves": {
                    return Blocks.f_50705_;
                }
                case "nether_wastes": {
                    return Blocks.f_50134_;
                }
                case "warped_forest": {
                    return Blocks.f_50656_;
                }
                case "crimson_forest": {
                    return Blocks.f_50655_;
                }
                case "soul_sand_valley": {
                    return Blocks.f_50135_;
                }
                case "basalt_deltas": {
                    return Blocks.f_50137_;
                }
                case "the_end": {
                    return Blocks.f_50259_;
                }
                case "end_highlands": {
                    return Blocks.f_50259_;
                }
                case "end_midlands": {
                    return Blocks.f_50259_;
                }
                case "small_end_islands": {
                    return Blocks.f_50259_;
                }
                case "end_barrens": {
                    return Blocks.f_50259_;
                }
            }
        }
        return null;
    }

    private static Block getBlockFor(String category) {
        if (!Strings.isNullOrEmpty((String)category)) {
            switch (category) {
                case "taiga": {
                    return Blocks.f_50741_;
                }
                case "extreme_hills": {
                    return Blocks.f_50705_;
                }
                case "jungle": {
                    return Blocks.f_50743_;
                }
                case "mesa": {
                    return Blocks.f_50394_;
                }
                case "plains": {
                    return Blocks.f_50705_;
                }
                case "savanna": {
                    return Blocks.f_50744_;
                }
                case "icy": {
                    return Blocks.f_50354_;
                }
                case "the_end": {
                    return Blocks.f_50259_;
                }
                case "beach": {
                    return Blocks.f_50069_;
                }
                case "forest": {
                    return Blocks.f_50742_;
                }
                case "ocean": {
                    return Blocks.f_50069_;
                }
                case "desert": {
                    return Blocks.f_50062_;
                }
                case "river": {
                    return Blocks.f_50129_;
                }
                case "swamp": {
                    return Blocks.f_50705_;
                }
                case "mushroom": {
                    return Blocks.f_50182_;
                }
                case "nether": {
                    return Blocks.f_50134_;
                }
                case "underground": {
                    return Blocks.f_50069_;
                }
                case "mountain": {
                    return Blocks.f_50069_;
                }
            }
        }
        return Blocks.f_50705_;
    }
}

