/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.misc;

import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.multibeds.client.misc.EmbroideryHelper;

public class Embroidery {
    private final byte palette;
    private final byte[] indices;

    private Embroidery(byte palette, byte[] compressed) {
        this.palette = palette;
        this.indices = compressed;
    }

    public byte getPalette() {
        return this.palette;
    }

    public static Embroidery fromUncompressed(byte palette, byte[] uncompressed) {
        byte[] indices = EmbroideryHelper.getBaseCanvasArraySize(uncompressed) == -1 ? Arrays.copyOf(uncompressed, 256) : uncompressed;
        return new Embroidery(palette, (byte[])Embroidery.compressArtWork(indices).getValue());
    }

    public byte[] getIndices() {
        byte[] uncompressed = Embroidery.decompressArtwork(this.indices);
        if (EmbroideryHelper.getBaseCanvasArraySize(uncompressed) == -1) {
            return Arrays.copyOf(uncompressed, 256);
        }
        return uncompressed;
    }

    public static Pair<String, Embroidery> fromShareTag(String shareTag) {
        if (Strings.isNullOrEmpty((String)shareTag)) {
            return null;
        }
        String name = "";
        byte palette = 0;
        String imageData = shareTag;
        if (shareTag.contains(":")) {
            int index;
            String[] split = shareTag.split(":");
            int partCount = split.length;
            imageData = split[partCount - 1].replaceAll(" ", "");
            boolean skip = false;
            if (!split[0].startsWith("#")) {
                name = split[0].trim();
                skip = true;
            }
            int n = index = skip ? 1 : 0;
            while (index < partCount - 1) {
                if (split[index].startsWith("#")) {
                    String number = split[index].substring(1);
                    try {
                        palette = number.startsWith("-") ? (byte)(~Byte.parseByte(number.substring(1), 16)) : Byte.parseByte(number, 16);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++index;
            }
        }
        byte[] indices = new byte[]{};
        try {
            if (imageData.startsWith("0x")) {
                indices = new byte[imageData.length() / 2 - 1];
                for (int index = 2; index < imageData.length(); index += 2) {
                    indices[index / 2 - 1] = (byte)Integer.parseInt(imageData.substring(index, index + 2), 16);
                }
            } else {
                indices = Base64.getDecoder().decode(imageData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (EmbroideryHelper.getBaseCanvasArraySize(Embroidery.decompressArtwork(indices)) > -1) {
            return Pair.of((Object)name, (Object)new Embroidery(palette, indices));
        }
        return null;
    }

    public String buildShareTag(String ... prefix) {
        StringBuilder builder = new StringBuilder();
        for (String data : prefix) {
            builder.append(data).append(":");
        }
        if (this.palette != 0) {
            builder.append("#").append((String)(this.palette < 0 ? "-" + Integer.toHexString(~this.palette) : Integer.toHexString(this.palette))).append(":");
        }
        builder.append(Base64.getEncoder().encodeToString(this.indices));
        return builder.toString();
    }

    public static Embroidery fromNbtTag(CompoundTag tag) {
        if (tag.m_128441_("compressed") && tag.m_128441_("indices")) {
            return Embroidery.fromUncompressed(tag.m_128445_("palette"), tag.m_128471_("compressed") ? Embroidery.decompressArtwork(tag.m_128463_("indices")) : tag.m_128463_("indices"));
        }
        return null;
    }

    public void writeToNbt(CompoundTag tag) {
        Embroidery.writeToNbt(tag, this.getPalette(), this.getIndices());
    }

    public static void writeToNbt(CompoundTag tag, byte palette, byte[] uncompressed) {
        Pair<Boolean, byte[]> result = Embroidery.compressArtWork(uncompressed);
        tag.m_128379_("compressed", ((Boolean)result.getKey()).booleanValue());
        tag.m_128382_("indices", (byte[])result.getValue());
        tag.m_128344_("palette", palette);
    }

    public static void removeFromNbt(CompoundTag tag) {
        tag.m_128473_("compressed");
        tag.m_128473_("indices");
        tag.m_128473_("palette");
    }

    public static Embroidery fromBuffer(FriendlyByteBuf buffer) {
        try {
            return Embroidery.fromUncompressed(buffer.readByte(), Embroidery.decompressArtwork(buffer.m_130052_()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.writeByte((int)this.palette);
        buffer.m_130087_(this.indices);
    }

    private static Pair<Boolean, byte[]> compressArtWork(byte[] artwork) {
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(artwork);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(artwork.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (Exception count) {
            // empty catch block
        }
        byte[] compressed = bos.toByteArray();
        return compressed.length < artwork.length ? Pair.of((Object)true, (Object)compressed) : Pair.of((Object)false, (Object)artwork);
    }

    private static byte[] decompressArtwork(byte[] compressed) {
        if (compressed.length == 0) {
            return compressed;
        }
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressed);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressed.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                return compressed;
            }
        }
        try {
            bos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bos.toByteArray();
    }
}

