/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.client.model.data.ModelProperties;
import shetiphian.core.common.UseContext;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.multibeds.Values;
import shetiphian.multibeds.common.block.BlockLadderBase;

public class TileEntityLadder
extends TileEntityBase {
    private ItemStack itemBedTexture = ItemStack.f_41583_;
    private boolean isColorCached = false;
    private int materialColor = 0xFFFFFF;

    public TileEntityLadder(BlockPos pos, BlockState state) {
        super(Values.tileLadder, pos, state);
    }

    public void buildNBT(CompoundTag nbtTag) {
        if (!this.itemBedTexture.m_41619_()) {
            CompoundTag stack = new CompoundTag();
            this.itemBedTexture.m_41739_(stack);
            nbtTag.m_128365_("texture_item", (Tag)stack);
        }
    }

    public void processNBT(CompoundTag nbtTag) {
        if (nbtTag.m_128441_("texture_item")) {
            this.itemBedTexture = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("texture_item"));
        }
        this.requestModelDataUpdate();
    }

    public void setBedTextureBlock(ItemStack stack) {
        this.itemBedTexture = stack;
    }

    public ItemStack getBedTextureBlock() {
        return this.itemBedTexture;
    }

    public int getMaterialColor() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (!this.isColorCached) {
                this.materialColor = Minecraft.m_91087_().m_91298_().m_92577_(UseContext.getBlockPlacementStateFor((ItemStack)this.getBedTextureBlock(), (Level)this.m_58904_()), (BlockAndTintGetter)this.m_58904_(), this.m_58899_(), 0);
                this.isColorCached = true;
            }
        });
        return this.materialColor;
    }

    public IModelData getModelData() {
        CompoundTag nbtTag = new CompoundTag();
        nbtTag.m_128359_("ladder_type", this.getModelType());
        ItemStack ladderTextureBlock = this.getBedTextureBlock();
        if (!ladderTextureBlock.m_41619_()) {
            CompoundTag material = new CompoundTag();
            ladderTextureBlock.m_41739_(material);
            nbtTag.m_128365_("ladder_material", (Tag)material);
        }
        return new ModelDataMap.Builder().withInitial(ModelProperties.NBTProperty, (Object)nbtTag).build();
    }

    public String getModelType() {
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)BlockLadderBase.f_54337_);
        Level world = this.m_58904_();
        BlockPos pos = this.m_58899_();
        if (world != null) {
            boolean up = this.isSame(direction, world.m_8055_(pos.m_7494_()));
            boolean down = this.isSame(direction, world.m_8055_(pos.m_7495_()));
            return up ? (down ? "middle" : "bottom") : (down ? "top" : "single");
        }
        return "single";
    }

    private boolean isSame(Direction direction, BlockState oState) {
        Block oBlock = oState.m_60734_();
        return oBlock instanceof BlockLadderBase && ((Direction)oState.m_61143_((Property)BlockLadderBase.f_54337_)).equals((Object)direction);
    }
}

