/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.client.model.data.ModelProperties;
import shetiphian.core.common.UseContext;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.multibeds.Values;
import shetiphian.multibeds.common.block.BlockMultiBedBase;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemBlanket;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.item.ItemPillowSheet;
import shetiphian.multibeds.common.misc.BiomeTexture;
import shetiphian.multibeds.common.misc.Embroidery;
import shetiphian.multibeds.common.misc.EnumBedStyle;
import shetiphian.multibeds.common.misc.EnumBlanket;
import shetiphian.multibeds.common.misc.EnumSpreadArt;

public class TileEntityMultiBed
extends TileEntityBase {
    private static final RGB16 RGB_WHITE = new RGB16("white");
    private ItemStack itemBedTexture = ItemStack.f_41583_;
    private ItemStack itemSheet = ItemStack.f_41583_;
    private ItemStack itemPillow = ItemStack.f_41583_;
    private ItemStack itemBlanket = ItemStack.f_41583_;
    private boolean mirror = false;
    private int sheetColor = RGB_WHITE.getColor();
    private int pillowColor = RGB_WHITE.getColor();
    private EnumBlanket spreadBlanket = EnumBlanket.NONE;
    private EnumSpreadArt spreadArt = EnumSpreadArt.NONE;
    private BannerBlockEntity bannerEntity = null;
    private ResourceLocation artLocation = null;
    private Triple<String, Byte, byte[]> artData = null;
    private boolean isColorCached = false;
    private int materialColor = 0xFFFFFF;
    private boolean needsDefaultTexture = false;

    public TileEntityMultiBed(BlockPos pos, BlockState state) {
        super(Values.tileBed, pos, state);
    }

    public void buildNBT(CompoundTag nbtTag) {
        CompoundTag stack;
        if (!this.itemBedTexture.m_41619_()) {
            stack = new CompoundTag();
            this.itemBedTexture.m_41739_(stack);
            nbtTag.m_128365_("texture_item", (Tag)stack);
        }
        if (!this.itemSheet.m_41619_()) {
            stack = new CompoundTag();
            this.itemSheet.m_41739_(stack);
            nbtTag.m_128365_("sheet_item", (Tag)stack);
        }
        if (!this.itemPillow.m_41619_()) {
            stack = new CompoundTag();
            this.itemPillow.m_41739_(stack);
            nbtTag.m_128365_("pillow_item", (Tag)stack);
        }
        if (!this.itemBlanket.m_41619_()) {
            stack = new CompoundTag();
            this.itemBlanket.m_41739_(stack);
            nbtTag.m_128365_("blanket_item", (Tag)stack);
            nbtTag.m_128379_("mirror", this.mirror);
        }
    }

    public void processNBT(CompoundTag nbtTag) {
        if (nbtTag.m_128441_("texture_item")) {
            this.itemBedTexture = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("texture_item"));
        } else if (this.m_58904_() != null) {
            this.applyDefaultTexture();
        } else {
            this.needsDefaultTexture = true;
        }
        if (nbtTag.m_128441_("sheet_item")) {
            this.setSheetItem(ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("sheet_item")));
        } else {
            this.removeSheet();
        }
        if (nbtTag.m_128441_("pillow_item")) {
            this.setPillowItem(ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("pillow_item")));
        } else {
            this.removePillow();
        }
        if (nbtTag.m_128441_("blanket_item")) {
            this.setBlanketItem(ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("blanket_item")), nbtTag.m_128471_("mirror"));
        } else {
            this.removeBlanket();
        }
        this.requestModelDataUpdate();
    }

    public void m_142339_(Level world) {
        super.m_142339_(world);
        if (this.needsDefaultTexture) {
            this.applyDefaultTexture();
        }
    }

    private void applyDefaultTexture() {
        if ((this.itemBedTexture == null || this.itemBedTexture.m_41619_()) && this.f_58857_ != null) {
            this.itemBedTexture = BiomeTexture.getStackFor(this.f_58857_.m_46857_(this.m_58899_()));
        }
    }

    public void setBedTextureBlock(ItemStack stack) {
        this.itemBedTexture = stack;
    }

    public ItemStack getBedTextureBlock() {
        return this.itemBedTexture;
    }

    public boolean isBedFoot() {
        return this.m_58900_().m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT;
    }

    public Direction getFacing() {
        return this.m_58900_().getBedDirection((LevelReader)this.m_58904_(), this.m_58899_());
    }

    public boolean hasSheet() {
        return !this.itemSheet.m_41619_();
    }

    public void removeSheet() {
        this.itemSheet = ItemStack.f_41583_;
        this.sheetColor = RGB_WHITE.getColor();
    }

    public boolean setSheetItem(ItemStack stack) {
        Item item;
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof ItemPillowSheet && ((ItemPillowSheet)item).getType() == ItemBedCustomization.EnumType.SHEET) {
            this.itemSheet = stack.m_41777_().m_41620_(1);
            this.sheetColor = ((ItemPillowSheet)item).getRenderColor(stack);
            return true;
        }
        return false;
    }

    public ItemStack getSheetItem() {
        return this.itemSheet;
    }

    public int getSheetColor() {
        return this.sheetColor;
    }

    public boolean hasPillow() {
        return !this.itemPillow.m_41619_();
    }

    public void removePillow() {
        this.itemPillow = ItemStack.f_41583_;
        this.pillowColor = RGB_WHITE.getColor();
    }

    public boolean setPillowItem(ItemStack stack) {
        Item item;
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof ItemPillowSheet && ((ItemPillowSheet)item).getType() == ItemBedCustomization.EnumType.PILLOW) {
            this.itemPillow = stack.m_41777_().m_41620_(1);
            this.pillowColor = ((ItemPillowSheet)item).getRenderColor(stack);
            return true;
        }
        return false;
    }

    public ItemStack getPillowItem() {
        return this.itemPillow;
    }

    public int getPillowColor() {
        return this.pillowColor;
    }

    public boolean hasBlanket() {
        return !this.itemBlanket.m_41619_();
    }

    public void removeBlanket() {
        this.itemBlanket = ItemStack.f_41583_;
        this.spreadBlanket = EnumBlanket.NONE;
        this.bannerEntity = null;
        this.removeArt();
    }

    public EnumBlanket getBlanketType() {
        return this.spreadBlanket;
    }

    public boolean setBlanketItem(ItemStack stack, boolean mirror) {
        if (!stack.m_41619_()) {
            Item item = stack.m_41720_();
            if (item instanceof BannerItem) {
                this.setArt(stack);
                this.itemBlanket = stack.m_41777_().m_41620_(1);
                this.spreadBlanket = EnumBlanket.BANNER;
                this.mirror = mirror;
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                    this.bannerEntity = null;
                    this.bannerEntity = new BannerBlockEntity(this.m_58899_(), ((BannerItem)item).m_40614_().m_49966_());
                    this.bannerEntity.m_58489_(stack, ((BannerItem)stack.m_41720_()).m_40545_());
                });
                return true;
            }
            if (item instanceof ItemBlanket) {
                this.setArt(stack);
                this.itemBlanket = stack.m_41777_().m_41620_(1);
                this.spreadBlanket = ItemBlanket.getBlanket(stack);
                this.bannerEntity = null;
                return true;
            }
        }
        return false;
    }

    public ItemStack getBlanketItem() {
        return this.itemBlanket;
    }

    public boolean isMirrored() {
        return this.mirror;
    }

    public boolean hasArt() {
        return this.getArtType() != EnumSpreadArt.NONE;
    }

    public void removeArt() {
        this.artData = null;
        this.artLocation = null;
        this.spreadArt = EnumSpreadArt.NONE;
    }

    public void setArt(ItemStack stack) {
        if (!stack.m_41619_()) {
            Embroidery embroidery;
            this.removeArt();
            this.spreadArt = ItemEmbroideryThread.getArtwork(stack);
            if (this.getArtType() == EnumSpreadArt.CUSTOM && (embroidery = ItemEmbroideryThread.getArtworkEmbroidery(stack)) != null) {
                String artTextureKey = Integer.toHexString(embroidery.hashCode());
                this.artData = Triple.of((Object)artTextureKey, (Object)embroidery.getPalette(), (Object)embroidery.getIndices());
            }
        }
    }

    public EnumSpreadArt getArtType() {
        return this.spreadArt;
    }

    public BannerBlockEntity getBannerEntity() {
        return this.bannerEntity;
    }

    public Triple<String, Byte, byte[]> getArtData() {
        return this.artData;
    }

    public void setArtLocation(ResourceLocation location) {
        this.artLocation = location;
    }

    public ResourceLocation getCustomArt() {
        return this.artLocation;
    }

    public int getMaterialColor() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (!this.isColorCached) {
                this.materialColor = Minecraft.m_91087_().m_91298_().m_92577_(UseContext.getBlockPlacementStateFor((ItemStack)this.getBedTextureBlock(), (Level)this.m_58904_()), (BlockAndTintGetter)this.m_58904_(), this.m_58899_(), 0);
                this.isColorCached = true;
            }
        });
        return this.materialColor;
    }

    public AABB getRenderBoundingBox() {
        if (this.bannerEntity != null && this.isBedFoot()) {
            return new AABB(this.f_58858_, this.f_58858_.m_142300_(this.getFacing())).m_82363_(1.0, 0.5, 1.0);
        }
        return super.getRenderBoundingBox();
    }

    public IModelData getModelData() {
        CompoundTag nbtTag = new CompoundTag();
        nbtTag.m_128359_("bed_type", this.getModelType());
        ItemStack bedTextureBlock = this.getBedTextureBlock();
        if (!bedTextureBlock.m_41619_()) {
            CompoundTag material = new CompoundTag();
            bedTextureBlock.m_41739_(material);
            nbtTag.m_128365_("bed_material", (Tag)material);
        }
        nbtTag.m_128379_("has_sheet", this.hasSheet());
        nbtTag.m_128379_("has_pillowcase", this.hasPillow());
        nbtTag.m_128359_("blanket_type", this.getBlanketType().m_7912_());
        nbtTag.m_128359_("art_type", this.getArtType().m_7912_());
        return new ModelDataMap.Builder().withInitial(ModelProperties.NBTProperty, (Object)nbtTag).build();
    }

    public String getModelType() {
        BlockState state = this.m_58900_();
        Level world = this.m_58904_();
        BlockPos pos = this.m_58899_();
        EnumBedStyle style = ((BlockMultiBedBase)state.m_60734_()).getBedStyle();
        String typeBunk = "single";
        String typeGang = "single";
        if (style.isBunkable()) {
            boolean down = this.isSame(state, world.m_8055_(pos.m_7495_()), style);
            boolean up = this.isSame(state, world.m_8055_(pos.m_7494_()), style);
            String string = down && up ? "bunk_middle" : (down ? "bunk_top" : (typeBunk = up ? "bunk_bottom" : "single"));
        }
        if (style.isGangable()) {
            Direction facing = (Direction)state.m_61143_((Property)BlockMultiBedBase.f_54117_);
            boolean left = this.isSame(state, world.m_8055_(pos.m_142300_(facing.m_122428_())), style);
            boolean right = this.isSame(state, world.m_8055_(pos.m_142300_(facing.m_122427_())), style);
            String string = left && right ? "middle" : (left ? "right" : (typeGang = right ? "left" : "single"));
        }
        if (!typeBunk.equalsIgnoreCase("single")) {
            if (!typeGang.equalsIgnoreCase("single")) {
                return typeBunk + "#" + typeGang;
            }
            return typeBunk + "#" + typeBunk;
        }
        return typeGang + "#" + typeGang;
    }

    private boolean isSame(BlockState state, BlockState oState, EnumBedStyle style) {
        Block oBlock = oState.m_60734_();
        return oBlock instanceof BlockMultiBedBase && ((BedPart)oState.m_61143_((Property)BlockMultiBedBase.f_49440_)).equals((Object)state.m_61143_((Property)BlockMultiBedBase.f_49440_)) && ((Direction)oState.m_61143_((Property)BlockMultiBedBase.f_54117_)).equals((Object)state.m_61143_((Property)BlockMultiBedBase.f_54117_)) && ((BlockMultiBedBase)oBlock).getBedStyle() == style;
    }
}

