/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds;

import com.mojang.logging.LogUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import shetiphian.multibeds.Configuration;
import shetiphian.multibeds.Register;
import shetiphian.multibeds.client.misc.EmbroideryData;
import shetiphian.multibeds.client.misc.EventHandlerClient;
import shetiphian.multibeds.client.render.RenderRegistry;
import shetiphian.multibeds.common.misc.EventHandler;
import shetiphian.multibeds.common.network.NetworkHandler;
import shetiphian.multibeds.modintegration.ModIntegration;

@Mod(value="multibeds")
public class MultiBeds {
    public static final String MOD_ID = "multibeds";
    public static MultiBeds INSTANCE;
    public static Logger LOGGER;

    public MultiBeds() {
        INSTANCE = this;
        LOGGER = LogUtils.getLogger();
        IEventBus MOD_EVENT_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        MOD_EVENT_BUS.addListener(this::commonSetup);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> MOD_EVENT_BUS.addListener(this::clientSetup));
        MOD_EVENT_BUS.addListener(this::init);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Configuration.SPEC_CLIENT, "multibeds-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.SPEC_COMMON, "multibeds.toml");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        RenderRegistry.setupNow();
        event.enqueueWork(RenderRegistry::setupLater);
        event.enqueueWork(Register::registerScreenFactories);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClient());
        EmbroideryData.INSTANCE.loadData();
    }

    private void init(InterModEnqueueEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        NetworkHandler.initialise(MOD_ID);
        ModIntegration.INSTANCE.load();
    }
}

