/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.gui.EntityGuiItem;
import shetiphian.multibeds.client.gui.Textures;
import shetiphian.multibeds.common.inventory.ContainerBuilder;
import shetiphian.multibeds.common.misc.EnumBedStyle;

@OnlyIn(value=Dist.CLIENT)
public class GuiBuilder
extends AbstractContainerScreen<ContainerBuilder> {
    private final Player player;
    private EntityGuiItem displayItem = null;
    private Component displayName = TextComponent.f_131282_;

    public GuiBuilder(ContainerBuilder screenContainer, Inventory inv, Component title) {
        super((AbstractContainerMenu)screenContainer, inv, title);
        this.player = inv.f_35978_;
        this.f_97726_ = 182;
        this.f_97727_ = 233;
        ((ContainerBuilder)this.f_97732_).setInventoryChangeCallback(this::updatePreview);
        this.updatePreview();
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        if (((ContainerBuilder)this.f_97732_).getBuilderMode() == ContainerBuilder.BuilderMode.BED) {
            this.m_142416_(new ButtonIndex(this.f_97735_ + 44, this.f_97736_ + 11, -1));
            this.m_142416_(new ButtonIndex(this.f_97735_ + 128, this.f_97736_ + 11, 1));
        }
    }

    private void updatePreview() {
        try {
            this.displayItem = new EntityGuiItem(this.player.f_19853_, 0.0, 0.0, 0.0, ((ContainerBuilder)this.f_97732_).getPreviewItem().m_41777_().m_41620_(1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (((ContainerBuilder)this.f_97732_).getBuilderMode() == ContainerBuilder.BuilderMode.BED) {
            this.displayName = new TranslatableComponent("block.multibeds." + EnumBedStyle.byIndex(((ContainerBuilder)this.f_97732_).getBedStyleIndex()).getString());
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        if (this.displayItem != null) {
            int top = this.f_97736_ + (((ContainerBuilder)this.f_97732_).getBuilderMode() == ContainerBuilder.BuilderMode.BED ? 82 : 88);
            this.displayItem.render(this.getMinecraft(), true, 160.0f, 0.0f, 0.0f, (float)(this.f_97735_ + 91), (float)top, 50.0f, -120.0f, 120.0f, 120.0f);
        }
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(matrixStack);
        GuiFunctions.enterDrawTextureStateWithBlend();
        RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.BED_KIT.get());
        this.m_93228_(matrixStack, this.f_97735_, this.f_97736_, 0, 23, this.f_97726_, this.f_97727_);
        Slot slot = ((ContainerBuilder)this.f_97732_).getSlotBaseItem();
        if (!slot.m_6657_() && ((ContainerBuilder)this.f_97732_).getBuilderMode() == ContainerBuilder.BuilderMode.BED) {
            this.m_93228_(matrixStack, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, 224, 16, 16, 16);
        }
        if (!(slot = ((ContainerBuilder)this.f_97732_).getSlotMaterial()).m_6657_()) {
            this.m_93228_(matrixStack, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, 240, 16, 16, 16);
        }
        GuiBuilder.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.displayName, (int)(this.f_96543_ / 2), (int)(this.f_97736_ + 11), (int)0x404040);
        GuiFunctions.exitDrawTextureStateWithBlend();
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
    }

    private class ButtonIndex
    extends Button
    implements GuiEventListener {
        int shift;

        ButtonIndex(int posX, int posY, int indexShift) {
            super(posX, posY, 12, 9, TextComponent.f_131282_, null);
            this.shift = indexShift;
        }

        public void m_5691_() {
            if (this.f_93622_) {
                int index = ((ContainerBuilder)GuiBuilder.this.f_97732_).getBedStyleIndex();
                int max = EnumBedStyle.values().length - 1;
                index += this.shift;
                MultiPlayerGameMode controller = Minecraft.m_91087_().f_91072_;
                if (controller != null) {
                    controller.m_105208_(((ContainerBuilder)((GuiBuilder)GuiBuilder.this).f_97732_).f_38840_, index < 0 ? max : (index > max ? 0 : index));
                }
            }
        }

        public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.BED_KIT.get());
            GuiFunctions.enterDrawTextureStateWithBlend();
            int index = (this.shift > 0 ? 1 : 0) + (this.f_93622_ ? 2 : 0);
            this.m_93228_(matrixStack, this.f_93620_, this.f_93621_, 194 + index * 16, 5, this.f_93618_, this.f_93619_);
            GuiFunctions.exitDrawTextureStateWithBlend();
        }
    }
}

