/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.gui;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.awt.Point;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.core.client.gui.AbstractWidgetList;
import shetiphian.multibeds.MultiBeds;
import shetiphian.multibeds.client.gui.EmbroideryPage_Draw;
import shetiphian.multibeds.client.gui.EmbroideryPage_Scale;
import shetiphian.multibeds.client.gui.Textures;
import shetiphian.multibeds.client.misc.EmbroideryData;
import shetiphian.multibeds.client.misc.WIPProject;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.misc.Embroidery;
import shetiphian.multibeds.common.misc.EnumSpreadArt;
import shetiphian.multibeds.common.network.NetworkHandler;
import shetiphian.multibeds.common.network.PacketEmbroidery;
import shetiphian.multibeds.common.network.PacketShareTag;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

@OnlyIn(value=Dist.CLIENT)
public class GuiEmbroidery
extends Screen {
    private final String TEXT_CREATE = I18n.m_118938_((String)"gui.multibeds.embroidery.create", (Object[])new Object[0]);
    private final String TEXT_CREATE_INFO = I18n.m_118938_((String)"gui.multibeds.embroidery.create.info", (Object[])new Object[0]);
    private final String TEXT_PASTE_TAG = I18n.m_118938_((String)"gui.multibeds.embroidery.paste_tag", (Object[])new Object[0]);
    private final String TEXT_APPLY = I18n.m_118938_((String)"gui.multibeds.embroidery.button.apply", (Object[])new Object[0]);
    private final String TEXT_APPLY_INFO = I18n.m_118938_((String)"gui.multibeds.embroidery.apply.info", (Object[])new Object[0]);
    private final String TEXT_REMOVE = I18n.m_118938_((String)"gui.multibeds.embroidery.button.remove", (Object[])new Object[0]);
    private final String TEXT_REMOVE_INFO = I18n.m_118938_((String)"gui.multibeds.embroidery.remove.info", (Object[])new Object[0]);
    private final String TEXT_ERROR_NO_SELECTION = I18n.m_118938_((String)"gui.multibeds.embroidery.error.no_selection", (Object[])new Object[0]);
    private final String TEXT_ERROR_NO_THREAD = I18n.m_118938_((String)"gui.multibeds.embroidery.error.no_thread", (Object[])new Object[0]);
    private final String TEXT_ERROR_NO_ART = I18n.m_118938_((String)"gui.multibeds.embroidery.error.no_art", (Object[])new Object[0]);
    private final String TEXT_ERROR_NO_BED = I18n.m_118938_((String)"gui.multibeds.embroidery.error.no_bed", (Object[])new Object[0]);
    private final String TEXT_COPY = I18n.m_118938_((String)"gui.multibeds.embroidery.copy", (Object[])new Object[0]);
    private final String TEXT_EDIT = I18n.m_118938_((String)"gui.multibeds.embroidery.edit", (Object[])new Object[0]);
    private final String TEXT_DELETE = I18n.m_118938_((String)"gui.multibeds.embroidery.delete", (Object[])new Object[0]);
    private final String TEXT_FAVORITE = I18n.m_118938_((String)"gui.multibeds.embroidery.favorite", (Object[])new Object[0]);
    private final String TEXT_UNFAVORITE = I18n.m_118938_((String)"gui.multibeds.embroidery.unfavorite", (Object[])new Object[0]);
    private final String TEXT_SHARE = I18n.m_118938_((String)"gui.multibeds.embroidery.share", (Object[])new Object[0]);
    private final String TEXT_TAB_EMBEDDED = I18n.m_118938_((String)"gui.multibeds.embroidery.tab.embedded", (Object[])new Object[0]);
    private final String TEXT_TAB_CUSTOM = I18n.m_118938_((String)"gui.multibeds.embroidery.tab.custom", (Object[])new Object[0]);
    private final String TEXT_TAB_FAVORITE = I18n.m_118938_((String)"gui.multibeds.embroidery.tab.favorite", (Object[])new Object[0]);
    private final String TEXT_TAB_SESSION = I18n.m_118938_((String)"gui.multibeds.embroidery.tab.session", (Object[])new Object[0]);
    private final String TEXT_TAB_WEB = I18n.m_118938_((String)"gui.multibeds.embroidery.tab.web", (Object[])new Object[0]);
    private final String TEXT_TAB_PROJECT = I18n.m_118938_((String)"gui.multibeds.embroidery.tab.projects", (Object[])new Object[0]);
    final EmbroideryPage_Draw pageDraw = new EmbroideryPage_Draw(this);
    final EmbroideryPage_Scale pageScale = new EmbroideryPage_Scale(this);
    private final WidgetEntry buttonCreateNew = new WidgetEntryNew();
    private final WidgetEntry buttonPasteShare = new WidgetEntryPasteShareTag();
    private final BlockPos pos;
    private final boolean bedClicked;
    private final boolean canApply;
    private final boolean canRemove;
    private final EnumSpreadArt currentArt;
    private final int xSize = 230;
    private final int ySize = 160;
    private int guiLeft;
    private int guiTop;
    private String lastToolTip;
    private int countToolTip;
    ActivePage activePage = ActivePage.SELECT;
    boolean scaleLayer = false;
    private WidgetList listBuiltIn;
    private WidgetList listCustom;
    private WidgetList listFavorite;
    private WidgetList listSession;
    private WidgetList listWebpage;
    private WidgetList listProjects;
    private WidgetList selectedWidgetList;
    private WidgetEntry selectedWidget;
    private WidgetEntry hoveredWidget;
    private Point tabBuiltin;
    private Point tabCustom;
    private Point tabFavorite;
    private Point tabSession;
    private Point tabWebpage;
    private Point tabProjects;
    private Point btnApply;
    private Point btnRemove;
    private final Point btnCopy = new Point();
    private final Point btnDelete = new Point();
    private final Point btnFavorite = new Point();
    private final Point btnShare = new Point();

    public GuiEmbroidery(BlockPos pos, boolean hasThread, TileEntityMultiBed[] tiles) {
        super((Component)new TextComponent(""));
        this.pos = pos;
        this.bedClicked = tiles != null;
        this.canApply = hasThread && this.bedClicked;
        boolean bl = this.canRemove = this.bedClicked && (tiles[0].hasArt() || tiles[1].hasArt());
        EnumSpreadArt enumSpreadArt = this.canRemove ? (tiles[0].hasArt() ? tiles[0].getArtType() : tiles[1].getArtType()) : (this.currentArt = EnumSpreadArt.NONE);
        if (this.currentArt == EnumSpreadArt.CUSTOM) {
            Embroidery embroidery;
            Embroidery embroidery2 = embroidery = tiles[0].hasArt() ? ItemEmbroideryThread.getArtworkEmbroidery(tiles[0].getBlanketItem()) : ItemEmbroideryThread.getArtworkEmbroidery(tiles[1].getBlanketItem());
            if (embroidery != null) {
                this.selectedWidget = new WidgetEntryBytes("Current", embroidery);
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.listBuiltIn = new WidgetList(this.f_96541_, this.guiLeft + 96, this.guiTop + 16, 112, 128);
        this.listCustom = new WidgetList(this.f_96541_, this.guiLeft + 96, this.guiTop + 16, 112, 128);
        this.listFavorite = new WidgetList(this.f_96541_, this.guiLeft + 96, this.guiTop + 16, 112, 128);
        this.listSession = new WidgetList(this.f_96541_, this.guiLeft + 96, this.guiTop + 16, 112, 128);
        this.listWebpage = new WidgetList(this.f_96541_, this.guiLeft + 96, this.guiTop + 16, 112, 128);
        this.listProjects = new WidgetList(this.f_96541_, this.guiLeft + 96, this.guiTop + 16, 112, 128);
        this.tabBuiltin = new Point(215 + this.guiLeft, 32 + this.guiTop);
        this.tabCustom = new Point(215 + this.guiLeft, 48 + this.guiTop);
        this.tabFavorite = new Point(215 + this.guiLeft, 64 + this.guiTop);
        this.tabSession = new Point(215 + this.guiLeft, 80 + this.guiTop);
        this.tabWebpage = new Point(215 + this.guiLeft, 96 + this.guiTop);
        this.tabProjects = new Point(215 + this.guiLeft, 112 + this.guiTop);
        this.btnApply = new Point(16 + this.guiLeft, 112 + this.guiTop);
        this.btnRemove = new Point(16 + this.guiLeft, 128 + this.guiTop);
        for (EnumSpreadArt art : EnumSpreadArt.values()) {
            if (art == EnumSpreadArt.NONE || art == EnumSpreadArt.CUSTOM) continue;
            if (art == this.currentArt) {
                WidgetEntryArt widgetEntryArt = new WidgetEntryArt(art);
                this.listBuiltIn.addEntry(widgetEntryArt);
                this.selectedWidget = widgetEntryArt;
                this.listBuiltIn.m_6987_(widgetEntryArt);
                continue;
            }
            this.listBuiltIn.addEntry(new WidgetEntryArt(art));
        }
        this.buildListCustom();
        this.buildListFavorite();
        this.buildListSession();
        this.buildListWebpage();
        this.buildListProjects();
        this.updateSelectedWidgetList(this.listFavorite.m_6702_().isEmpty() ? this.listBuiltIn : this.listFavorite, false);
        this.pageDraw.init();
        this.pageScale.init();
    }

    void buildListCustom() {
        this.listCustom.m_6702_().clear();
        this.listCustom.addEntry(this.buttonCreateNew);
        for (String name : EmbroideryData.getNames()) {
            this.listCustom.addEntry(new WidgetEntryBytes(name, EmbroideryData.get(name)));
        }
        Collections.sort(this.listCustom.m_6702_());
    }

    private void buildListFavorite() {
        this.listFavorite.m_6702_().clear();
        for (String name : EmbroideryData.getFavorites()) {
            Embroidery embroidery;
            String[] entry = name.split(":");
            if (entry.length != 2) continue;
            if (entry[0].equalsIgnoreCase("inc")) {
                EnumSpreadArt art = EnumSpreadArt.byName(entry[1]);
                if (art == EnumSpreadArt.NONE || art == EnumSpreadArt.CUSTOM) continue;
                this.listFavorite.addEntry(new WidgetEntryArt(art));
                continue;
            }
            if (!entry[0].equalsIgnoreCase("per") || (embroidery = EmbroideryData.getFavorite(name)) == null) continue;
            this.listFavorite.addEntry(new WidgetEntryBytes(entry[1], embroidery));
        }
        Collections.sort(this.listFavorite.m_6702_());
    }

    private void buildListSession() {
        this.listSession.m_6702_().clear();
        this.listSession.addEntry(this.buttonPasteShare);
        for (String name : EmbroideryData.getSessionItems()) {
            this.listSession.addEntry(new WidgetEntryBytes(name, EmbroideryData.getSessionItem(name)));
        }
    }

    private void buildListWebpage() {
        this.listWebpage.m_6702_().clear();
        for (String name : EmbroideryData.getWebItems()) {
            this.listWebpage.addEntry(new WidgetEntryBytes(name, EmbroideryData.getWebItem(name)));
        }
        Collections.sort(this.listWebpage.m_6702_());
    }

    void buildListProjects() {
        this.listProjects.m_6702_().clear();
        for (String name : EmbroideryData.getProjects()) {
            this.listProjects.addEntry(new WidgetProject(name, EmbroideryData.getProject(name)));
        }
        Collections.sort(this.listProjects.m_6702_());
    }

    private boolean updateSelectedWidgetList(WidgetList widgetList, boolean setSelected) {
        if (this.selectedWidgetList != widgetList) {
            this.selectedWidgetList = widgetList;
            if (setSelected) {
                this.selectedWidget = (WidgetEntry)this.selectedWidgetList.m_93511_();
            }
            int x = 16 + this.guiLeft;
            int y = 88 + this.guiTop;
            if (this.selectedWidgetList == this.listBuiltIn) {
                this.btnCopy.setLocation(x + 16, y);
                this.btnShare.setLocation(0, 0);
                this.btnFavorite.setLocation(x + 32, y);
                this.btnDelete.setLocation(0, 0);
            } else if (this.selectedWidgetList == this.listCustom) {
                this.btnCopy.setLocation(x + 16, y);
                this.btnShare.setLocation(x + 32, y);
                this.btnFavorite.setLocation(x + 48, y);
                this.btnDelete.setLocation(x, y);
            } else if (this.selectedWidgetList == this.listFavorite) {
                this.btnCopy.setLocation(x + 24, y);
                this.btnShare.setLocation(x + 40, y);
                this.btnFavorite.setLocation(x + 8, y);
                this.btnDelete.setLocation(0, 0);
            } else if (this.selectedWidgetList == this.listSession) {
                this.btnCopy.setLocation(x + 16, y);
                this.btnShare.setLocation(x + 32, y);
                this.btnFavorite.setLocation(0, 0);
                this.btnDelete.setLocation(0, 0);
            } else if (this.selectedWidgetList == this.listWebpage) {
                this.btnCopy.setLocation(x + 24, y);
                this.btnShare.setLocation(0, 0);
                this.btnFavorite.setLocation(0, 0);
                this.btnDelete.setLocation(0, 0);
            } else if (this.selectedWidgetList == this.listProjects) {
                this.btnCopy.setLocation(x + 16, y);
                this.btnShare.setLocation(0, 0);
                this.btnFavorite.setLocation(0, 0);
                this.btnDelete.setLocation(x + 32, y);
            }
            return true;
        }
        return false;
    }

    public void m_96624_() {
        super.m_96624_();
        if (this.activePage == ActivePage.DRAW && !this.scaleLayer) {
            this.pageDraw.tick();
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        GuiFunctions.enterDrawTextureStateWithBlend();
        RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.EMBROIDERY.get());
        this.m_93228_(matrixStack, this.guiLeft, this.guiTop, 0, 0, 239, 158);
        GuiFunctions.exitDrawTextureStateWithBlend();
        if (this.activePage == ActivePage.DRAW) {
            this.pageDraw.render(matrixStack, mouseX, mouseY, partialTicks);
        }
        if (this.activePage == ActivePage.SCALE || this.activePage == ActivePage.DRAW && this.scaleLayer) {
            this.pageScale.render(matrixStack, mouseX, mouseY, partialTicks);
        }
        if (this.activePage == ActivePage.SELECT) {
            boolean hasSelection;
            WidgetEntry draw;
            String tooltip = "";
            this.selectedWidgetList.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.EMBROIDERY.get());
            this.m_93228_(matrixStack, this.guiLeft + 95, this.guiTop + 4, 96, 4, 118, 12);
            this.m_93228_(matrixStack, this.guiLeft + 95, this.guiTop + 144, 96, 144, 118, 12);
            GuiFunctions.enterDrawTextureStateWithBlend();
            WidgetEntry widgetEntry = draw = this.hoveredWidget != null ? this.hoveredWidget : this.selectedWidget;
            if (draw != null) {
                draw.renderPreview(matrixStack, this.guiLeft + 16, this.guiTop + 16);
            }
            this.hoveredWidget = null;
            boolean isActive = this.selectedWidgetList == this.listBuiltIn;
            this.m_93228_(matrixStack, this.tabBuiltin.x, this.tabBuiltin.y, 208, isActive ? 240 : 224, 16, 16);
            GuiFunctions.drawTextureScaled((PoseStack)matrixStack, (double)(this.tabBuiltin.x + (isActive ? 2 : 1)), (double)(this.tabBuiltin.y + 2), (int)0, (int)208, (int)16, (int)16, (double)0.7, (float)1.0f, (int[])new int[0]);
            isActive = this.selectedWidgetList == this.listCustom;
            this.m_93228_(matrixStack, this.tabCustom.x, this.tabCustom.y, 208, isActive ? 240 : 224, 16, 16);
            GuiFunctions.drawTextureScaled((PoseStack)matrixStack, (double)(this.tabCustom.x + (isActive ? 2 : 1)), (double)(this.tabCustom.y + 2), (int)16, (int)208, (int)16, (int)16, (double)0.7, (float)1.0f, (int[])new int[0]);
            isActive = this.selectedWidgetList == this.listFavorite;
            this.m_93228_(matrixStack, this.tabFavorite.x, this.tabFavorite.y, 208, isActive ? 240 : 224, 16, 16);
            GuiFunctions.drawTextureScaled((PoseStack)matrixStack, (double)(this.tabFavorite.x + (isActive ? 2 : 1)), (double)(this.tabFavorite.y + 2), (int)48, (int)208, (int)16, (int)16, (double)0.7, (float)1.0f, (int[])new int[0]);
            isActive = this.selectedWidgetList == this.listSession;
            this.m_93228_(matrixStack, this.tabSession.x, this.tabSession.y, 208, isActive ? 240 : 224, 16, 16);
            GuiFunctions.drawTextureScaled((PoseStack)matrixStack, (double)(this.tabSession.x + (isActive ? 2 : 1)), (double)(this.tabSession.y + 2), (int)32, (int)208, (int)16, (int)16, (double)0.7, (float)1.0f, (int[])new int[0]);
            isActive = this.selectedWidgetList == this.listWebpage;
            this.m_93228_(matrixStack, this.tabWebpage.x, this.tabWebpage.y, 208, isActive ? 240 : 224, 16, 16);
            GuiFunctions.drawTextureScaled((PoseStack)matrixStack, (double)(this.tabWebpage.x + (isActive ? 2 : 1)), (double)(this.tabWebpage.y + 2), (int)64, (int)208, (int)16, (int)16, (double)0.7, (float)1.0f, (int[])new int[0]);
            boolean isProject = this.selectedWidgetList == this.listProjects;
            this.m_93228_(matrixStack, this.tabProjects.x, this.tabProjects.y, 208, isProject ? 240 : 224, 16, 16);
            GuiFunctions.drawTextureScaled((PoseStack)matrixStack, (double)(this.tabProjects.x + (isProject ? 2 : 1)), (double)(this.tabProjects.y + 2), (int)0, (int)192, (int)16, (int)16, (double)0.7, (float)1.0f, (int[])new int[0]);
            if (this.isMouseOverArea(mouseX, mouseY, this.tabBuiltin, 16, 16)) {
                tooltip = this.TEXT_TAB_EMBEDDED;
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.tabCustom, 16, 16)) {
                tooltip = this.TEXT_TAB_CUSTOM;
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.tabFavorite, 16, 16)) {
                tooltip = this.TEXT_TAB_FAVORITE;
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.tabSession, 16, 16)) {
                tooltip = this.TEXT_TAB_SESSION;
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.tabWebpage, 16, 16)) {
                tooltip = this.TEXT_TAB_WEB;
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.tabProjects, 16, 16)) {
                tooltip = this.TEXT_TAB_PROJECT;
            }
            boolean bl = hasSelection = this.selectedWidget != null;
            if (this.isMouseOverArea(mouseX, mouseY, this.btnApply, 64, 16)) {
                tooltip = this.canApply ? (!hasSelection ? this.TEXT_ERROR_NO_SELECTION : this.TEXT_APPLY_INFO) : (this.bedClicked ? this.TEXT_ERROR_NO_THREAD : this.TEXT_ERROR_NO_BED);
                this.m_93228_(matrixStack, this.btnApply.x, this.btnApply.y, 80, hasSelection && this.canApply ? 224 : 208, 64, 16);
            } else {
                this.m_93228_(matrixStack, this.btnApply.x, this.btnApply.y, 80, hasSelection && this.canApply ? 240 : 208, 64, 16);
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.btnRemove, 64, 16)) {
                tooltip = this.canRemove ? this.TEXT_REMOVE_INFO : (this.bedClicked ? this.TEXT_ERROR_NO_ART : this.TEXT_ERROR_NO_BED);
                this.m_93228_(matrixStack, this.btnRemove.x, this.btnRemove.y, 144, this.canRemove ? 224 : 208, 64, 16);
            } else {
                this.m_93228_(matrixStack, this.btnRemove.x, this.btnRemove.y, 144, this.canRemove ? 240 : 208, 64, 16);
            }
            if (hasSelection) {
                if (this.isActive(this.btnCopy)) {
                    if (this.isMouseOverArea(mouseX, mouseY, this.btnCopy, 16)) {
                        tooltip = isProject ? this.TEXT_EDIT : this.TEXT_COPY;
                        this.m_93228_(matrixStack, this.btnCopy.x, this.btnCopy.y, 16, 224, 16, 16);
                    } else {
                        this.m_93228_(matrixStack, this.btnCopy.x, this.btnCopy.y, 16, 240, 16, 16);
                    }
                }
                if (this.isActive(this.btnDelete)) {
                    if (this.isMouseOverArea(mouseX, mouseY, this.btnDelete, 16)) {
                        tooltip = this.TEXT_DELETE;
                        this.m_93228_(matrixStack, this.btnDelete.x, this.btnDelete.y, 0, 224, 16, 16);
                    } else {
                        this.m_93228_(matrixStack, this.btnDelete.x, this.btnDelete.y, 0, 240, 16, 16);
                    }
                }
                if (this.isActive(this.btnFavorite)) {
                    boolean shift;
                    boolean mouseOverArea = this.isMouseOverArea(mouseX, mouseY, this.btnFavorite, 16);
                    boolean bl2 = shift = this.selectedWidgetList == this.listFavorite != mouseOverArea;
                    if (mouseOverArea) {
                        tooltip = shift ? this.TEXT_FAVORITE : this.TEXT_UNFAVORITE;
                    }
                    this.m_93228_(matrixStack, this.btnFavorite.x, this.btnFavorite.y, 48, shift ? 224 : 240, 16, 16);
                }
                if (this.isActive(this.btnShare)) {
                    if (this.isMouseOverArea(mouseX, mouseY, this.btnShare, 16)) {
                        tooltip = this.TEXT_SHARE;
                        this.m_93228_(matrixStack, this.btnShare.x, this.btnShare.y, 32, 224, 16, 16);
                    } else {
                        this.m_93228_(matrixStack, this.btnShare.x, this.btnShare.y, 32, 240, 16, 16);
                    }
                }
            }
            GuiFunctions.exitDrawTextureStateWithBlend();
            GuiEmbroidery.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.TEXT_APPLY, (int)(this.btnApply.x + 32), (int)(this.btnApply.y + 4), (int)(hasSelection && this.canApply ? 0xFFFFFF : -6250336));
            GuiEmbroidery.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.TEXT_REMOVE, (int)(this.btnRemove.x + 32), (int)(this.btnRemove.y + 5), (int)(this.canRemove ? 0xFFFFFF : -6250336));
            if (this.selectedWidgetList == this.listCustom && this.buttonCreateNew.m_5953_(mouseX, mouseY)) {
                tooltip = this.TEXT_CREATE_INFO;
            }
            if (!Strings.isNullOrEmpty((String)tooltip)) {
                if (!tooltip.equals(this.lastToolTip)) {
                    this.lastToolTip = tooltip;
                    this.countToolTip = 0;
                } else {
                    ++this.countToolTip;
                }
                if (this.countToolTip >= 40) {
                    this.countToolTip = 40;
                    ArrayList lines = new ArrayList();
                    Localization.multiLineTooltip((String)tooltip, lines);
                    this.m_96597_(matrixStack, lines, this.guiLeft, this.guiTop + this.ySize + 10);
                }
            }
        }
    }

    private boolean isActive(Point button) {
        return button.x != 0 && button.y != 0;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        switch (this.activePage) {
            case DRAW: {
                if (!this.pageDraw.keyPressed(keyCode, scanCode, modifiers)) break;
                return true;
            }
            case SELECT: {
                if (!this.selectedWidgetList.m_7933_(keyCode, scanCode, modifiers)) break;
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6913_() {
        return this.activePage == ActivePage.SELECT;
    }

    public void m_7861_() {
        EmbroideryData.INSTANCE.saveData();
        super.m_7861_();
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        switch (this.activePage) {
            case DRAW: {
                if (!this.scaleLayer) {
                    if (!this.pageDraw.keyReleased(keyCode, scanCode, modifiers)) break;
                    return true;
                }
            }
            case SCALE: {
                if (!this.pageScale.keyReleased(keyCode, scanCode, modifiers)) break;
                return true;
            }
            case SELECT: {
                if (!this.selectedWidgetList.m_7920_(keyCode, scanCode, modifiers)) break;
                return true;
            }
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char character, int value) {
        switch (this.activePage) {
            case DRAW: {
                if (this.scaleLayer) break;
                return this.pageDraw.charTyped(character, value);
            }
            case SELECT: {
                if (!this.selectedWidgetList.m_5534_(character, value)) break;
                return true;
            }
        }
        return super.m_5534_(character, value);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        switch (this.activePage) {
            case DRAW: {
                if (!this.scaleLayer) {
                    return this.pageDraw.mouseClicked(mouseX, mouseY, button);
                }
            }
            case SCALE: {
                return this.pageScale.mouseClicked(mouseX, mouseY, button);
            }
            case SELECT: {
                if (this.selectedWidgetList.m_6375_(mouseX, mouseY, button)) {
                    return true;
                }
                if (button != 0) break;
                if (this.isMouseOverArea(mouseX, mouseY, this.tabBuiltin, 16)) {
                    return this.updateSelectedWidgetList(this.listBuiltIn, true);
                }
                if (this.isMouseOverArea(mouseX, mouseY, this.tabCustom, 16)) {
                    return this.updateSelectedWidgetList(this.listCustom, true);
                }
                if (this.isMouseOverArea(mouseX, mouseY, this.tabFavorite, 16)) {
                    return this.updateSelectedWidgetList(this.listFavorite, true);
                }
                if (this.isMouseOverArea(mouseX, mouseY, this.tabSession, 16)) {
                    return this.updateSelectedWidgetList(this.listSession, true);
                }
                if (this.isMouseOverArea(mouseX, mouseY, this.tabWebpage, 16)) {
                    return this.updateSelectedWidgetList(this.listWebpage, true);
                }
                if (this.isMouseOverArea(mouseX, mouseY, this.tabProjects, 16)) {
                    return this.updateSelectedWidgetList(this.listProjects, true);
                }
                if (this.isMouseOverArea(mouseX, mouseY, this.btnApply, 64, 16)) {
                    if (this.canApply && this.selectedWidget != null) {
                        NetworkHandler.sendToServer(new PacketEmbroidery(this.pos, this.selectedWidget.getArt(), this.selectedWidget.getEmbroidery()));
                        this.f_96541_.f_91074_.m_6915_();
                        return true;
                    }
                    return false;
                }
                if (this.isMouseOverArea(mouseX, mouseY, this.btnRemove, 64, 16)) {
                    if (this.canRemove) {
                        NetworkHandler.sendToServer(new PacketEmbroidery(this.pos, EnumSpreadArt.NONE));
                        this.f_96541_.f_91074_.m_6915_();
                    }
                    return true;
                }
                if (this.isActive(this.btnCopy) && this.isMouseOverArea(mouseX, mouseY, this.btnCopy, 16)) {
                    if (this.selectedWidget != null) {
                        if (this.selectedWidget instanceof WidgetProject) {
                            this.pageDraw.loadProject(this.selectedWidget.id, ((WidgetProject)this.selectedWidget).project);
                            this.activePage = ActivePage.DRAW;
                            return true;
                        }
                        byte palette = 0;
                        byte[] indices = null;
                        if (this.selectedWidget instanceof WidgetEntryArt) {
                            Pair<String, Embroidery> data = Embroidery.fromShareTag(this.selectedWidget.getShareTag());
                            if (data != null) {
                                palette = ((Embroidery)data.getValue()).getPalette();
                                indices = ((Embroidery)data.getValue()).getIndices();
                            }
                        } else {
                            WidgetEntry widgetEntry = this.selectedWidget;
                            if (widgetEntry instanceof WidgetEntryBytes) {
                                WidgetEntryBytes widgetEntryBytes = (WidgetEntryBytes)widgetEntry;
                                palette = widgetEntryBytes.palette;
                                indices = widgetEntryBytes.indices;
                            }
                        }
                        if (indices != null && Embroidery.getBaseCanvasArraySize(indices) > -1) {
                            if (Screen.m_96637_()) {
                                this.pageScale.setImage(this.selectedWidget.id, palette, indices, Embroidery.getCanvasScale(indices));
                                this.activePage = ActivePage.SCALE;
                            } else {
                                this.pageDraw.setImage(this.selectedWidget.id, palette, indices, Embroidery.getCanvasScale(indices));
                                this.activePage = ActivePage.DRAW;
                            }
                            return true;
                        }
                    }
                    return false;
                }
                if (this.isActive(this.btnDelete) && this.isMouseOverArea(mouseX, mouseY, this.btnDelete, 16)) {
                    if (this.selectedWidget != null && GuiEmbroidery.m_96639_()) {
                        this.selectedWidgetList.m_6702_().remove(this.selectedWidget);
                        if (this.selectedWidgetList == this.listCustom) {
                            EmbroideryData.delete(this.selectedWidget.id);
                        } else if (this.selectedWidgetList == this.listProjects) {
                            EmbroideryData.deleteProject(this.selectedWidget.id);
                        }
                        this.selectedWidgetList.m_6987_(null);
                        return true;
                    }
                    return false;
                }
                if (this.isActive(this.btnFavorite) && this.isMouseOverArea(mouseX, mouseY, this.btnFavorite, 16)) {
                    if (this.selectedWidget != null) {
                        String name = (this.selectedWidget instanceof WidgetEntryArt ? "inc:" : "per:") + this.selectedWidget.id;
                        if (this.selectedWidgetList == this.listFavorite) {
                            this.selectedWidgetList.m_6702_().remove(this.selectedWidget);
                            this.selectedWidgetList.m_6987_(null);
                            EmbroideryData.unfavorite(name);
                        } else {
                            EmbroideryData.favorite(name, this.selectedWidget.getEmbroidery());
                            this.listFavorite.addEntry(this.selectedWidget);
                        }
                        return true;
                    }
                    return false;
                }
                if (!this.isActive(this.btnShare) || !this.isMouseOverArea(mouseX, mouseY, this.btnShare, 16)) break;
                if (this.selectedWidget != null) {
                    if (GuiEmbroidery.m_96639_() && !GuiEmbroidery.m_96638_()) {
                        NetworkHandler.sendToServer(new PacketShareTag(this.selectedWidget.id, this.selectedWidget.getEmbroidery(), false));
                    } else if (GuiEmbroidery.m_96639_() && GuiEmbroidery.m_96638_()) {
                        NetworkHandler.sendToServer(new PacketShareTag(this.selectedWidget.id, this.selectedWidget.getEmbroidery(), true));
                    } else {
                        String tagOutput = this.selectedWidget.id + ":" + this.selectedWidget.getShareTag();
                        Minecraft.m_91087_().f_91068_.m_90911_(tagOutput);
                        MultiBeds.LOGGER.info("Copied ShareTag: " + tagOutput);
                    }
                    return true;
                }
                return false;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double accelX, double accelY) {
        switch (this.activePage) {
            case DRAW: {
                if (this.scaleLayer) break;
                return this.pageDraw.mouseDragged(mouseX, mouseY, button);
            }
            case SELECT: {
                if (!this.selectedWidgetList.m_7979_(mouseX, mouseY, button, accelX, accelY)) break;
                return true;
            }
        }
        return super.m_7979_(mouseX, mouseY, button, accelX, accelY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (!this.scaleLayer && this.activePage == ActivePage.DRAW) {
            return this.pageDraw.mouseReleased(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (this.activePage == ActivePage.SELECT && this.selectedWidgetList.m_6050_(mouseX, mouseY, scroll)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    private boolean isMouseOverArea(double mouseX, double mouseY, Point point, int size) {
        return this.isMouseOverArea(mouseX, mouseY, point.x, point.y, size, size);
    }

    private boolean isMouseOverArea(double mouseX, double mouseY, Point point, int sizeX, int sizeY) {
        return this.isMouseOverArea(mouseX, mouseY, point.x, point.y, sizeX, sizeY);
    }

    private boolean isMouseOverArea(double mouseX, double mouseY, int x, int y, int sizeX, int sizeY) {
        return mouseX >= (double)x && mouseX < (double)(x + sizeX) && mouseY >= (double)y && mouseY < (double)(y + sizeY);
    }

    public boolean m_7043_() {
        return false;
    }

    private class WidgetEntryNew
    extends WidgetFunctionButton {
        WidgetEntryNew() {
            super("gui.multibeds.embroidery.create");
        }

        private int getSize() {
            return Screen.m_96639_() ? 24 : (Screen.m_96638_() ? 32 : (Screen.m_96637_() ? 12 : 16));
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            GuiEmbroidery.this.pageDraw.setImage("unnamed", (byte)0, null, this.getSize());
            GuiEmbroidery.this.activePage = ActivePage.DRAW;
            return true;
        }

        @Override
        protected String getDisplayName() {
            return super.getDisplayName() + " (" + this.getSize() + "x)";
        }
    }

    private abstract class WidgetEntry
    extends AbstractSelectionList.Entry<WidgetEntry>
    implements Comparable<WidgetEntry> {
        private final String id;
        private final String displayName;

        WidgetEntry(String id) {
            this(id, id);
        }

        WidgetEntry(String id, String displayName) {
            this.id = id.toLowerCase(Locale.ROOT);
            this.displayName = displayName;
        }

        protected String getDisplayName() {
            return this.displayName;
        }

        public void m_6311_(PoseStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            if (hovered) {
                GuiEmbroidery.this.hoveredWidget = this;
                GuiFunctions.drawGradientRect((PoseStack)matrixStack, (double)left, (double)top, (double)(left + width - 3), (double)((float)top + (float)height / 2.0f), (float)0.0f, (int)-2130706688, (int)-2130706688, (int)-256, (int)-256);
                GuiFunctions.drawGradientRect((PoseStack)matrixStack, (double)left, (double)((float)top + (float)height / 2.0f), (double)(left + width - 3), (double)(top + height), (float)0.0f, (int)-256, (int)-256, (int)-2130706688, (int)-2130706688);
                RenderSystem.m_69478_();
            }
            GuiComponent.m_93208_((PoseStack)matrixStack, (Font)GuiEmbroidery.this.f_96547_, (String)this.getDisplayName(), (int)(left + width / 2), (int)top, (int)0xFFFFFF);
        }

        abstract void renderPreview(PoseStack var1, int var2, int var3);

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                GuiEmbroidery.this.selectedWidgetList.m_6987_(this);
                GuiEmbroidery.this.selectedWidget = this;
                return true;
            }
            return false;
        }

        EnumSpreadArt getArt() {
            return EnumSpreadArt.CUSTOM;
        }

        Embroidery getEmbroidery() {
            return null;
        }

        String getShareTag() {
            return "";
        }

        @Override
        public int compareTo(WidgetEntry other) {
            String otherName = other instanceof WidgetFunctionButton ? "" : other.id.toLowerCase();
            return this instanceof WidgetFunctionButton ? "".compareTo(otherName) : this.id.toLowerCase().compareTo(otherName);
        }
    }

    private class WidgetEntryPasteShareTag
    extends WidgetFunctionButton {
        private final DateFormat timestamp;

        WidgetEntryPasteShareTag() {
            super("gui.multibeds.embroidery.paste_tag");
            this.timestamp = new SimpleDateFormat("HH:mm:ss");
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            Pair<String, Embroidery> data;
            String clipboard = Minecraft.m_91087_().f_91068_.m_90876_();
            if (!Strings.isNullOrEmpty((String)clipboard) && (data = Embroidery.fromShareTag(clipboard = clipboard.replaceAll("\"", "").trim())) != null) {
                String name = Strings.isNullOrEmpty((String)((String)data.getKey())) ? "pst:" + this.timestamp.format(Calendar.getInstance().getTime()) : (String)data.getKey();
                GuiEmbroidery.this.listSession.addEntry(new WidgetEntryBytes(name, (Embroidery)data.getValue()));
            }
            return true;
        }
    }

    static enum ActivePage {
        SELECT,
        DRAW,
        SCALE;

    }

    private class WidgetEntryBytes
    extends WidgetEntry {
        private final Embroidery embroidery;
        private final byte palette;
        private final byte[] indices;
        private final int canvasScale;
        private final String shareTag;

        WidgetEntryBytes(String name, Embroidery embroidery) {
            super(name);
            this.embroidery = embroidery;
            this.palette = embroidery.getPalette();
            this.shareTag = embroidery.buildShareTag(new String[0]);
            this.indices = embroidery.getIndices();
            this.canvasScale = Embroidery.getCanvasScale(this.indices);
        }

        @Override
        void renderPreview(PoseStack matrixStack, int posX, int posY) {
            double pixelSize = 64.0 / (double)this.canvasScale;
            for (int row = 0; row < this.canvasScale; ++row) {
                for (int col = 0; col < this.canvasScale; ++col) {
                    double x = (double)posX + (double)col * pixelSize;
                    double y = (double)posY + (double)row * pixelSize;
                    GuiFunctions.drawRect((PoseStack)matrixStack, (double)x, (double)y, (double)(x + pixelSize), (double)(y + pixelSize), (float)0.0f, (int)Embroidery.getColorAt(this.palette, this.indices, this.canvasScale * row + col));
                }
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public String getShareTag() {
            return this.shareTag;
        }

        @Override
        Embroidery getEmbroidery() {
            return this.embroidery;
        }
    }

    private class WidgetList
    extends AbstractWidgetList<WidgetEntry> {
        WidgetList(Minecraft mc, int x, int y, int width, int height) {
            super(mc, x, y, width, height, 12);
            this.setFadeColors(0, 0);
            this.setScrollBarColors(Integer.MIN_VALUE, -2130706433, -1073741824);
            this.setSelectionBoxColors(Integer.MIN_VALUE, 0, 0);
        }

        protected int addEntry(WidgetEntry entry) {
            return this.m_6702_().contains(entry) ? -1 : super.m_7085_((AbstractSelectionList.Entry)entry);
        }

        protected void renderBackground(PoseStack matrixStack, Tesselator tessellator, BufferBuilder bufferbuilder) {
        }

        protected void renderHoleBackground(PoseStack matrixStack, Tesselator tessellator, BufferBuilder bufferbuilder, int y0, int y1) {
        }
    }

    private class WidgetEntryArt
    extends WidgetEntry {
        private final EnumSpreadArt art;
        private final ResourceLocation location;

        WidgetEntryArt(EnumSpreadArt art) {
            super(art.m_7912_(), I18n.m_118938_((String)("misc.multibeds.art." + art.m_7912_()), (Object[])new Object[0]));
            this.art = art;
            this.location = new ResourceLocation("multibeds", "textures/block/art/" + art.m_7912_() + ".png");
        }

        @Override
        void renderPreview(PoseStack matrixStack, int posX, int posY) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.location);
            GuiFunctions.drawTextureScaled((PoseStack)matrixStack, (double)posX, (double)posY, (int)0, (int)0, (int)16, (int)16, (double)4.0, (float)1.0f, (int[])new int[]{16});
            RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.EMBROIDERY.get());
        }

        @Override
        String getShareTag() {
            return this.art.getShareTag();
        }

        @Override
        EnumSpreadArt getArt() {
            return this.art;
        }
    }

    private class WidgetProject
    extends WidgetEntry {
        private final WIPProject project;

        WidgetProject(String name, WIPProject project) {
            super(name);
            this.project = project;
        }

        @Override
        void renderPreview(PoseStack matrixStack, int posX, int posY) {
            int canvasScale = this.project.getCanvasScale();
            byte[] indices = this.project.getPreview();
            byte palette = this.project.getPalette();
            double pixelSize = 64.0 / (double)canvasScale;
            for (int row = 0; row < canvasScale; ++row) {
                for (int col = 0; col < canvasScale; ++col) {
                    double x = (double)posX + (double)col * pixelSize;
                    double y = (double)posY + (double)row * pixelSize;
                    GuiFunctions.drawRect((PoseStack)matrixStack, (double)x, (double)y, (double)(x + pixelSize), (double)(y + pixelSize), (float)0.0f, (int)Embroidery.getColorAt(palette, indices, canvasScale * row + col));
                }
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        Embroidery getEmbroidery() {
            return Embroidery.fromUncompressed(this.project.getPalette(), this.project.getPreview());
        }
    }

    private abstract class WidgetFunctionButton
    extends WidgetEntry {
        WidgetFunctionButton(String name) {
            super(name, I18n.m_118938_((String)name, (Object[])new Object[0]));
        }

        @Override
        public void m_6311_(PoseStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(matrixStack, index, top, left, width, height, mouseX, mouseY, hovered, partialTicks);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.EMBROIDERY.get());
            RenderSystem.m_69478_();
            GuiFunctions.drawTextureScaled((PoseStack)matrixStack, (double)(left + 4), (double)top, (int)64, (int)224, (int)16, (int)16, (double)0.5, (float)1.0f, (int[])new int[0]);
        }

        @Override
        void renderPreview(PoseStack matrixStack, int posX, int posY) {
        }
    }
}

