/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import java.util.List;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.client.Localization;
import shetiphian.multibeds.client.render.RenderRegistry;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.misc.EnumBlanket;
import shetiphian.multibeds.common.misc.EnumSpreadArt;

public class ItemBlanket
extends ItemBedCustomization {
    public ItemBlanket(Item.Properties properties, DyeColor color) {
        super(properties, color, ItemBedCustomization.EnumType.BLANKET);
        this.doLater();
    }

    @Override
    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            RenderRegistry.COLORIZE.add((Object)this);
            RenderRegistry.OVERRIDES.add((Triple<Item, String, ItemPropertyFunction>)Triple.of((Object)((Object)this), (Object)"pattern", (stack, world, entity, number) -> ItemBlanket.getBlanket(stack).getPattern().ordinal()));
        });
    }

    @Override
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> list) {
        if (this.m_41389_(group)) {
            for (EnumBlanket.Pattern pattern : EnumBlanket.Pattern.values()) {
                ItemStack stack = new ItemStack((ItemLike)this);
                if (pattern != EnumBlanket.Pattern.PLAIN) {
                    CompoundTag tag = stack.m_41784_();
                    tag.m_128359_("pattern", pattern.m_7912_());
                }
                list.add((Object)stack);
            }
        }
    }

    public static String getPatternName(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("pattern")) {
            return tag.m_128461_("pattern");
        }
        return "plain";
    }

    public static void setPatternName(ItemStack stack, EnumBlanket.Pattern pattern) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("pattern", pattern.m_7912_());
    }

    private static String getBlanketName(ItemStack stack) {
        return ItemBlanket.getPatternName(stack) + "_" + (stack.m_41720_() instanceof ItemBlanket ? ((ItemBlanket)stack.m_41720_()).getColor(stack).m_41065_() : "red");
    }

    public static EnumBlanket getBlanket(ItemStack stack) {
        EnumBlanket blanket = EnumBlanket.byName(ItemBlanket.getBlanketName(stack));
        return blanket != EnumBlanket.NONE ? blanket : EnumBlanket.PLAIN_RED;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advancedTooltips) {
        EnumSpreadArt art;
        super.m_7373_(stack, world, tooltip, advancedTooltips);
        if (!ItemBlanket.getPatternName(stack).equalsIgnoreCase("plain")) {
            tooltip.add((Component)new TextComponent(Localization.get((String)"misc.multibeds.pattern") + ": " + Localization.get((String)("misc.multibeds.pattern." + ItemBlanket.getPatternName(stack)))));
        }
        if ((art = ItemEmbroideryThread.getArtwork(stack)) != EnumSpreadArt.NONE) {
            tooltip.add((Component)new TextComponent("\u00a77\u00a7o * " + Localization.get((String)"misc.multibeds.art") + ": " + Localization.get((String)("misc.multibeds.art." + art.m_7912_()))));
        }
    }
}

