/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.client.Localization;
import shetiphian.multibeds.client.gui.GuiEmbroidery;
import shetiphian.multibeds.client.render.RenderRegistry;
import shetiphian.multibeds.common.block.BlockMultiBedBase;
import shetiphian.multibeds.common.misc.Embroidery;
import shetiphian.multibeds.common.misc.EnumSpreadArt;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public class ItemEmbroideryThread
extends Item {
    public ItemEmbroideryThread(Item.Properties properties) {
        super(properties);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.OVERRIDES.add((Triple<Item, String, ItemPropertyFunction>)Triple.of((Object)((Object)this), (Object)"fill", (stack, world, entity, number) -> {
            float value = (float)((double)stack.m_41773_() / (double)stack.m_41776_());
            return stack.m_41776_() - stack.m_41773_() <= 1 ? 0.0f : Math.max(0.1f, 1.0f - value);
        })));
    }

    public int getMaxDamage(ItemStack stack) {
        return 25;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return stack.m_41773_() + 1 < stack.m_41776_() ? 1 : 0;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.openGUI(player, stack, world, null));
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext data) {
        ItemStack stack = data.m_43722_();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.openGUI(data.m_43723_(), stack, data.m_43725_(), data.m_8083_()));
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openGUI(Player player, ItemStack stack, Level world, BlockPos pos) {
        TileEntityMultiBed[] tiles;
        TileEntityMultiBed[] tileEntityMultiBedArray = tiles = world != null && pos != null ? BlockMultiBedBase.getTiles((BlockGetter)world, pos) : null;
        if (tiles == null || tiles[0].hasBlanket() && tiles[1].hasBlanket()) {
            Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_((Screen)new GuiEmbroidery(pos, stack.m_41773_() < stack.m_41776_() - 1, tiles)));
        } else if (player != null) {
            player.m_5661_((Component)new TextComponent(Localization.get((String)"error.multibeds.embroidery.no_blanket")), true);
        }
    }

    public static void setArtwork(ItemStack stack, EnumSpreadArt art, Embroidery embroidery) {
        if (!stack.m_41619_()) {
            CompoundTag tag = ItemEmbroideryThread.getStorageTag(stack);
            tag.m_128473_("artwork");
            tag.m_128473_("compressed");
            tag.m_128473_("indices");
            if (art != EnumSpreadArt.NONE) {
                tag.m_128359_("artwork", art.m_7912_());
                if (art == EnumSpreadArt.CUSTOM && embroidery != null) {
                    embroidery.writeToNbt(tag);
                } else {
                    Embroidery.removeFromNbt(tag);
                }
            } else {
                ItemEmbroideryThread.cleanBlockTag(stack, true);
            }
        }
    }

    public static EnumSpreadArt getArtwork(ItemStack stack) {
        CompoundTag tag;
        if (!stack.m_41619_() && (tag = ItemEmbroideryThread.getStorageTag(stack, true)) != null && tag.m_128441_("artwork")) {
            return EnumSpreadArt.byName(tag.m_128461_("artwork"));
        }
        return EnumSpreadArt.NONE;
    }

    public static Embroidery getArtworkEmbroidery(ItemStack stack) {
        return stack.m_41619_() ? null : Embroidery.fromNbtTag(ItemEmbroideryThread.getStorageTag(stack));
    }

    public static String getArtName(ItemStack stack) {
        return ItemEmbroideryThread.getArtwork(stack).m_7912_();
    }

    private static void cleanBlockTag(ItemStack stack, boolean removeEmbroideryData) {
        CompoundTag blockEntityTag;
        if (!stack.m_41619_() && (blockEntityTag = stack.m_41737_("BlockEntityTag")) != null) {
            CompoundTag forgeDataTag = ItemEmbroideryThread.getChildStorageTag(blockEntityTag, "ForgeData", true);
            if (forgeDataTag != null) {
                CompoundTag multibedsDataTag = ItemEmbroideryThread.getChildStorageTag(forgeDataTag, "multibeds", true);
                if (multibedsDataTag != null && (removeEmbroideryData || multibedsDataTag.m_128456_())) {
                    forgeDataTag.m_128473_("multibeds");
                }
                if (forgeDataTag.m_128456_()) {
                    blockEntityTag.m_128473_("ForgeData");
                }
            }
            if (blockEntityTag.m_128425_("Patterns", 9) && blockEntityTag.m_128437_("Patterns", 10).isEmpty()) {
                blockEntityTag.m_128473_("Patterns");
            }
            if (blockEntityTag.m_128456_()) {
                stack.m_41749_("BlockEntityTag");
            }
        }
    }

    public static CompoundTag getStorageTag(ItemStack stack) {
        return ItemEmbroideryThread.getStorageTag(stack, false);
    }

    public static CompoundTag getStorageTag(ItemStack stack, boolean failOnMissing) {
        if (!stack.m_41619_()) {
            ItemEmbroideryThread.cleanBlockTag(stack, false);
            if (stack.m_41720_() instanceof BannerItem) {
                CompoundTag forgeDataTag;
                CompoundTag blockEntityTag;
                CompoundTag compoundTag = blockEntityTag = failOnMissing ? stack.m_41737_("BlockEntityTag") : stack.m_41698_("BlockEntityTag");
                if (blockEntityTag != null && (forgeDataTag = ItemEmbroideryThread.getChildStorageTag(blockEntityTag, "ForgeData", failOnMissing)) != null) {
                    return ItemEmbroideryThread.getChildStorageTag(forgeDataTag, "multibeds", failOnMissing);
                }
                return null;
            }
            return failOnMissing ? stack.m_41783_() : stack.m_41784_();
        }
        return new CompoundTag();
    }

    private static CompoundTag getChildStorageTag(CompoundTag tag, String key, boolean failOnMissing) {
        if (tag.m_128425_(key, 10)) {
            return tag.m_128469_(key);
        }
        if (!failOnMissing) {
            CompoundTag nbt = new CompoundTag();
            tag.m_128365_(key, (Tag)nbt);
            return nbt;
        }
        return null;
    }

    public static void writeEmbroideryData(ItemStack stack, CompoundTag embroidery) {
        if (!stack.m_41619_()) {
            CompoundTag tag = ItemEmbroideryThread.getStorageTag(stack);
            if (embroidery.m_128441_("artwork")) {
                tag.m_128359_("artwork", embroidery.m_128461_("artwork"));
            }
            if (embroidery.m_128441_("compressed") && embroidery.m_128441_("indices")) {
                tag.m_128379_("compressed", embroidery.m_128471_("compressed"));
                tag.m_128382_("indices", embroidery.m_128463_("indices"));
                tag.m_128344_("palette", embroidery.m_128441_("palette") ? embroidery.m_128445_("palette") : (byte)0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advancedTooltips) {
        super.m_7373_(stack, world, tooltip, advancedTooltips);
        if (!stack.m_41619_()) {
            ItemEmbroideryThread.addArtToTooltip(tooltip, ItemEmbroideryThread.getStorageTag(stack));
        }
    }

    public static void addArtToTooltip(List<Component> tooltip, CompoundTag tag) {
        EnumSpreadArt artwork;
        if (tag.m_128441_("artwork") && (artwork = EnumSpreadArt.byName(tag.m_128461_("artwork"))) != EnumSpreadArt.NONE) {
            tooltip.add((Component)new TextComponent(Localization.get((String)"misc.multibeds.art") + ": " + Localization.get((String)("misc.multibeds.art." + artwork.m_7912_()))));
        }
    }
}

