/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class BiomeTexture {
    public static final Map<String, Block> BIOME_TEXTURE = new HashMap<String, Block>();
    private static final ItemStack DEFAULT = new ItemStack((ItemLike)Blocks.f_50705_);

    public static ItemStack getStackFor(Holder<Biome> biomeRegistryEntry) {
        ResourceLocation identifier;
        Optional keyOptional;
        if (biomeRegistryEntry != null && (keyOptional = biomeRegistryEntry.m_203543_()).isPresent() && (identifier = ((ResourceKey)keyOptional.get()).m_135782_()) != null) {
            String key = identifier.toString();
            if (!BIOME_TEXTURE.containsKey(key)) {
                Block block = BiomeTexture.getBlockFor(identifier);
                if (block == null) {
                    block = BiomeTexture.getBlockFor(Biome.m_204183_(biomeRegistryEntry));
                }
                BIOME_TEXTURE.put(key, block);
            }
            return new ItemStack((ItemLike)BIOME_TEXTURE.getOrDefault(key, Blocks.f_50705_));
        }
        return DEFAULT.m_41777_();
    }

    private static Block getBlockFor(ResourceLocation biome) {
        if (biome != null && "minecraft".equals(biome.m_135827_())) {
            switch (biome.m_135815_()) {
                case "the_void": {
                    return Blocks.f_50259_;
                }
                case "plains": {
                    return Blocks.f_50705_;
                }
                case "sunflower_plains": {
                    return Blocks.f_50705_;
                }
                case "snowy_plains": {
                    return Blocks.f_50741_;
                }
                case "ice_spikes": {
                    return Blocks.f_50354_;
                }
                case "desert": {
                    return Blocks.f_50062_;
                }
                case "swamp": {
                    return Blocks.f_50705_;
                }
                case "forest": {
                    return Blocks.f_50742_;
                }
                case "flower_forest": {
                    return Blocks.f_50742_;
                }
                case "birch_forest": {
                    return Blocks.f_50742_;
                }
                case "dark_forest": {
                    return Blocks.f_50745_;
                }
                case "old_growth_birch_forest": {
                    return Blocks.f_50742_;
                }
                case "old_growth_pine_taiga": {
                    return Blocks.f_50741_;
                }
                case "old_growth_spruce_taiga": {
                    return Blocks.f_50741_;
                }
                case "taiga": {
                    return Blocks.f_50741_;
                }
                case "snowy_taiga": {
                    return Blocks.f_50741_;
                }
                case "savanna": {
                    return Blocks.f_50744_;
                }
                case "savanna_plateau": {
                    return Blocks.f_50744_;
                }
                case "windswept_hills": {
                    return Blocks.f_50705_;
                }
                case "windswept_gravelly_hills": {
                    return Blocks.f_50705_;
                }
                case "windswept_forest": {
                    return Blocks.f_50705_;
                }
                case "windswept_savanna": {
                    return Blocks.f_50744_;
                }
                case "jungle": {
                    return Blocks.f_50743_;
                }
                case "sparse_jungle": {
                    return Blocks.f_50743_;
                }
                case "bamboo_jungle": {
                    return Blocks.f_50743_;
                }
                case "badlands": {
                    return Blocks.f_50352_;
                }
                case "eroded_badlands": {
                    return Blocks.f_50352_;
                }
                case "wooded_badlands": {
                    return Blocks.f_50352_;
                }
                case "meadow": {
                    return Blocks.f_50742_;
                }
                case "grove": {
                    return Blocks.f_50741_;
                }
                case "snowy_slopes": {
                    return Blocks.f_50127_;
                }
                case "frozen_peaks": {
                    return Blocks.f_50354_;
                }
                case "jagged_peaks": {
                    return Blocks.f_50126_;
                }
                case "stony_peaks": {
                    return Blocks.f_50069_;
                }
                case "river": {
                    return Blocks.f_50129_;
                }
                case "frozen_river": {
                    return Blocks.f_50126_;
                }
                case "beach": {
                    return Blocks.f_50069_;
                }
                case "snowy_beach": {
                    return Blocks.f_50069_;
                }
                case "stony_shore": {
                    return Blocks.f_50069_;
                }
                case "warm_ocean": {
                    return Blocks.f_50588_;
                }
                case "lukewarm_ocean": {
                    return Blocks.f_50069_;
                }
                case "deep_lukewarm_ocean": {
                    return Blocks.f_50378_;
                }
                case "ocean": {
                    return Blocks.f_50069_;
                }
                case "deep_ocean": {
                    return Blocks.f_50378_;
                }
                case "cold_ocean": {
                    return Blocks.f_50069_;
                }
                case "deep_cold_ocean": {
                    return Blocks.f_50378_;
                }
                case "frozen_ocean": {
                    return Blocks.f_50126_;
                }
                case "deep_frozen_ocean": {
                    return Blocks.f_50568_;
                }
                case "mushroom_fields": {
                    return Blocks.f_50182_;
                }
                case "dripstone_caves": {
                    return Blocks.f_152537_;
                }
                case "lush_caves": {
                    return Blocks.f_50705_;
                }
                case "nether_wastes": {
                    return Blocks.f_50134_;
                }
                case "warped_forest": {
                    return Blocks.f_50656_;
                }
                case "crimson_forest": {
                    return Blocks.f_50655_;
                }
                case "soul_sand_valley": {
                    return Blocks.f_50135_;
                }
                case "basalt_deltas": {
                    return Blocks.f_50137_;
                }
                case "the_end": {
                    return Blocks.f_50259_;
                }
                case "end_highlands": {
                    return Blocks.f_50259_;
                }
                case "end_midlands": {
                    return Blocks.f_50259_;
                }
                case "small_end_islands": {
                    return Blocks.f_50259_;
                }
                case "end_barrens": {
                    return Blocks.f_50259_;
                }
            }
        }
        return null;
    }

    private static Block getBlockFor(Biome.BiomeCategory category) {
        if (category != null) {
            switch (category) {
                case TAIGA: {
                    return Blocks.f_50741_;
                }
                case EXTREME_HILLS: {
                    return Blocks.f_50705_;
                }
                case JUNGLE: {
                    return Blocks.f_50743_;
                }
                case MESA: {
                    return Blocks.f_50394_;
                }
                case PLAINS: {
                    return Blocks.f_50705_;
                }
                case SAVANNA: {
                    return Blocks.f_50744_;
                }
                case ICY: {
                    return Blocks.f_50354_;
                }
                case THEEND: {
                    return Blocks.f_50259_;
                }
                case BEACH: {
                    return Blocks.f_50069_;
                }
                case FOREST: {
                    return Blocks.f_50742_;
                }
                case OCEAN: {
                    return Blocks.f_50069_;
                }
                case DESERT: {
                    return Blocks.f_50062_;
                }
                case RIVER: {
                    return Blocks.f_50129_;
                }
                case SWAMP: {
                    return Blocks.f_50705_;
                }
                case MUSHROOM: {
                    return Blocks.f_50182_;
                }
                case NETHER: {
                    return Blocks.f_50134_;
                }
                case UNDERGROUND: {
                    return Blocks.f_50069_;
                }
                case MOUNTAIN: {
                    return Blocks.f_50069_;
                }
            }
        }
        return Blocks.f_50705_;
    }
}

