/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.mixins;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.multibeds.Configuration;
import shetiphian.multibeds.Values;
import shetiphian.multibeds.common.block.BlockMultiBedBase;
import shetiphian.multibeds.common.misc.EnumBedStyle;

@Mixin(value={StructureTemplate.class})
public class MB_StructureTemplate {
    private static CompoundTag SHEET;
    private static CompoundTag PILLOW;
    private static final Map<DyeColor, CompoundTag> BLANKETS;

    @ModifyArg(method={"loadPalette"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;addToLists(Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate$StructureBlockInfo;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V"))
    protected StructureTemplate.StructureBlockInfo multibeds_loadPalette_StructureBlockInfo_Redirect(StructureTemplate.StructureBlockInfo original) {
        if (this.isBed(original.f_74676_.m_60734_()) && ((Boolean)Configuration.GENERAL.replaceStructureBeds.get()).booleanValue()) {
            BedPart part = (BedPart)original.f_74676_.m_61143_((Property)BedBlock.f_49440_);
            Direction facing = (Direction)original.f_74676_.m_61143_((Property)BedBlock.f_54117_);
            BlockState multibed = (BlockState)((BlockState)((BlockState)Values.blocksEarthBed.get((Object)EnumBedStyle.RUSTIC).m_49966_().m_61124_((Property)BlockMultiBedBase.f_54117_, (Comparable)facing)).m_61124_((Property)BlockMultiBedBase.f_49440_, (Comparable)part)).m_61124_((Property)BlockMultiBedBase.WATERLOGGED, (Comparable)Boolean.valueOf(false));
            CompoundTag nbtTag = new CompoundTag();
            nbtTag.m_128365_("sheet_item", (Tag)this.getSheet());
            nbtTag.m_128365_("pillow_item", (Tag)this.getPillow());
            nbtTag.m_128365_("blanket_item", (Tag)this.getBlanket(original.f_74676_.m_60734_()));
            nbtTag.m_128379_("mirror", false);
            return new StructureTemplate.StructureBlockInfo(original.f_74675_, multibed, nbtTag);
        }
        return original;
    }

    private CompoundTag getSheet() {
        if (SHEET == null) {
            SHEET = new CompoundTag();
            RGB16StackHelper.setRGB16((ItemStack)new ItemStack((ItemLike)Values.itemSheet), (String)"white").m_41739_(SHEET);
        }
        return SHEET;
    }

    private CompoundTag getPillow() {
        if (PILLOW == null) {
            PILLOW = new CompoundTag();
            RGB16StackHelper.setRGB16((ItemStack)new ItemStack((ItemLike)Values.itemPillow), (String)"white").m_41739_(PILLOW);
        }
        return PILLOW;
    }

    private CompoundTag getBlanket(Block block) {
        DyeColor color;
        DyeColor dyeColor = color = block instanceof BedBlock ? ((BedBlock)block).m_49554_() : DyeColor.WHITE;
        if (!BLANKETS.containsKey(color)) {
            CompoundTag tag = new CompoundTag();
            new ItemStack((ItemLike)Values.itemsBlanket.get(color.ordinal())).m_41739_(tag);
            BLANKETS.put(color, tag);
        }
        return BLANKETS.get(color);
    }

    private boolean isBed(Block block) {
        return block instanceof BedBlock && (block == Blocks.f_50029_ || block == Blocks.f_50025_ || block == Blocks.f_50026_ || block == Blocks.f_50023_ || block == Blocks.f_50021_ || block == Blocks.f_50027_ || block == Blocks.f_50017_ || block == Blocks.f_50022_ || block == Blocks.f_50019_ || block == Blocks.f_50068_ || block == Blocks.f_50067_ || block == Blocks.f_50020_ || block == Blocks.f_50024_ || block == Blocks.f_50028_ || block == Blocks.f_50066_ || block == Blocks.f_50018_);
    }

    static {
        BLANKETS = new HashMap<DyeColor, CompoundTag>();
    }
}

