/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.physxjni;

public enum Platform {
    LINUX64("de.fabmax.physxjni.NativeMetaLinux64"),
    WIN64("de.fabmax.physxjni.NativeMetaWin64"),
    MAC64("de.fabmax.physxjni.NativeMetaMac64");

    private final String metaClassName;

    private Platform(String metaClassName) {
        this.metaClassName = metaClassName;
    }

    public String getMetaClassName() {
        return this.metaClassName;
    }

    public static Platform getPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            return WIN64;
        }
        if (osName.contains("linux")) {
            return LINUX64;
        }
        if (osName.contains("mac os x") || osName.contains("darwin") || osName.contains("osx")) {
            return MAC64;
        }
        throw new IllegalStateException("Unsupported OS: " + osName);
    }
}

