/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.world.level.block.Block;

public final class ConfigBlocks {
    private static final String DIR = "config/physicsmod";
    public static final int BLOCK_PHYSICS_TYPE_OFF = 0;
    public static final int BLOCK_PHYSICS_TYPE_FRACTURED = 1;
    public static final int BLOCK_PHYSICS_TYPE_PARENT = 2;
    public static final int BLOCK_PHYSICS_TYPE_BLOCKY = 3;
    public static final int BLOCK_PHYSICS_TYPE_PARTICLES = 4;
    private static final String CONFIG = "physics_blocks_client_config.json";
    public static Map<String, Integer> customizedBlocks;

    public static void init() {
    }

    public static int getBlockSetting(Block block) {
        Integer val = customizedBlocks.get(PhysicsMod.registeredBlocks.get(block));
        if (val == null) {
            val = 2;
        }
        if (val == 2) {
            return ConfigClient.blockPhysics;
        }
        return val;
    }

    private static JsonObject createConfig() {
        JsonObject config = new JsonObject();
        JsonArray array = new JsonArray();
        for (String id : PhysicsMod.registeredBlocks.values()) {
            Integer val = customizedBlocks.get(id);
            if (val == null) {
                val = 2;
                customizedBlocks.put(id, val);
            }
            array.add(id);
            array.add((Number)val);
        }
        config.add("customizedBlocks", (JsonElement)array);
        return config;
    }

    public static void resetBlocks() {
        for (Map.Entry<String, Integer> entry : customizedBlocks.entrySet()) {
            customizedBlocks.put(entry.getKey(), 2);
        }
        ConfigBlocks.save();
    }

    public static void save() {
        File configFile;
        File directory = new File(DIR);
        if (!directory.exists()) {
            directory.mkdir();
        }
        if ((configFile = new File("config/physicsmod/physics_blocks_client_config.json")).exists()) {
            configFile.delete();
        }
        JsonObject config = ConfigBlocks.createConfig();
        try {
            configFile.createNewFile();
            try (FileWriter writer = new FileWriter(configFile);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                gson.toJson((JsonElement)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        File configFile;
        customizedBlocks = new Object2ObjectOpenHashMap();
        JsonObject config = ConfigBlocks.createConfig();
        File directory = new File(DIR);
        if (!directory.exists()) {
            directory.mkdir();
        }
        if (!(configFile = new File("config/physicsmod/physics_blocks_client_config.json")).exists()) {
            try {
                configFile.createNewFile();
                try (FileWriter writer = new FileWriter(configFile);){
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    gson.toJson((JsonElement)config, (Appendable)writer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Gson gson = new Gson();
            try {
                config = (JsonObject)gson.fromJson((Reader)new FileReader(configFile), JsonObject.class);
            }
            catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        try {
            JsonArray array = config.get("customizedBlocks").getAsJsonArray();
            for (int i = 0; i < array.size() / 2; ++i) {
                String id = array.get(i * 2).getAsString();
                Integer val = array.get(i * 2 + 1).getAsInt();
                customizedBlocks.put(id, val);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

