/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.diebuddies.physics.DynamicsWorld;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

public final class ConfigClient {
    public static final int CAPE_SIMULATION_QUALITY = 45;
    public static final int FISHING_ROD_SIMULATION_QUALITY = 20;
    public static final int LEASH_SIMULATION_QUALITY = 20;
    public static final int BANNER_SIMULATION_QUALITY = 25;
    public static final int SNOWBALL_VOXEL = 0;
    public static final int SNOWBALL_ROUND = 1;
    public static final int SNOWBALL_CLASSIC = 2;
    public static final int ENDERPEARL_VOXEL = 0;
    public static final int ENDERPEARL_ROUND = 1;
    public static final int ENDERPEARL_CLASSIC = 2;
    public static final int EGG_VOXEL = 0;
    public static final int EGG_ROUND = 1;
    public static final int EGG_CLASSIC = 2;
    public static final int IMPACT_SHATTER = 0;
    public static final int IMPACT_BOUNCE = 1;
    public static final int IMPACT_DISAPPEAR = 2;
    private static final String DIR = "config/physicsmod";
    private static final String CONFIG = "physics_client_config.json";
    public static Map<String, Vector3f> customizedGravities;
    public static Map<String, Vector3f> customizedBuoyancies;
    public static Map<String, Set<String>> customizedCapes;
    public static int mobPhysicsType;
    public static int blockPhysics;
    public static boolean itemPhysics;
    public static int maxPhysicsObjects;
    public static int cpuThreads;
    public static double blockPhysicsScale;
    public static double particleLifetimeBlocks;
    public static double particleLifetimeMobs;
    public static double particleLifetimeVines;
    public static double particleLifetimeItems;
    public static double particleLifetimeParticles;
    public static double particleLifetimeLiquids;
    public static boolean gravityChanged;
    public static boolean minecraftBlockBreakParticles;
    public static boolean vinePhysics;
    public static boolean capePhysics;
    public static boolean fishingRodPhysics;
    public static boolean leashPhysics;
    public static boolean bannerPhysics;
    public static double bannerPhysicsRange;
    public static boolean clothSmoothShading;
    public static boolean physicsModCape;
    public static boolean liquidPhysics;
    public static double leashLength;
    public static double fishingLineLength;
    public static boolean showUpdateNotifications;
    public static boolean pvpServerCompatibility;
    public static int snowballModel;
    public static int snowballImpact;
    public static boolean snowballShade;
    public static int enderpearlModel;
    public static int enderpearlImpact;
    public static boolean enderpearlShade;
    public static int eggModel;
    public static int eggImpact;
    public static boolean eggShade;
    public static boolean crackPhysicsParticles;
    public static String selectedPhysicsCape;
    public static int clothThreads;
    public static int liquidThreads;
    public static volatile double vineRange;
    public static volatile double liquidSourceDistance;
    public static boolean impactSounds;
    public static float soundVolume;
    public static double blockPhysicsRange;
    public static int waterDensity;
    private static Map<String, String> customCapeCache;

    public static void init() {
    }

    private static void get(JsonObject config, Map<String, Vector3f> map, String name) {
        JsonArray array = config.get(name).getAsJsonArray();
        for (int i = 0; i < array.size() / 4; ++i) {
            String id = array.get(i * 4).getAsString();
            Float x = Float.valueOf(array.get(i * 4 + 1).getAsFloat());
            Float y = Float.valueOf(array.get(i * 4 + 2).getAsFloat());
            Float z = Float.valueOf(array.get(i * 4 + 3).getAsFloat());
            map.put(id, new Vector3f(x.floatValue(), y.floatValue(), z.floatValue()));
        }
    }

    public static Vector3f getGravity(String id) {
        Vector3f val = customizedGravities.get(id);
        if (val == null) {
            val = new Vector3f(DynamicsWorld.DEFAULT_GRAVITY);
        }
        return val;
    }

    public static String getCustomCape(String playerName) {
        String selectedCape = customCapeCache.get(playerName);
        if (selectedCape == null) {
            Set<String> players;
            String capeName;
            ObjectArrayList capes = new ObjectArrayList();
            for (Map.Entry<String, Set<String>> entry : customizedCapes.entrySet()) {
                capeName = entry.getKey();
                players = entry.getValue();
                if (!players.contains(playerName)) continue;
                capes.add(capeName);
            }
            if (capes.size() == 0) {
                for (Map.Entry<String, Set<String>> entry : customizedCapes.entrySet()) {
                    capeName = entry.getKey();
                    players = entry.getValue();
                    if (!players.contains("+ALL")) continue;
                    capes.add(capeName);
                }
            }
            if (capes.size() == 0) {
                return null;
            }
            int hash = playerName.hashCode();
            Random r = new Random(hash);
            selectedCape = (String)capes.get(r.nextInt(capes.size()));
            customCapeCache.put(playerName, selectedCape);
        }
        return selectedCape;
    }

    public static Vector3f getGravity(ResourceLocation id) {
        return ConfigClient.getGravity(id.toString());
    }

    public static Vector3f getBuoyancy(String id) {
        Vector3f val = customizedBuoyancies.get(id);
        if (val == null) {
            val = new Vector3f(DynamicsWorld.DEFAULT_BUOYANCY);
        }
        return val;
    }

    public static Vector3f getBuoyancy(ResourceLocation id) {
        return ConfigClient.getBuoyancy(id.toString());
    }

    public static Set<String> getCapeSettings(String cape) {
        ObjectOpenHashSet settings = customizedCapes.get(cape);
        if (settings == null) {
            settings = new ObjectOpenHashSet();
        }
        return settings;
    }

    public static void setCapeSettings(String cape, Set<String> settings) {
        if (settings == null || settings.size() == 0) {
            customizedCapes.remove(cape);
        } else {
            customizedCapes.put(cape, settings);
        }
    }

    public static void setGravity(String id, Vector3f gravity) {
        customizedGravities.put(id, gravity);
        gravityChanged = true;
    }

    public static void setBuoyancy(String id, Vector3f buoyancy) {
        customizedBuoyancies.put(id, buoyancy);
        gravityChanged = true;
    }

    public static boolean addGravityBuoyancyEntry(ResourceLocation id) {
        if (!customizedGravities.containsKey(id.toString())) {
            customizedGravities.put(id.toString(), new Vector3f(DynamicsWorld.DEFAULT_GRAVITY));
            customizedBuoyancies.put(id.toString(), new Vector3f(DynamicsWorld.DEFAULT_BUOYANCY));
            return true;
        }
        return false;
    }

    public static boolean hasItemPhysics() {
        return itemPhysics;
    }

    private static JsonObject createConfig() {
        JsonObject config = new JsonObject();
        config.add("mobPhysicsType", (JsonElement)new JsonPrimitive((Number)mobPhysicsType));
        config.add("blockPhysicsNew", (JsonElement)new JsonPrimitive((Number)blockPhysics));
        config.add("maxPhysicsObjects", (JsonElement)new JsonPrimitive((Number)maxPhysicsObjects));
        config.add("blockPhysicsScale", (JsonElement)new JsonPrimitive((Number)blockPhysicsScale));
        config.add("particleLifetimeMobs", (JsonElement)new JsonPrimitive((Number)particleLifetimeMobs));
        config.add("particleLifetimeBlocks", (JsonElement)new JsonPrimitive((Number)particleLifetimeBlocks));
        config.add("particleLifetimeVines", (JsonElement)new JsonPrimitive((Number)particleLifetimeVines));
        config.add("particleLifetimeItems", (JsonElement)new JsonPrimitive((Number)particleLifetimeItems));
        config.add("particleLifetimeParticles", (JsonElement)new JsonPrimitive((Number)particleLifetimeParticles));
        config.add("particleLifetimeLiquids", (JsonElement)new JsonPrimitive((Number)particleLifetimeLiquids));
        config.add("cpuThreads", (JsonElement)new JsonPrimitive((Number)cpuThreads));
        config.add("itemPhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(itemPhysics)));
        config.add("minecraftBlockBreakParticles", (JsonElement)new JsonPrimitive(Boolean.valueOf(minecraftBlockBreakParticles)));
        config.add("vinePhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(vinePhysics)));
        config.add("capePhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(capePhysics)));
        config.add("fishingRodPhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(fishingRodPhysics)));
        config.add("leashPhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(leashPhysics)));
        config.add("bannerPhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(bannerPhysics)));
        config.add("clothSmoothShading", (JsonElement)new JsonPrimitive(Boolean.valueOf(clothSmoothShading)));
        config.add("physicsModCape", (JsonElement)new JsonPrimitive(Boolean.valueOf(physicsModCape)));
        config.add("selectedPhysicsCape", (JsonElement)new JsonPrimitive(selectedPhysicsCape));
        config.add("showUpdateNotifications", (JsonElement)new JsonPrimitive(Boolean.valueOf(showUpdateNotifications)));
        config.add("clothThreads", (JsonElement)new JsonPrimitive((Number)clothThreads));
        config.add("leashLength", (JsonElement)new JsonPrimitive((Number)leashLength));
        config.add("fishingLineLength", (JsonElement)new JsonPrimitive((Number)fishingLineLength));
        config.add("pvpServerCompatibility", (JsonElement)new JsonPrimitive(Boolean.valueOf(pvpServerCompatibility)));
        config.add("snowballModel", (JsonElement)new JsonPrimitive((Number)snowballModel));
        config.add("snowballImpact", (JsonElement)new JsonPrimitive((Number)snowballImpact));
        config.add("snowballShade", (JsonElement)new JsonPrimitive(Boolean.valueOf(snowballShade)));
        config.add("enderpearlModel", (JsonElement)new JsonPrimitive((Number)enderpearlModel));
        config.add("enderpearlImpact", (JsonElement)new JsonPrimitive((Number)enderpearlImpact));
        config.add("enderpearlShade", (JsonElement)new JsonPrimitive(Boolean.valueOf(enderpearlShade)));
        config.add("eggModel", (JsonElement)new JsonPrimitive((Number)eggModel));
        config.add("eggImpact", (JsonElement)new JsonPrimitive((Number)eggImpact));
        config.add("eggShade", (JsonElement)new JsonPrimitive(Boolean.valueOf(eggShade)));
        config.add("crackPhysicsParticles", (JsonElement)new JsonPrimitive(Boolean.valueOf(crackPhysicsParticles)));
        config.add("liquidPhysics", (JsonElement)new JsonPrimitive(Boolean.valueOf(liquidPhysics)));
        config.add("liquidSourceDistance", (JsonElement)new JsonPrimitive((Number)liquidSourceDistance));
        config.add("liquidThreads", (JsonElement)new JsonPrimitive((Number)liquidThreads));
        config.add("bannerPhysicsRange", (JsonElement)new JsonPrimitive((Number)bannerPhysicsRange));
        config.add("impactSounds", (JsonElement)new JsonPrimitive(Boolean.valueOf(impactSounds)));
        config.add("soundVolume", (JsonElement)new JsonPrimitive((Number)Float.valueOf(soundVolume)));
        config.add("blockPhysicsRange", (JsonElement)new JsonPrimitive((Number)blockPhysicsRange));
        config.add("vineRange", (JsonElement)new JsonPrimitive((Number)vineRange));
        config.add("waterDensity", (JsonElement)new JsonPrimitive((Number)waterDensity));
        ConfigClient.add(config, customizedGravities, "customizedGravities");
        ConfigClient.add(config, customizedBuoyancies, "customizedBuoyancies");
        JsonArray array = new JsonArray();
        for (Map.Entry<String, Set<String>> entry : customizedCapes.entrySet()) {
            Set<String> val = entry.getValue();
            JsonArray valArr = new JsonArray();
            for (String name : val) {
                valArr.add(name);
            }
            JsonObject element = new JsonObject();
            element.add("id", (JsonElement)new JsonPrimitive(entry.getKey()));
            element.add("values", (JsonElement)valArr);
            array.add((JsonElement)element);
        }
        config.add("customizedCapes", (JsonElement)array);
        return config;
    }

    private static void add(JsonObject config, Map<String, Vector3f> map, String name) {
        JsonArray array = new JsonArray();
        for (Map.Entry<String, Vector3f> entry : map.entrySet()) {
            array.add(entry.getKey());
            Vector3f val = entry.getValue();
            array.add((Number)Float.valueOf(val.x));
            array.add((Number)Float.valueOf(val.y));
            array.add((Number)Float.valueOf(val.z));
        }
        config.add(name, (JsonElement)array);
    }

    public static void resetOptions() {
        mobPhysicsType = 4;
        blockPhysics = 1;
        itemPhysics = true;
        maxPhysicsObjects = 10000;
        cpuThreads = Math.max(1, Runtime.getRuntime().availableProcessors() / 4);
        blockPhysicsScale = 1.0;
        particleLifetimeBlocks = 4.0;
        particleLifetimeMobs = 4.0;
        minecraftBlockBreakParticles = false;
        vinePhysics = true;
        ConfigClient.save();
    }

    public static void resetGravities() {
        for (Map.Entry<String, Vector3f> entry : customizedGravities.entrySet()) {
            customizedGravities.put(entry.getKey(), new Vector3f(DynamicsWorld.DEFAULT_GRAVITY));
        }
        for (Map.Entry<String, Vector3f> entry : customizedBuoyancies.entrySet()) {
            customizedBuoyancies.put(entry.getKey(), new Vector3f(DynamicsWorld.DEFAULT_BUOYANCY));
        }
        gravityChanged = true;
        ConfigClient.save();
    }

    public static void save() {
        File configFile;
        File directory = new File(DIR);
        if (!directory.exists()) {
            directory.mkdir();
        }
        if ((configFile = new File("config/physicsmod/physics_client_config.json")).exists()) {
            configFile.delete();
        }
        JsonObject config = ConfigClient.createConfig();
        try {
            configFile.createNewFile();
            try (FileWriter writer = new FileWriter(configFile);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                gson.toJson((JsonElement)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        customCapeCache.clear();
    }

    static {
        File configFile;
        customizedGravities = new Object2ObjectOpenHashMap();
        customizedBuoyancies = new Object2ObjectOpenHashMap();
        customizedCapes = new Object2ObjectOpenHashMap();
        mobPhysicsType = 4;
        blockPhysics = 1;
        itemPhysics = true;
        maxPhysicsObjects = 10000;
        cpuThreads = Math.max(1, Runtime.getRuntime().availableProcessors() / 4);
        blockPhysicsScale = 1.0;
        particleLifetimeBlocks = 4.0;
        particleLifetimeMobs = 4.0;
        particleLifetimeVines = 4.0;
        particleLifetimeItems = 3.0;
        particleLifetimeParticles = 0.1;
        particleLifetimeLiquids = 6.0;
        gravityChanged = false;
        minecraftBlockBreakParticles = false;
        vinePhysics = true;
        capePhysics = true;
        fishingRodPhysics = true;
        leashPhysics = true;
        bannerPhysics = true;
        bannerPhysicsRange = 48.0;
        clothSmoothShading = false;
        physicsModCape = true;
        liquidPhysics = true;
        leashLength = 3.0;
        fishingLineLength = 12.0;
        showUpdateNotifications = true;
        pvpServerCompatibility = false;
        snowballModel = 0;
        snowballImpact = 0;
        snowballShade = false;
        enderpearlModel = 0;
        enderpearlImpact = 0;
        enderpearlShade = false;
        eggModel = 0;
        eggImpact = 0;
        eggShade = false;
        crackPhysicsParticles = true;
        selectedPhysicsCape = "Physics Mod Cape.dae";
        clothThreads = Math.max(1, Runtime.getRuntime().availableProcessors() / 8);
        liquidThreads = 2;
        vineRange = 32.0;
        liquidSourceDistance = 6.0;
        impactSounds = true;
        soundVolume = 1.0f;
        blockPhysicsRange = 96.0;
        waterDensity = 3;
        customCapeCache = new Object2ObjectOpenHashMap();
        JsonObject config = ConfigClient.createConfig();
        File directory = new File(DIR);
        if (!directory.exists()) {
            directory.mkdir();
        }
        if (!(configFile = new File("config/physicsmod/physics_client_config.json")).exists()) {
            try {
                configFile.createNewFile();
                try (FileWriter writer = new FileWriter(configFile);){
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    gson.toJson((JsonElement)config, (Appendable)writer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Gson gson = new Gson();
            try {
                config = (JsonObject)gson.fromJson((Reader)new FileReader(configFile), JsonObject.class);
            }
            catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        try {
            blockPhysics = config.get("blockPhysicsNew").getAsInt();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            mobPhysicsType = config.get("mobPhysicsType").getAsInt();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            maxPhysicsObjects = config.get("maxPhysicsObjects").getAsInt();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            blockPhysicsScale = config.get("blockPhysicsScale").getAsDouble();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            particleLifetimeMobs = config.get("particleLifetimeMobs").getAsDouble();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            particleLifetimeBlocks = config.get("particleLifetimeBlocks").getAsDouble();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            particleLifetimeVines = config.get("particleLifetimeVines").getAsDouble();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            particleLifetimeItems = config.get("particleLifetimeItems").getAsDouble();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            particleLifetimeParticles = config.get("particleLifetimeParticles").getAsDouble();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            particleLifetimeLiquids = config.get("particleLifetimeLiquids").getAsDouble();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            cpuThreads = config.get("cpuThreads").getAsInt();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            itemPhysics = config.get("itemPhysics").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            minecraftBlockBreakParticles = config.get("minecraftBlockBreakParticles").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            vinePhysics = config.get("vinePhysics").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            capePhysics = config.get("capePhysics").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            fishingRodPhysics = config.get("fishingRodPhysics").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            leashPhysics = config.get("leashPhysics").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            bannerPhysics = config.get("bannerPhysics").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            clothSmoothShading = config.get("clothSmoothShading").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            physicsModCape = config.get("physicsModCape").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            selectedPhysicsCape = config.get("selectedPhysicsCape").getAsString();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            showUpdateNotifications = config.get("showUpdateNotifications").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            clothThreads = config.get("clothThreads").getAsInt();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            leashLength = config.get("leashLength").getAsDouble();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            fishingLineLength = config.get("fishingLineLength").getAsDouble();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            pvpServerCompatibility = config.get("pvpServerCompatibility").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            snowballModel = config.get("snowballModel").getAsInt();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            snowballImpact = config.get("snowballImpact").getAsInt();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            snowballShade = config.get("snowballShade").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            enderpearlModel = config.get("enderpearlModel").getAsInt();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            enderpearlImpact = config.get("enderpearlImpact").getAsInt();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            enderpearlShade = config.get("enderpearlShade").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            eggModel = config.get("eggModel").getAsInt();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            eggImpact = config.get("eggImpact").getAsInt();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            eggShade = config.get("eggShade").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            crackPhysicsParticles = config.get("crackPhysicsParticles").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            liquidPhysics = config.get("liquidPhysics").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            liquidSourceDistance = config.get("liquidSourceDistance").getAsDouble();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            liquidThreads = config.get("liquidThreads").getAsInt();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            bannerPhysicsRange = config.get("bannerPhysicsRange").getAsDouble();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            impactSounds = config.get("impactSounds").getAsBoolean();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            soundVolume = config.get("soundVolume").getAsFloat();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            blockPhysicsRange = config.get("blockPhysicsRange").getAsDouble();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            vineRange = config.get("vineRange").getAsDouble();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            waterDensity = config.get("waterDensity").getAsInt();
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            ConfigClient.get(config, customizedGravities, "customizedGravities");
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            ConfigClient.get(config, customizedBuoyancies, "customizedBuoyancies");
        }
        catch (Exception gson) {
            // empty catch block
        }
        try {
            JsonArray array = config.get("customizedCapes").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject object = array.get(i).getAsJsonObject();
                String id = object.get("id").getAsString();
                JsonArray list = object.get("values").getAsJsonArray();
                ObjectOpenHashSet result = new ObjectOpenHashSet();
                for (int j = 0; j < list.size(); ++j) {
                    result.add(list.get(j).getAsString());
                }
                customizedCapes.put(id, (Set<String>)result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

