/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.vines.AdjustableUtil;
import net.diebuddies.physics.vines.DoorSetting;
import net.diebuddies.physics.vines.DynamicSetting;
import net.diebuddies.physics.vines.TrapdoorSetting;
import net.diebuddies.physics.vines.VineHelper;
import net.diebuddies.physics.vines.VineSetting;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.joml.Vector3f;

public final class ConfigVines {
    private static final String DIR = "config/physicsmod";
    private static final String CONFIG = "physics_vines_client_config.json";
    public static Map<Block, DynamicSetting> configSettings;

    public static void loadDefaultConfigSettings() {
        configSettings.clear();
        configSettings.put(Blocks.f_50704_, new VineSetting(true, true, false, new Vector3f(1.0f), 2400.0f, 10.0f, Blocks.f_50653_));
        configSettings.put(Blocks.f_50575_, new VineSetting(true, false, false, new Vector3f(1.0f), 45.0f, 45.0f, Blocks.f_50576_));
        configSettings.put(Blocks.f_50702_, new VineSetting(false, false, false, new Vector3f(1.0f), 45.0f, 45.0f, Blocks.f_50703_));
        configSettings.put(Blocks.f_152538_, new VineSetting(false, false, false, new Vector3f(1.0f), 45.0f, 45.0f, Blocks.f_152539_));
        configSettings.put(Blocks.f_50130_, new VineSetting(true, true, false, new Vector3f(1.0f), 2300.0f, 90.0f, null));
        configSettings.put(Blocks.f_50191_, new VineSetting(false, false, true, new Vector3f(1.0f), 45.0f, 45.0f, null));
        configSettings.put(Blocks.f_50184_, new VineSetting(false, false, true, new Vector3f(1.5f, 1.0f, 1.5f), 60.0f, 40.0f, Blocks.f_50681_));
        configSettings.put(Blocks.f_50357_, new VineSetting(true, true, false, new Vector3f(1.0f), 110.0f, 48.0f, null));
        configSettings.put(Blocks.f_50359_, new VineSetting(true, true, false, new Vector3f(1.0f), 110.0f, 48.0f, null));
        configSettings.put(Blocks.f_50360_, new VineSetting(true, true, false, new Vector3f(1.0f), 110.0f, 48.0f, null));
        configSettings.put(Blocks.f_50358_, new VineSetting(true, true, false, new Vector3f(1.0f), 110.0f, 48.0f, null));
        configSettings.put(Blocks.f_50356_, new VineSetting(true, true, false, new Vector3f(1.0f), 110.0f, 48.0f, null));
        configSettings.put(Blocks.f_50355_, new VineSetting(true, true, false, new Vector3f(1.0f), 110.0f, 48.0f, null));
        configSettings.put(Blocks.f_50038_, new VineSetting(true, false, false, new Vector3f(1.0f), 110.0f, 48.0f, null));
        float scale = 0.85f;
        float stiffness = 1580.0f;
        float damping = 8.0f;
        configSettings.put(Blocks.f_50216_, new TrapdoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50220_, new TrapdoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50218_, new TrapdoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50221_, new TrapdoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50376_, new TrapdoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50219_, new TrapdoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50217_, new TrapdoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50664_, new TrapdoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50663_, new TrapdoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50154_, new DoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50487_, new DoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50485_, new DoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50488_, new DoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50166_, new DoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50486_, new DoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50484_, new DoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50672_, new DoorSetting(new Vector3f(scale), stiffness, damping));
        configSettings.put(Blocks.f_50671_, new DoorSetting(new Vector3f(scale), stiffness, damping));
    }

    public static void init() {
    }

    private static JsonObject createConfig() {
        JsonObject config = new JsonObject();
        JsonArray array = new JsonArray();
        for (Map.Entry<Block, DynamicSetting> entry : configSettings.entrySet()) {
            String id = PhysicsMod.registeredBlocks.get(entry.getKey());
            if (id == null) continue;
            JsonObject obj = new JsonObject();
            obj.add("blockID", (JsonElement)new JsonPrimitive(id));
            DynamicSetting setting = entry.getValue();
            AdjustableUtil.saveAllFields(obj, setting);
            array.add((JsonElement)obj);
        }
        config.add("customizedDynamicBlocks", (JsonElement)array);
        return config;
    }

    public static void resetVines() {
        ConfigVines.loadDefaultConfigSettings();
        VineHelper.initFromConfigSettings();
        ConfigVines.save();
    }

    public static void save() {
        File configFile;
        File directory = new File(DIR);
        if (!directory.exists()) {
            directory.mkdir();
        }
        if ((configFile = new File("config/physicsmod/physics_vines_client_config.json")).exists()) {
            configFile.delete();
        }
        JsonObject config = ConfigVines.createConfig();
        try {
            configFile.createNewFile();
            try (FileWriter writer = new FileWriter(configFile);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                gson.toJson((JsonElement)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        File configFile;
        configSettings = new Object2ObjectOpenHashMap();
        ConfigVines.loadDefaultConfigSettings();
        JsonObject config = ConfigVines.createConfig();
        File directory = new File(DIR);
        if (!directory.exists()) {
            directory.mkdir();
        }
        if (!(configFile = new File("config/physicsmod/physics_vines_client_config.json")).exists()) {
            try {
                configFile.createNewFile();
                try (FileWriter writer = new FileWriter(configFile);){
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    gson.toJson((JsonElement)config, (Appendable)writer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Gson gson = new Gson();
            try {
                config = (JsonObject)gson.fromJson((Reader)new FileReader(configFile), JsonObject.class);
            }
            catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        try {
            configSettings.clear();
            JsonArray array = config.get("customizedDynamicBlocks").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject obj = array.get(i).getAsJsonObject();
                Block block = PhysicsMod.invRegisteredBlocks.get(obj.get("blockID").getAsString());
                DynamicSetting setting = AdjustableUtil.readAllFields(obj);
                configSettings.put(block, setting);
            }
        }
        catch (Exception e) {
            ConfigVines.loadDefaultConfigSettings();
            ConfigVines.save();
        }
        VineHelper.initFromConfigSettings();
    }
}

