/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.minecraft.ChunkHelper;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public class MixinClientPacketListener {
    @Shadow
    @Final
    private Minecraft f_104888_;
    @Shadow
    @Final
    private ClientLevel f_104889_;

    @Inject(at={@At(value="HEAD")}, method={"handleExplosion"})
    public void handleExplosion(ClientboundExplodePacket explosionPacket, CallbackInfo ci) {
        if (RenderSystem.m_69586_()) {
            Explosion explosion = new Explosion();
            explosion.strength = explosionPacket.m_132135_();
            explosion.position = new Vector3d(explosionPacket.m_132132_(), explosionPacket.m_132133_(), explosionPacket.m_132134_());
            PhysicsMod mod = PhysicsMod.getInstance((Level)this.f_104889_);
            mod.explosions.add(explosion);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleRemoveEntities"})
    public void handleRemoveEntities(ClientboundRemoveEntitiesPacket packetIn, CallbackInfo ci) {
        if (RenderSystem.m_69586_()) {
            for (int i = 0; i < packetIn.m_182730_().size(); ++i) {
                int j = packetIn.m_182730_().getInt(i);
                Entity entity = Minecraft.m_91087_().f_91074_.f_108545_.m_6815_(j);
                if (entity == null || !ConfigClient.pvpServerCompatibility && !(entity instanceof EnderDragon) && !(entity instanceof Creeper) || !(entity.m_20182_().m_82554_(Minecraft.m_91087_().f_91074_.m_20182_()) < 40.0) || !(entity instanceof LivingEntity)) continue;
                PhysicsMod.blockifyEntity(entity.m_20193_(), (LivingEntity)entity);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleLevelChunkWithLight"})
    public void handleLevelChunkWithLight(ClientboundLevelChunkWithLightPacket packet, CallbackInfo ci) {
        if (RenderSystem.m_69586_()) {
            this.invalidateLightChunk(packet.m_195717_(), packet.m_195718_());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleForgetLevelChunk"})
    public void handleForgetLevelChunk(ClientboundForgetLevelChunkPacket packet, CallbackInfo ci) {
        if (RenderSystem.m_69586_()) {
            this.invalidateLightChunk(packet.m_132149_(), packet.m_132152_());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleLightUpdatePacket"})
    public void handleLightUpdatePacket(ClientboundLightUpdatePacket packet, CallbackInfo ci) {
        if (RenderSystem.m_69586_()) {
            this.invalidateLightChunk(packet.m_132349_(), packet.m_132352_());
        }
    }

    @Unique
    private void invalidateLightChunk(int x, int z) {
        PhysicsMod mod = (PhysicsMod)PhysicsMod.instances.get((Object)this.f_104889_);
        if (mod != null) {
            mod.invalidLightChunks.add(ChunkHelper.calcChunkIndex(x, z));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleLogin"})
    public void handleLogin(ClientboundLoginPacket packet, CallbackInfo ci) {
        boolean changed = false;
        for (ResourceKey entry : packet.f_132365_()) {
            changed |= ConfigClient.addGravityBuoyancyEntry(entry.m_135782_());
        }
        if (changed) {
            ConfigClient.save();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleContainerSetSlot"})
    public void handleContainerSetSlot(ClientboundContainerSetSlotPacket packet, CallbackInfo ci) {
    }
}

