/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.diebuddies.compat.Sodium;
import net.diebuddies.config.ConfigBlocks;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.math.MatrixUtil;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.Pack;
import net.diebuddies.opengl.Usage;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.BlockUpdate;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.JsonUnbakedModelHolder;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.FrustumIntersection;
import org.joml.Matrix3d;
import org.joml.Matrix4d;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import physx.common.PxVec3;
import physx.physics.PxRigidBody;

@Mixin(value={LevelRenderer.class})
public class MixinLevelRenderer {
    @Unique
    private static final Matrix3d IDENTITY_3_BY_3 = new Matrix3d();
    @Unique
    private FrustumIntersection frustumInt;
    @Unique
    private org.joml.Matrix4f viewProjectionMatrix = new org.joml.Matrix4f();
    @Unique
    private org.joml.Matrix4f projectionMatrix = new org.joml.Matrix4f();
    @Unique
    private org.joml.Matrix4f viewMatrix = new org.joml.Matrix4f();
    private static final int DEFAULT_SIZE = 200;
    @Unique
    private int size = 200;
    @Unique
    private float[] mpos = new float[this.size * 3];
    @Unique
    private int[] mcol = new int[this.size];
    @Unique
    private int[] muv = new int[this.size];
    @Unique
    private int[] moverlay = new int[this.size];
    @Unique
    private int[] mlight = new int[this.size];
    @Unique
    private int[] mnormals = new int[this.size];
    @Unique
    private int[] mindices = new int[this.size];
    @Unique
    private Matrix4d transformation = new Matrix4d();
    @Unique
    private Matrix3d normalMatrix = new Matrix3d();
    @Unique
    private Vector3d pos = new Vector3d();
    @Unique
    private Matrix4f localT = new Matrix4f();
    @Unique
    private Matrix4f mojangNormalMatrix = new Matrix4f();
    @Unique
    private BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
    @Unique
    private ObjectSet<TextureAtlasSprite> uniqueSprites = new ObjectOpenHashSet();
    @Unique
    private Matrix4d tmpMatrix = new Matrix4d();
    @Unique
    private int mcEntityLocation = -1;
    @Unique
    private static final Set<Block> excludeBlockPhysicsTexture = new ObjectOpenHashSet();

    @Inject(at={@At(value="TAIL")}, method={"renderChunkLayer"})
    private void renderChunkLayerClothOptifine(RenderType blockLayerIn, PoseStack viewMatrixStack, double xIn, double yIn, double zInm, Matrix4f projectionMatrix, CallbackInfo ci) {
        if (blockLayerIn != RenderType.m_110466_() || StarterClient.optifabric) {
            // empty if block
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"renderChunkLayer"})
    private void renderChunkLayerSolid(RenderType blockLayerIn, PoseStack viewMatrixStack, double xIn, double yIn, double zInm, Matrix4f projectionMatrix, CallbackInfo ci) {
        RenderSystem.m_187554_();
        if (StarterClient.updateMessage != null && !StarterClient.updateMessage.isBlank() && Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.Serializer.m_130701_((String)StarterClient.updateMessage), false);
            StarterClient.updateMessage = "";
        }
        if (StarterClient.customMessage != null && !StarterClient.customMessage.isBlank() && Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.Serializer.m_130701_((String)StarterClient.customMessage), false);
            StarterClient.customMessage = "";
        }
        if (blockLayerIn == RenderType.m_110463_()) {
            Level level;
            if (this.frustumInt == null) {
                this.frustumInt = new FrustumIntersection();
            }
            StarterClient.setMatrix(this.projectionMatrix, projectionMatrix);
            StarterClient.setMatrix(this.viewMatrix, viewMatrixStack.m_85850_().m_85861_());
            this.projectionMatrix.mul(this.viewMatrix, this.viewProjectionMatrix);
            this.frustumInt.set(this.viewProjectionMatrix, true);
            PhysicsMod.projectionMatrix.m_162210_(projectionMatrix);
            PhysicsMod.viewMatrix.m_162210_(viewMatrixStack.m_85850_().m_85861_());
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && (level = player.m_20193_()) != null) {
                PhysicsMod mod = PhysicsMod.getInstance(level);
                PhysicsWorld physics = mod.getPhysicsWorld();
                physics.updateLastSeen();
                this.updatePhysics(mod, level, player, physics);
                int oldVao = 0;
                if (physics.getBodies().size() > 0 || physics.getRagdolls().size() > 0 || physics.getVerletSimulations().size() > 0) {
                    int i;
                    blockLayerIn.m_110185_();
                    RenderSystem.m_157427_(GameRenderer::m_172658_);
                    RenderSystem.m_157425_((Matrix4f)projectionMatrix);
                    PoseStack matrixStackIn = RenderSystem.m_157191_();
                    RenderSystem.m_69482_();
                    RenderSystem.m_69478_();
                    RenderSystem.m_69453_();
                    Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
                    matrixStackIn.m_85836_();
                    matrixStackIn.m_166854_(viewMatrixStack.m_85850_().m_85861_());
                    Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
                    RenderSystem.m_69388_((int)33984);
                    RenderSystem.m_69493_();
                    this.uniqueSprites.clear();
                    matrixStackIn.m_85836_();
                    if (!StarterClient.RENDER_LEGACY) {
                        this.setupShader(RenderSystem.m_157196_());
                        oldVao = GL32C.glGetInteger((int)34229);
                    }
                    for (i = 0; i < physics.getBodies().size(); ++i) {
                        IRigidBody body = physics.getBodies().get(i);
                        if (body.separateController || body.getEntity().models == null) continue;
                        this.setTransformation(physics, body, body.getEntity());
                        this.render(physics, level, matrixStackIn, view, body.getEntity());
                    }
                    for (i = 0; i < physics.getRagdolls().size(); ++i) {
                        Ragdoll ragdoll = physics.getRagdolls().get(i);
                        for (int j = 0; j < ragdoll.btBodies.size(); ++j) {
                            IRigidBody body = ragdoll.btBodies.get(j);
                            if (body.getEntity().models == null) continue;
                            this.setTransformation(physics, body, body.getEntity());
                            this.render(physics, level, matrixStackIn, view, body.getEntity());
                        }
                    }
                    if (!StarterClient.RENDER_LEGACY) {
                        GL32C.glBindVertexArray((int)oldVao);
                        RenderSystem.m_157196_().m_173362_();
                    }
                    matrixStackIn.m_85849_();
                    if (StarterClient.sodium) {
                        for (TextureAtlasSprite sprite : this.uniqueSprites) {
                            Sodium.markSpriteActive(sprite);
                        }
                    }
                    matrixStackIn.m_85849_();
                    RenderSystem.m_69388_((int)33984);
                    RenderSystem.m_69481_();
                    blockLayerIn.m_110188_();
                    RenderSystem.m_157182_();
                    this.resetBuffersFix();
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderChunkLayer"})
    private void renderChunkLayerLiquid(RenderType blockLayerIn, PoseStack viewMatrixStack, double xIn, double yIn, double zInm, Matrix4f projectionMatrix, CallbackInfo ci) {
        Level level;
        LocalPlayer player;
        RenderSystem.m_187554_();
        if (blockLayerIn == RenderType.m_110466_() && (player = Minecraft.m_91087_().f_91074_) != null && (level = player.m_20193_()) != null) {
            PhysicsMod mod = PhysicsMod.getInstance(level);
            PhysicsWorld physics = mod.getPhysicsWorld();
            int oldVao = 0;
            if (physics.getLiquids().size() > 0) {
                blockLayerIn.m_110185_();
                PoseStack matrixStackIn = RenderSystem.m_157191_();
                Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
                matrixStackIn.m_85836_();
                matrixStackIn.m_166854_(viewMatrixStack.m_85850_().m_85861_());
                Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
                if (!StarterClient.RENDER_LEGACY) {
                    this.setupShader(RenderSystem.m_157196_());
                    oldVao = GL32C.glGetInteger((int)34229);
                }
                if (StarterClient.optifabric || StarterClient.iris) {
                    this.mcEntityLocation = GL20.glGetAttribLocation((int)RenderSystem.m_157196_().m_142658_(), (CharSequence)"mc_Entity");
                }
                for (int i = 0; i < physics.getLiquids().size(); ++i) {
                    Liquid liquid = physics.getLiquids().get(i);
                    if (liquid.vao == null) continue;
                    this.renderLiquid(physics, level, matrixStackIn, view, liquid);
                }
                if (!StarterClient.RENDER_LEGACY) {
                    GL32C.glBindVertexArray((int)oldVao);
                    RenderSystem.m_157196_().m_173362_();
                }
                matrixStackIn.m_85849_();
                RenderSystem.m_69388_((int)33984);
                RenderSystem.m_69481_();
                blockLayerIn.m_110188_();
                RenderSystem.m_157182_();
                this.setupAttribute(this.mcEntityLocation, 0.0f, 0.0f, 0.0f, 1.0f);
                this.resetBuffersFix();
            }
        }
    }

    @Unique
    private void resetBuffersFix() {
        BufferUploader.m_166835_();
    }

    @Unique
    private void renderLiquid(PhysicsWorld physics, Level level, PoseStack matrixStackIn, Vec3 view, Liquid liquid) {
        this.setupAttribute(this.mcEntityLocation, liquid.materialID, liquid.renderType, -1.0f, -1.0f);
        RenderSystem.m_69481_();
        this.transformation.set(liquid.transformation);
        this.transformation.m30(this.transformation.m30() - view.f_82479_);
        this.transformation.m31(this.transformation.m31() - view.f_82480_);
        this.transformation.m32(this.transformation.m32() - view.f_82481_);
        float scale = 1.0f / (float)liquid.gridSize;
        this.transformation.scale(scale);
        matrixStackIn.m_85836_();
        StarterClient.setMojangMatrix(this.localT, this.transformation);
        matrixStackIn.m_166854_(this.localT);
        this.transformation.normal(this.normalMatrix).invert();
        StarterClient.setMojangMatrix(this.mojangNormalMatrix, this.normalMatrix);
        RenderSystem.m_157182_();
        if (Minecraft.m_91087_().f_91074_ != null && (level instanceof ClientLevel ? ((ClientLevel)level).m_104583_().m_108885_() : Minecraft.m_91087_().f_91074_.f_108545_.m_104583_().m_108885_())) {
            Lighting.m_84925_((Matrix4f)this.mojangNormalMatrix);
        } else {
            Lighting.m_84928_((Matrix4f)this.mojangNormalMatrix);
        }
        RenderSystem.m_157453_((int)0, (int)liquid.textureID);
        RenderSystem.m_69388_((int)33984);
        RenderSystem.m_69396_((int)liquid.textureID);
        if (!StarterClient.RENDER_LEGACY) {
            this.renderLiquidFast(liquid.vao);
        }
        matrixStackIn.m_85849_();
    }

    private void renderLiquidFast(VAO vao) {
        ShaderInstance shader = RenderSystem.m_157196_();
        shader.f_173308_.m_5679_(RenderSystem.m_157190_());
        RenderSystem.m_157461_((ShaderInstance)shader);
        shader.f_173308_.m_85633_();
        vao.render();
    }

    @Unique
    private void setTransformation(PhysicsWorld physics, IRigidBody body, PhysicsEntity entity) {
        if (body.hasTransformationChanged()) {
            MatrixUtil.slerp(entity.getOldTransformation(), entity.getTransformation(), physics.getRenderPercent(), this.transformation);
        } else {
            this.transformation.set(entity.getTransformation());
        }
    }

    @Unique
    private void render(PhysicsWorld physics, Level level, PoseStack matrixStackIn, Vec3 view, PhysicsEntity particle) {
        Mesh mesh = particle.models.get((int)0).mesh;
        if (mesh == null || mesh.indices.size() < 3) {
            return;
        }
        if (particle.backfaceCulling) {
            RenderSystem.m_69481_();
        } else {
            RenderSystem.m_69464_();
        }
        double animationScale = (double)particle.getDespawnScale(level) * particle.scale;
        double scaleX = animationScale * particle.scalePhysics.x;
        double scaleY = animationScale * particle.scalePhysics.y;
        double scaleZ = animationScale * particle.scalePhysics.z;
        this.transformation.m30(this.transformation.m30() + physics.getOffset().x - view.f_82479_);
        this.transformation.m31(this.transformation.m31() + physics.getOffset().y - view.f_82480_);
        this.transformation.m32(this.transformation.m32() + physics.getOffset().z - view.f_82481_);
        this.transformation.scale((float)scaleX, (float)scaleY, (float)scaleZ);
        this.transformation.getTranslation(this.pos);
        if (!this.frustumInt.testSphere((float)this.pos.x, (float)this.pos.y, (float)this.pos.z, (float)particle.getBoundingSphereRadius())) {
            return;
        }
        this.blockPos.m_122169_(this.pos.x + view.f_82479_, this.pos.y + view.f_82480_, this.pos.z + view.f_82481_);
        matrixStackIn.m_85836_();
        StarterClient.setMojangMatrix(this.localT, this.transformation);
        matrixStackIn.m_166854_(this.localT);
        this.transformation.normal(this.normalMatrix).invert();
        if (particle.shade) {
            StarterClient.setMojangMatrix(this.mojangNormalMatrix, this.normalMatrix);
        } else {
            StarterClient.setMojangMatrix(this.mojangNormalMatrix, IDENTITY_3_BY_3);
        }
        RenderSystem.m_157182_();
        if (Minecraft.m_91087_().f_91074_ != null && (level instanceof ClientLevel ? ((ClientLevel)level).m_104583_().m_108885_() : Minecraft.m_91087_().f_91074_.f_108545_.m_104583_().m_108885_())) {
            Lighting.m_84925_((Matrix4f)this.mojangNormalMatrix);
        } else {
            Lighting.m_84928_((Matrix4f)this.mojangNormalMatrix);
        }
        for (int j = 0; j < particle.models.size(); ++j) {
            Model model = particle.models.get(j);
            for (int i = 0; i < model.textureIDs.length; ++i) {
                RenderSystem.m_157453_((int)i, (int)model.textureIDs[i]);
                RenderSystem.m_69388_((int)(33984 + i));
                RenderSystem.m_69396_((int)model.textureIDs[i]);
            }
            if (model.animationSprite != null && StarterClient.sodium) {
                this.uniqueSprites.add((Object)model.animationSprite);
            }
            if (StarterClient.RENDER_LEGACY) {
                this.renderLegacy(level, particle, model, this.blockPos);
                continue;
            }
            this.renderFast(level, particle, model, this.blockPos);
        }
        matrixStackIn.m_85849_();
    }

    @Unique
    private void updatePhysics(PhysicsMod mod, Level level, LocalPlayer player, PhysicsWorld physics) {
        PhysicsEntity particle;
        if (mod.invalidLightChunks.size() > 0) {
            for (IRigidBody body : physics.getBodies()) {
                PhysicsEntity entity = body.getEntity();
                if (entity == null) continue;
                entity.invalidateBrightness();
            }
            mod.invalidLightChunks.clear();
        }
        mod.removeUpdates.clear();
        for (int i = mod.updateQueue.size() - 1; i >= 0; --i) {
            mod.removeUpdates.add(mod.updateQueue.get(i));
        }
        mod.updateQueue.clear();
        ObjectArrayList newParts = new ObjectArrayList();
        double maxActivationDistanceSqr = ConfigClient.blockPhysicsRange * ConfigClient.blockPhysicsRange;
        BlockEntityRenderDispatcher berd = Minecraft.m_91087_().m_167982_();
        for (BlockUpdate bu : mod.removeUpdates) {
            BlockEntityRenderer renderer;
            if (bu.blockEntity != null && (renderer = berd.m_112265_(bu.blockEntity)) != null) {
                PhysicsEntity entity;
                int blockSetting = ConfigBlocks.getBlockSetting(bu.state.m_60734_());
                if (((player.m_142538_().m_123331_((Vec3i)bu.pos) < maxActivationDistanceSqr || ConfigClient.blockPhysicsRange > 319.999) && blockSetting == 1 || blockSetting == 3) && (entity = mod.renderBlockIntoEntity(PhysicsEntity.Type.BLOCK, (BlockEntityRenderer<BlockEntity>)renderer, bu.blockEntity, bu.state, bu.pos)) != null) {
                    physics.addBlockParticle(entity).applyRandomSpawnForces();
                }
            }
            if (bu.state.m_60734_() == Blocks.f_50077_ || bu.state.m_60734_() == Blocks.f_50040_ || bu.state.m_60799_() == RenderShape.INVISIBLE) continue;
            int blockSetting = ConfigBlocks.getBlockSetting(bu.state.m_60734_());
            if (!(player.m_142538_().m_123331_((Vec3i)bu.pos) < maxActivationDistanceSqr) && !(ConfigClient.blockPhysicsRange > 319.999)) continue;
            if (blockSetting == 1) {
                newParts.addAll(this.getBlockData(physics, bu, bu.level));
                continue;
            }
            if (blockSetting == 3) {
                PhysicsEntity entity = mod.renderBlockIntoEntity(PhysicsEntity.Type.BLOCK, bu.state, bu.pos);
                if (entity == null) continue;
                physics.addBlockParticle(entity).applyRandomSpawnForces();
                continue;
            }
            if (blockSetting != 4) continue;
            double percent = this.calculateChance(physics.getBodies());
            if (mod.removeUpdates.size() > 8) {
                percent = java.lang.Math.min(percent, 0.1);
            } else if (mod.removeUpdates.size() == 1) {
                percent = java.lang.Math.max(0.1, percent);
            }
            this.spawnBlockBreakParticles(bu.level, bu.state, bu.pos, percent);
        }
        double chance = this.calculateChance(physics.getBodies());
        int qsize = newParts.size();
        if (qsize == 1) {
            chance = 1.0;
        } else if (qsize > 10) {
            chance = java.lang.Math.min(chance, 0.3);
        }
        for (PhysicsEntity particle2 : newParts) {
            double volume = (particle2.max.x - particle2.min.x) * (particle2.max.y - particle2.min.y) * (particle2.max.z - particle2.min.z);
            List<Mesh> mesh = PhysicsMod.brokenBlock;
            if (!(java.lang.Math.random() < chance)) continue;
            mesh = chance < 0.5 || (double)physics.getBodies().size() > (double)ConfigClient.maxPhysicsObjects * 0.4 ? PhysicsMod.brokenBlocksLittle.get(new Random().nextInt(PhysicsMod.brokenBlocksLittle.size())) : PhysicsMod.brokenBlocksLots.get(new Random().nextInt(PhysicsMod.brokenBlocksLots.size()));
            if (volume < 0.05) {
                mesh = PhysicsMod.brokenBlock;
            } else if (volume < 0.9) {
                mesh = PhysicsMod.brokenBlocksLittle.get(new Random().nextInt(PhysicsMod.brokenBlocksLittle.size()));
            }
            particle2.scale = ConfigClient.blockPhysicsScale;
            physics.addBlockParticle(mesh, particle2);
        }
        while (!mod.entityBlocks.isEmpty()) {
            particle = mod.entityBlocks.poll();
            if (particle.noVolume) continue;
            physics.addBlockParticle(particle).applyRandomSpawnForces();
        }
        while (!mod.additionalPhysics.isEmpty()) {
            particle = mod.additionalPhysics.poll();
            physics.addBlockParticle(particle).applyRandomSpawnForces();
        }
        while (!mod.ragdolls.isEmpty()) {
            Ragdoll ragdoll = mod.ragdolls.poll();
            physics.addRagdoll(ragdoll);
        }
        while (!mod.blockUpdates.isEmpty()) {
            BlockPos pos = mod.blockUpdates.poll();
            physics.blockUpdate(pos);
        }
        while (!mod.explosions.isEmpty()) {
            physics.applyExplosion(mod.explosions.poll());
        }
    }

    @Unique
    private double calculateChance(List<IRigidBody> bodies) {
        double chance = 1.0;
        if ((double)bodies.size() > (double)ConfigClient.maxPhysicsObjects * 0.4) {
            chance = 0.3;
            if ((double)bodies.size() > (double)ConfigClient.maxPhysicsObjects * 0.7) {
                chance = 0.05;
            }
        }
        if (bodies.size() > ConfigClient.maxPhysicsObjects) {
            chance = 0.0;
        }
        return chance;
    }

    @Unique
    private void spawnBlockBreakParticles(Level level, BlockState state, BlockPos pos, double spawnRate) {
        VoxelShape voxelShape = state.m_60808_((BlockGetter)level, pos);
        voxelShape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double width = java.lang.Math.min(1.0, maxX - minX);
            double height = java.lang.Math.min(1.0, maxY - minY);
            double depth = java.lang.Math.min(1.0, maxZ - minZ);
            int stepX = java.lang.Math.max(2, Mth.m_14165_((double)(width / 0.25)));
            int stepY = java.lang.Math.max(2, Mth.m_14165_((double)(height / 0.25)));
            int stepZ = java.lang.Math.max(2, Mth.m_14165_((double)(depth / 0.25)));
            for (int xp = 0; xp < stepX; ++xp) {
                for (int yp = 0; yp < stepY; ++yp) {
                    for (int zp = 0; zp < stepZ; ++zp) {
                        IRigidBody body;
                        if (java.lang.Math.random() > spawnRate) continue;
                        double xSpeed = ((double)xp + 0.5) / (double)stepX;
                        double ySpeed = ((double)yp + 0.5) / (double)stepY;
                        double zSpeed = ((double)zp + 0.5) / (double)stepZ;
                        double xPos = xSpeed * width + minX;
                        double yPos = ySpeed * height + minY;
                        double zPos = zSpeed * depth + minZ;
                        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(state);
                        PhysicsMod mod = PhysicsMod.getInstance(level);
                        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.BLOCK, state);
                        entity.getTransformation().translation((double)pos.m_123341_() + xPos, (double)pos.m_123342_() + yPos, (double)pos.m_123343_() + zPos);
                        entity.getOldTransformation().set(entity.getTransformation());
                        entity.models.get((int)0).texture = sprite;
                        entity.models.get((int)0).textureIDs = new int[]{sprite.m_118414_().m_117963_()};
                        entity.scale = (java.lang.Math.random() * 0.06 + 0.07) * ConfigClient.blockPhysicsScale;
                        entity.backfaceCulling = true;
                        entity.models.get((int)0).mesh = PhysicsMod.brokenBlock.get(0);
                        int color = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)level, pos, 0);
                        if (color == -1) {
                            color = -1;
                        }
                        entity.color = color;
                        if (state.m_60734_() == Blocks.f_50256_ || state.m_60734_() == Blocks.f_50440_) {
                            entity.color = -1;
                        }
                        if ((body = mod.physicsWorld.addBlockParticle(entity)).getRigidBody() instanceof PxRigidBody) {
                            PxRigidBody rigidBody = (PxRigidBody)body.getRigidBody();
                            float strength = 3.0f;
                            org.joml.Vector3f speed = new org.joml.Vector3f(0.0f, 0.2f, 0.0f);
                            speed.x = (float)((double)speed.x + (java.lang.Math.random() - 0.5) * (double)0.4f);
                            speed.y = (float)((double)speed.y + (java.lang.Math.random() - 0.5) * (double)0.4f);
                            speed.z = (float)((double)speed.z + (java.lang.Math.random() - 0.5) * (double)0.4f);
                            speed.normalize();
                            try (MemoryStack mem = MemoryStack.stackPush();){
                                PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, speed.x * strength, speed.y * strength, speed.z * strength);
                                rigidBody.setLinearVelocity(velocity);
                            }
                        }
                        float uo = (float)java.lang.Math.random() * 3.0f;
                        float vo = (float)java.lang.Math.random() * 3.0f;
                        entity.models.get((int)0).customUVs = new Vector4f(sprite.m_118367_((double)((uo + 1.0f) / 4.0f * 16.0f)), sprite.m_118367_((double)(uo / 4.0f * 16.0f)), sprite.m_118393_((double)(vo / 4.0f * 16.0f)), sprite.m_118393_((double)((vo + 1.0f) / 4.0f * 16.0f)));
                    }
                }
            }
        });
    }

    @Unique
    private void setupAttribute(int location, float v0, float v1, float v2, float v3) {
        if (location != -1) {
            GL20.glVertexAttrib4f((int)location, (float)v0, (float)v1, (float)v2, (float)v3);
        }
    }

    @Unique
    private void renderFast(Level level, PhysicsEntity particle, Model model, BlockPos.MutableBlockPos blockPos) {
        Mesh mesh = model.mesh;
        boolean shade = particle.shade;
        int size = mesh.indices.size();
        if (size < 3) {
            return;
        }
        int brightness = mesh.light.size() == 0 ? particle.getLight(level, blockPos) : 0;
        int overlay = model.overlay;
        if (model.vao == null) {
            model.brightness = brightness;
            float b = (float)(particle.color & 0xFF) / 255.0f;
            float g = (float)(particle.color >> 8 & 0xFF) / 255.0f;
            float r = (float)(particle.color >> 16 & 0xFF) / 255.0f;
            int color = (int)(r * 255.0f) | (int)(g * 255.0f) << 8 | (int)(b * 255.0f) << 16 | 0xFF000000;
            net.diebuddies.opengl.Mesh openglMesh = new net.diebuddies.opengl.Mesh();
            this.checkArrays(size);
            float minU = 0.0f;
            float maxU = 1.0f;
            float minV = 0.0f;
            float maxV = 1.0f;
            if (model.customUVs != null) {
                minU = model.customUVs.x;
                maxU = model.customUVs.y;
                minV = model.customUVs.z;
                maxV = model.customUVs.w;
            } else if (model.texture != null) {
                minU = model.texture.m_118409_();
                maxU = model.texture.m_118410_();
                minV = model.texture.m_118411_();
                maxV = model.texture.m_118412_();
            }
            for (int i = 0; i < size; ++i) {
                Vector3i index = mesh.indices.get(i);
                Vector3d p = mesh.positions.get(index.x - 1);
                Vector2f uv = mesh.uvs.get(index.y - 1);
                org.joml.Vector3f normal = mesh.normals.get(index.z - 1);
                if (mesh.colors.size() > 0) {
                    color = mesh.colors.getInt(index.x - 1);
                }
                if (mesh.light.size() > 0) {
                    brightness = mesh.light.getInt(index.x - 1);
                }
                this.mlight[i] = brightness;
                this.mcol[i] = color;
                this.moverlay[i] = overlay;
                this.mpos[i * 3] = (float)p.x;
                this.mpos[i * 3 + 1] = (float)p.y;
                this.mpos[i * 3 + 2] = (float)p.z;
                int uvx = (int)(65535.0f * Math.remapClamp(uv.x, 0.0f, 1.0f, minU, maxU)) & 0xFFFF;
                int uvy = (int)(65535.0f * Math.remapClamp(uv.y, 0.0f, 1.0f, minV, maxV)) & 0xFFFF;
                this.muv[i] = uvy << 16 | uvx;
                this.mnormals[i] = shade ? Pack.normal(normal.x, normal.y, normal.z) : Pack.UP_NORMAL;
                this.mindices[i] = i;
            }
            openglMesh.set(this.mpos, Data.POSITION);
            openglMesh.set(this.mcol, Data.COLOR);
            openglMesh.set(this.muv, Data.TEX_COORD);
            openglMesh.set(this.moverlay, Data.OVERLAY);
            openglMesh.set(this.mlight, Data.LIGHT);
            openglMesh.set(this.mnormals, Data.NORMAL);
            openglMesh.set(this.mindices, Data.INDEX);
            openglMesh.setSize(Data.POSITION, size * 3);
            openglMesh.setSize(Data.COLOR, size);
            openglMesh.setSize(Data.TEX_COORD, size);
            openglMesh.setSize(Data.OVERLAY, size);
            openglMesh.setSize(Data.LIGHT, size);
            openglMesh.setSize(Data.NORMAL, size);
            openglMesh.setSize(Data.INDEX, size);
            model.vao = openglMesh.constructVAO(Usage.DYNAMIC);
        }
        if (brightness != model.brightness && mesh.light.size() == 0) {
            model.brightness = brightness;
            this.checkArrays(size);
            Arrays.fill(this.mlight, 0, size, brightness);
            model.vao.bind();
            model.vao.updateAttribute(Data.LIGHT, this.mlight, size, 0L);
        }
        ShaderInstance shader = RenderSystem.m_157196_();
        shader.f_173308_.m_5679_(RenderSystem.m_157190_());
        RenderSystem.m_157461_((ShaderInstance)shader);
        if (!StarterClient.optifabric) {
            if (shader.f_173313_ != null) {
                shader.f_173313_.m_85633_();
            }
            if (shader.f_173314_ != null) {
                shader.f_173314_.m_85633_();
            }
            shader.f_173308_.m_85633_();
        }
        model.vao.render();
    }

    @Unique
    private void checkArrays(int neededSize) {
        boolean changed = false;
        while (neededSize > this.size) {
            this.size *= 2;
            changed = true;
        }
        if (changed) {
            this.mpos = new float[this.size * 3];
            this.mcol = new int[this.size];
            this.muv = new int[this.size];
            this.moverlay = new int[this.size];
            this.mlight = new int[this.size];
            this.mnormals = new int[this.size];
            this.mindices = new int[this.size];
        }
    }

    @Unique
    private void renderLegacy(Level level, PhysicsEntity particle, Model model, BlockPos.MutableBlockPos blockPos) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85812_);
        int brightness = particle.getLight(level, blockPos);
        Mesh mesh = model.mesh;
        boolean shade = particle.shade;
        float b = (float)(particle.color & 0xFF) / 255.0f;
        float g = (float)(particle.color >> 8 & 0xFF) / 255.0f;
        float r = (float)(particle.color >> 16 & 0xFF) / 255.0f;
        for (int i = 0; i < mesh.indices.size(); ++i) {
            Vector3i index = mesh.indices.get(i);
            Vector3d position = mesh.positions.get(index.x - 1);
            Vector2f uv = mesh.uvs.get(index.y - 1);
            org.joml.Vector3f normal = mesh.normals.get(index.z - 1);
            if (mesh.colors.size() > 0) {
                int color = mesh.colors.getInt(index.x - 1);
                r = (float)(color & 0xFF) / 255.0f;
                g = (float)(color >> 8 & 0xFF) / 255.0f;
                b = (float)(color >> 16 & 0xFF) / 255.0f;
            }
            float minU = 0.0f;
            float maxU = 1.0f;
            float minV = 0.0f;
            float maxV = 1.0f;
            if (model.customUVs != null) {
                minU = model.customUVs.x;
                maxU = model.customUVs.y;
                minV = model.customUVs.z;
                maxV = model.customUVs.w;
            } else if (model.texture != null) {
                minU = model.texture.m_118409_();
                maxU = model.texture.m_118410_();
                minV = model.texture.m_118411_();
                maxV = model.texture.m_118412_();
            }
            if (mesh.light.size() > 0) {
                brightness = mesh.light.getInt(index.x - 1);
            }
            if (shade) {
                bufferbuilder.m_5954_((float)position.x, (float)position.y, (float)position.z, r, g, b, 1.0f, Math.remap(uv.x, 0.0f, 1.0f, minU, maxU), Math.remap(uv.y, 0.0f, 1.0f, minV, maxV), model.overlay, brightness, normal.x, normal.y, normal.z);
                continue;
            }
            bufferbuilder.m_5954_((float)position.x, (float)position.y, (float)position.z, r, g, b, 1.0f, Math.remap(uv.x, 0.0f, 1.0f, minU, maxU), Math.remap(uv.y, 0.0f, 1.0f, minV, maxV), model.overlay, brightness, 0.0f, 1.0f, 0.0f);
        }
        tessellator.m_85914_();
    }

    @Unique
    private void debugRenderBox(float width, float height, float depth, float r, float g, float b, float a) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        float[] positions = new float[]{-0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f};
        int[] indices = new int[]{0, 1, 2, 0, 2, 3, 6, 5, 4, 7, 6, 4, 10, 9, 8, 11, 10, 8, 12, 13, 14, 12, 14, 15, 18, 17, 16, 19, 18, 16, 20, 21, 22, 20, 22, 23};
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i] * 3;
            bufferbuilder.m_5483_((double)(positions[index] * width), (double)(positions[index + 1] * height), (double)(positions[index + 2] * depth)).m_85950_(r, g, b, a).m_5752_();
        }
        tessellator.m_85914_();
    }

    @Unique
    private void setupShader(ShaderInstance shader) {
        for (int n = 0; n < 8; ++n) {
            int o = RenderSystem.m_157203_((int)n);
            shader.m_173350_("Sampler" + n, (Object)o);
        }
        if (shader.f_173308_ != null) {
            shader.f_173308_.m_5679_(RenderSystem.m_157190_());
        }
        if (shader.f_173309_ != null) {
            shader.f_173309_.m_5679_(RenderSystem.m_157192_());
        }
        if (shader.f_173312_ != null) {
            shader.f_173312_.m_5941_(RenderSystem.m_157197_());
        }
        if (shader.f_173315_ != null) {
            shader.f_173315_.m_5985_(RenderSystem.m_157200_());
        }
        if (shader.f_173316_ != null) {
            shader.f_173316_.m_5985_(RenderSystem.m_157199_());
        }
        if (shader.f_173317_ != null) {
            shader.f_173317_.m_5941_(RenderSystem.m_157198_());
        }
        if (shader.f_173310_ != null) {
            shader.f_173310_.m_5679_(RenderSystem.m_157207_());
        }
        if (shader.f_173319_ != null) {
            shader.f_173319_.m_5985_(RenderSystem.m_157201_());
        }
        if (shader.f_173311_ != null) {
            Window window = Minecraft.m_91087_().m_91268_();
            shader.f_173311_.m_7971_((float)window.m_85441_(), (float)window.m_85442_());
        }
        RenderSystem.m_157461_((ShaderInstance)shader);
        shader.m_173363_();
    }

    @Unique
    private List<PhysicsEntity> getBlockData(PhysicsWorld physics, BlockUpdate update, Level level) {
        ObjectArrayList particles = new ObjectArrayList();
        BlockPos pos = update.pos;
        BlockState state = update.state;
        ModelResourceLocation id = BlockModelShaper.m_110895_((BlockState)state);
        BakedModel bakedModel = Minecraft.m_91087_().m_91304_().m_119422_(id);
        if (state.m_60734_() == Blocks.f_50180_ || state.m_60734_() == Blocks.f_50181_ || state.m_60734_() == Blocks.f_50182_) {
            bakedModel = null;
        }
        if (bakedModel instanceof MultiPartBakedModel) {
            MultiPartBakedModel multi = (MultiPartBakedModel)bakedModel;
            BitSet bitSet = (BitSet)multi.f_119460_.get(state);
            if (bitSet == null) {
                bitSet = new BitSet();
                for (int i = 0; i < multi.f_119459_.size(); ++i) {
                    Pair pair = (Pair)multi.f_119459_.get(i);
                    if (!((Predicate)pair.getLeft()).test(state)) continue;
                    bitSet.set(i);
                }
                multi.f_119460_.put(state, bitSet);
            }
            for (int j = 0; j < bitSet.length(); ++j) {
                if (!bitSet.get(j)) continue;
                BakedModel model = (BakedModel)((Pair)multi.f_119459_.get(j)).getRight();
                JsonUnbakedModelHolder unbakedModel = PhysicsMod.loadedModels.get(model);
                if (unbakedModel != null) {
                    this.addParticles((List<PhysicsEntity>)particles, unbakedModel, level, update);
                    continue;
                }
                PhysicsEntity entity = PhysicsMod.getInstance(level).renderBlockIntoEntity(PhysicsEntity.Type.BLOCK, model, update.state, update.pos);
                if (entity == null) continue;
                physics.addBlockParticle(entity).applyRandomSpawnForces();
            }
        } else {
            JsonUnbakedModelHolder unbakedModel = PhysicsMod.loadedModels.get(bakedModel);
            if (unbakedModel != null && unbakedModel.model instanceof BlockModel) {
                PhysicsEntity entity;
                this.addParticles((List<PhysicsEntity>)particles, unbakedModel, level, update);
                if (particles.size() == 0 && bakedModel != null && (entity = PhysicsMod.getInstance(level).renderBlockIntoEntity(PhysicsEntity.Type.BLOCK, bakedModel, update.state, update.pos)) != null) {
                    physics.addBlockParticle(entity).applyRandomSpawnForces();
                }
            } else {
                PhysicsEntity particle = new PhysicsEntity(PhysicsEntity.Type.BLOCK, update.state);
                Minecraft minecraft = Minecraft.m_91087_();
                BlockRenderDispatcher ren = minecraft.m_91289_();
                BakedModel model = ren.m_110910_(state);
                Vec3 blockOffset = update.state.m_60824_((BlockGetter)update.level, update.pos);
                particle.setTransformation(new Matrix4d().translate((double)pos.m_123341_() + 0.5 + blockOffset.f_82479_, (double)pos.m_123342_() + 0.5 + blockOffset.f_82480_, (double)pos.m_123343_() + 0.5 + blockOffset.f_82481_));
                particle.setOldTransformation(new Matrix4d(particle.getTransformation()));
                particle.models.get((int)0).texture = model.m_6160_();
                particle.models.get((int)0).textureIDs = new int[]{model.m_6160_().m_118414_().m_117963_()};
                int color = Minecraft.m_91087_().m_91298_().m_92577_(update.state, (BlockAndTintGetter)level, update.pos, 0);
                if (color == -1) {
                    color = -1;
                }
                particle.color = color;
                if (update.state.m_60734_() == Blocks.f_50256_ || update.state.m_60734_() == Blocks.f_50440_) {
                    particle.color = -1;
                }
                particles.add(particle);
            }
        }
        return particles;
    }

    @Unique
    private void addParticles(List<PhysicsEntity> particles, JsonUnbakedModelHolder unbakedModel, Level level, BlockUpdate update) {
        BlockState state = update.state;
        BlockPos pos = update.pos;
        Vec3 blockOffset = state.m_60824_((BlockGetter)update.level, pos);
        for (BlockElement element : unbakedModel.model.m_111436_()) {
            int color;
            PhysicsEntity particle = new PhysicsEntity(PhysicsEntity.Type.BLOCK, state);
            particle.min.set(element.f_111308_.m_122239_() / 16.0f, element.f_111308_.m_122260_() / 16.0f, element.f_111308_.m_122269_() / 16.0f);
            particle.max.set(element.f_111309_.m_122239_() / 16.0f, element.f_111309_.m_122260_() / 16.0f, element.f_111309_.m_122269_() / 16.0f);
            particle.shade = element.f_111312_;
            Minecraft minecraft = Minecraft.m_91087_();
            BlockRenderDispatcher ren = minecraft.m_91289_();
            BakedModel model = ren.m_110910_(state);
            Matrix4f m = unbakedModel.transformation;
            Matrix4d modelTransformation = new Matrix4d();
            StarterClient.setMatrix(modelTransformation, m);
            Matrix4d transformation = new Matrix4d();
            transformation.mul(modelTransformation);
            if (element.f_111311_ != null) {
                transformation.translate((double)element.f_111311_.f_111378_.m_122239_() - 0.5, (double)element.f_111311_.f_111378_.m_122260_() - 0.5, (double)element.f_111311_.f_111378_.m_122269_() - 0.5);
                transformation.mul(StarterClient.setMatrix(this.tmpMatrix, this.getElementRotation(element.f_111311_)));
                transformation.translate(-((double)element.f_111311_.f_111378_.m_122239_() - 0.5), -((double)element.f_111311_.f_111378_.m_122260_() - 0.5), -((double)element.f_111311_.f_111378_.m_122269_() - 0.5));
            }
            transformation.m30(transformation.m30() + (double)pos.m_123341_() + 0.5 + blockOffset.f_82479_);
            transformation.m31(transformation.m31() + (double)pos.m_123342_() + 0.5 + blockOffset.f_82480_);
            transformation.m32(transformation.m32() + (double)pos.m_123343_() + 0.5 + blockOffset.f_82481_);
            particle.setTransformation(transformation);
            particle.setOldTransformation(new Matrix4d(particle.getTransformation()));
            particle.models.get((int)0).texture = model.m_6160_();
            if (element.f_111310_.values().size() > 0 && !excludeBlockPhysicsTexture.contains(state.m_60734_())) {
                TextureAtlasSprite sprite;
                particle.models.get((int)0).texture = sprite = PhysicsMod.atlasSet.m_117971_(unbakedModel.model.m_111480_(((BlockElementFace)element.f_111310_.values().iterator().next()).f_111356_));
            }
            if (particle.models.get((int)0).texture != null) {
                particle.models.get((int)0).textureIDs = new int[]{particle.models.get((int)0).texture.m_118414_().m_117963_()};
            }
            if ((color = Minecraft.m_91087_().m_91298_().m_92577_(update.state, (BlockAndTintGetter)level, update.pos, 0)) == -1) {
                color = -1;
            }
            particle.color = color;
            if (update.state.m_60734_() == Blocks.f_50256_ || update.state.m_60734_() == Blocks.f_50440_) {
                particle.color = -1;
            }
            particles.add(particle);
        }
    }

    private Matrix4f getElementRotation(BlockElementRotation blockElementRotation) {
        Vector3f rotationAxis = Vector3f.f_122225_;
        switch (blockElementRotation.f_111379_) {
            case X: {
                rotationAxis = Vector3f.f_122223_;
                break;
            }
            case Y: {
                rotationAxis = Vector3f.f_122225_;
                break;
            }
            case Z: {
                rotationAxis = Vector3f.f_122227_;
            }
        }
        return new Matrix4f(rotationAxis.m_122240_(blockElementRotation.f_111380_));
    }

    static {
        excludeBlockPhysicsTexture.add(Blocks.f_50003_);
        excludeBlockPhysicsTexture.add(Blocks.f_49999_);
        excludeBlockPhysicsTexture.add(Blocks.f_50001_);
        excludeBlockPhysicsTexture.add(Blocks.f_50002_);
        excludeBlockPhysicsTexture.add(Blocks.f_50004_);
        excludeBlockPhysicsTexture.add(Blocks.f_50000_);
    }
}

