/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.diebuddies.bridge.ReflectionsForge;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.model.ColladaMesh;
import net.diebuddies.physics.Cape;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.util.PlayerLevelPacked;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CapeLayer.class})
public class MixinCapeFeatureRenderer {
    @Unique
    private Map<PlayerLevelPacked, VerletSimulation> simulations = new Object2ObjectOpenHashMap();
    @Unique
    private Matrix4f localT = new Matrix4f();
    @Unique
    private AbstractClientPlayer player;
    @Unique
    private float tickDelta;
    @Unique
    private float animationProgress;
    @Unique
    private boolean renderedCape;
    @Unique
    private MultiBufferSource multiBufferSource;
    @Unique
    private PlayerLevelPacked tmp = new PlayerLevelPacked(null, null);

    @Inject(at={@At(value="HEAD")}, method={"render"})
    public void renderHead(PoseStack matrixStack, MultiBufferSource multiBufferSource, int light, AbstractClientPlayer player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo info) {
        this.player = player;
        this.tickDelta = tickDelta;
        this.animationProgress = animationProgress;
        this.renderedCape = false;
        this.multiBufferSource = multiBufferSource;
    }

    @Inject(at={@At(value="RETURN")}, method={"render"})
    public void renderTail(PoseStack matrixStack, MultiBufferSource multiBufferSource, int light, AbstractClientPlayer player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo info) {
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/model/PlayerModel;renderCloak(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V"))
    public void renderCloak(PlayerModel playerModel, PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay) {
        ((PlayerModel)((CapeLayer)this).m_117386_()).m_103411_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_);
        this.renderedCape = true;
    }

    private boolean shouldRenderPhysicsCape(AbstractClientPlayer player) {
        return !PhysicsMod.hudRendering && ConfigClient.capePhysics && player.m_108555_() && !player.m_20145_() && (player.m_108561_() != null || Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_36316_().getName().equals(player.m_36316_().getName()) && ConfigClient.physicsModCape || this.getCapeMesh(player) != null);
    }

    private void renderPhysicsCape(AbstractClientPlayer player, int light) {
    }

    private int getCapeTexture(AbstractClientPlayer player) {
        Cape cape;
        if (this.isPlayerMojangCape(player)) {
            return Minecraft.m_91087_().m_91097_().m_118506_(player.m_108561_()).m_117963_();
        }
        String capeName = ConfigClient.getCustomCape(player.m_36316_().getName());
        if (player == Minecraft.m_91087_().f_91074_) {
            capeName = ConfigClient.selectedPhysicsCape;
        }
        if ((cape = PhysicsMod.capes.get(capeName)) == null) {
            if (this.isMojangCape(player)) {
                return Minecraft.m_91087_().m_91097_().m_118506_(player.m_108561_()).m_117963_();
            }
            return 0;
        }
        return cape.texture.getID();
    }

    private ColladaMesh getCapeMesh(AbstractClientPlayer player) {
        Cape cape;
        if (this.isPlayerMojangCape(player)) {
            return PhysicsMod.defaultCape.mesh;
        }
        String capeName = ConfigClient.getCustomCape(player.m_36316_().getName());
        if (player == Minecraft.m_91087_().f_91074_) {
            capeName = ConfigClient.selectedPhysicsCape;
        }
        if ((cape = PhysicsMod.capes.get(capeName)) == null) {
            if (this.isMojangCape(player)) {
                return PhysicsMod.defaultCape.mesh;
            }
            return null;
        }
        return cape.mesh;
    }

    public boolean isMojangCape(AbstractClientPlayer player) {
        return player.m_108561_() != null;
    }

    public boolean isPlayerMojangCape(AbstractClientPlayer player) {
        return player.m_108561_() != null && !ConfigClient.physicsModCape && Minecraft.m_91087_().f_91074_ == player;
    }

    @Unique
    private void capeTransformation(PoseStack modelMatrix, AbstractClientPlayer player, float tickDelta) {
        modelMatrix.m_85837_(0.0, 0.0, 0.125);
        PlayerModel entityModel = (PlayerModel)((CapeLayer)this).m_117386_();
        entityModel.f_103373_.m_104299_(modelMatrix);
    }

    @Unique
    private void playerTransformation(PoseStack modelMatrix, VerletSimulation simulation, AbstractClientPlayer player, float tickDelta, float animationProgress) {
        Direction direction;
        LivingEntityRenderer renderer = (LivingEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)player);
        double px = Mth.m_14139_((double)tickDelta, (double)player.f_19790_, (double)player.m_20185_());
        double py = Mth.m_14139_((double)tickDelta, (double)player.f_19791_, (double)player.m_20186_());
        double pz = Mth.m_14139_((double)tickDelta, (double)player.f_19792_, (double)player.m_20189_());
        Vec3 positionOffset = renderer.m_7860_((Entity)player, tickDelta);
        modelMatrix.m_85837_(positionOffset.f_82479_ + (px -= player.m_20185_()), positionOffset.f_82480_ + (py -= player.m_20186_()), positionOffset.f_82481_ + (pz -= player.m_20189_()));
        float yaw = Mth.m_14189_((float)tickDelta, (float)player.f_20884_, (float)player.f_20883_);
        if (player.m_20089_() == Pose.SLEEPING && (direction = player.m_21259_()) != null) {
            float eyeHeight = player.m_20236_(Pose.STANDING) - 0.1f;
            modelMatrix.m_85837_((double)((float)(-direction.m_122429_()) * eyeHeight), 0.0, (double)((float)(-direction.m_122431_()) * eyeHeight));
        }
        try {
            ReflectionsForge.setupRotations.invoke((Object)renderer, player, modelMatrix, Float.valueOf(animationProgress), Float.valueOf(yaw), Float.valueOf(tickDelta));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        modelMatrix.m_85841_(-1.0f, -1.0f, 1.0f);
        modelMatrix.m_85841_(0.9375f, 0.9375f, 0.9375f);
        modelMatrix.m_85837_(0.0, (double)-1.501f, 0.0);
    }
}

