/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import java.util.List;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class MixinMinecraft {
    @Unique
    public boolean renderedFrame = true;

    @Inject(at={@At(value="TAIL")}, method={"runTick"})
    public void runTick(boolean value, CallbackInfo info) {
        this.renderedFrame = true;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;tickEntities()V", shift=At.Shift.AFTER)})
    public void tick(CallbackInfo info) {
        double delta = 0.05;
        for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
            List<VerletSimulation> simulations = mod.getPhysicsWorld().getVerletSimulations();
            for (int i = 0; i < simulations.size(); ++i) {
                VerletSimulation simulation = simulations.get(i);
                if ((!simulation.active || simulation.destroyed) && this.renderedFrame) {
                    simulation.destroyed = true;
                    simulations.remove(i--);
                    continue;
                }
                simulation.update(delta);
            }
        }
        this.renderedFrame = false;
    }
}

