/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.vines;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.List;
import java.util.function.Consumer;
import net.diebuddies.compat.Sodium;
import net.diebuddies.minecraft.ChunkHelper;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ragdoll.DynamicRagdoll;
import net.diebuddies.physics.vines.DynamicSetting;
import net.diebuddies.physics.vines.VineHelper;
import net.diebuddies.physics.vines.VineLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.joml.Vector3i;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientChunkCache.class})
public class MixinClientChunkManager
implements VineLoader {
    @Shadow
    @Final
    volatile ClientChunkCache.Storage f_104410_;
    @Unique
    private Long2ObjectMap<List<DynamicRagdoll>> loadedVines = new Long2ObjectOpenHashMap();
    @Unique
    private PhysicsMod mod;
    @Unique
    private LongSet loadedChunksSodiumFix = new LongOpenHashSet();
    @Unique
    private int loadDistance;

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void constructor(ClientLevel level, int loadDistance, CallbackInfo info) {
        this.loadDistance = loadDistance;
    }

    @Override
    public void chunkPosChanged() {
        if (this.mod == null) {
            return;
        }
        LongIterator it = this.loadedChunksSodiumFix.iterator();
        ObjectOpenHashSet affectedChunks = new ObjectOpenHashSet();
        while (it.hasNext()) {
            boolean shouldBeLoaded;
            long chunkIndex = it.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            int chunkZ = ChunkHelper.getChunkZ(chunkIndex);
            boolean isLoaded = this.loadedVines.containsKey(chunkIndex);
            if (isLoaded == (shouldBeLoaded = VineHelper.isChunkInRange(chunkX, chunkZ))) continue;
            if (isLoaded) {
                this.unloadChunk(chunkX, chunkZ, (ObjectSet<Vector3i>)affectedChunks, StarterClient.sodium || StarterClient.optifabric);
            } else {
                this.loadChunk(((ClientChunkCache)this).m_62227_(chunkX, chunkZ, false), chunkX, chunkZ, (ObjectSet<Vector3i>)affectedChunks);
            }
            for (Vector3i affectedChunk : affectedChunks) {
                if (StarterClient.sodium) {
                    Sodium.scheduleChunkRebuild(Minecraft.m_91087_().f_91060_, affectedChunk.x, affectedChunk.y, affectedChunk.z, true);
                    continue;
                }
                Minecraft.m_91087_().f_91060_.m_109501_(affectedChunk.x, affectedChunk.y, affectedChunk.z, true);
            }
            affectedChunks.clear();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"updateViewRadius"})
    public void updateLoadDistance(int loadDistance, CallbackInfo info) {
        this.loadDistance = loadDistance;
        ObjectIterator it = this.loadedVines.long2ObjectEntrySet().iterator();
        while (it.hasNext()) {
            int chunkZ;
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
            long chunkIndex = entry.getLongKey();
            List ragdolls = (List)entry.getValue();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            if (this.isInRadius(loadDistance, chunkX, chunkZ = ChunkHelper.getChunkZ(chunkIndex))) continue;
            this.loadedChunksSodiumFix.remove(chunkIndex);
            if (this.mod != null) {
                this.unloadRagdolls(ragdolls, false);
            }
            it.remove();
        }
    }

    @Unique
    public boolean isInRadius(int radius, int chunkX, int chunkZ) {
        return Math.abs(chunkX - this.f_104410_.f_104469_) <= radius && Math.abs(chunkZ - this.f_104410_.f_104470_) <= radius;
    }

    @Inject(at={@At(value="HEAD")}, method={"drop"})
    public void drop(int chunkX, int chunkZ, CallbackInfo info) {
        long chunkIndex = ChunkHelper.calcChunkIndex(chunkX, chunkZ);
        this.loadedChunksSodiumFix.remove(chunkIndex);
        if (this.mod != null) {
            this.unloadChunk(chunkX, chunkZ);
        }
    }

    @Unique
    private void unloadChunk(int chunkX, int chunkZ) {
        this.unloadChunk(chunkX, chunkZ, null, false);
    }

    @Unique
    private void unloadChunk(int chunkX, int chunkZ, ObjectSet<Vector3i> affectedChunks, boolean removeOneFrameLater) {
        long chunkIndex = ChunkHelper.calcChunkIndex(chunkX, chunkZ);
        List ragdolls = (List)this.loadedVines.remove(chunkIndex);
        if (affectedChunks != null && ragdolls != null) {
            for (DynamicRagdoll ragdoll : ragdolls) {
                for (BlockPos pos : ragdoll.getBlockPositions()) {
                    affectedChunks.add((Object)new Vector3i(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123342_()), SectionPos.m_123171_((int)pos.m_123343_())));
                }
            }
        }
        this.unloadRagdolls(ragdolls, removeOneFrameLater);
    }

    @Unique
    private void unloadRagdolls(List<DynamicRagdoll> ragdolls, boolean removeOneFrameLater) {
        if (ragdolls != null) {
            for (DynamicRagdoll ragdoll : ragdolls) {
                if (removeOneFrameLater) {
                    this.mod.sodiumRemoveRagdolls.add(ragdoll);
                    continue;
                }
                this.mod.physicsWorld.removeRagdoll(ragdoll);
            }
        }
    }

    @Override
    public void unloadAllRagdolls() {
        for (List ragdolls : this.loadedVines.values()) {
            this.unloadRagdolls(ragdolls, false);
        }
        this.loadedVines.clear();
    }

    @Override
    public void loadAllRagdolls() {
        if (this.mod == null) {
            return;
        }
        LongIterator it = this.loadedChunksSodiumFix.iterator();
        while (it.hasNext()) {
            int chunkZ;
            long chunkIndex = it.nextLong();
            int chunkX = ChunkHelper.getChunkX(chunkIndex);
            if (!VineHelper.isChunkInRange(chunkX, chunkZ = ChunkHelper.getChunkZ(chunkIndex))) continue;
            this.loadChunk(((ClientChunkCache)this).m_7587_(chunkX, chunkZ, null, false), chunkX, chunkZ);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"replaceWithPacketData"})
    public void replaceWithPacketData(int x, int z, FriendlyByteBuf buf, CompoundTag nbt, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer, CallbackInfoReturnable<LevelChunk> info) {
        LevelChunk chunk = (LevelChunk)info.getReturnValue();
        long chunkIndex = ChunkHelper.calcChunkIndex(x, z);
        this.loadedChunksSodiumFix.add(chunkIndex);
        if (VineHelper.isChunkInRange(x, z) && this.mod != null) {
            this.loadChunk(chunk, x, z);
        }
    }

    @Unique
    private void loadChunk(LevelChunk chunk, int x, int z) {
        this.loadChunk(chunk, x, z, null);
    }

    @Unique
    private void loadChunk(LevelChunk chunk, int x, int z, ObjectSet<Vector3i> affectedChunks) {
        long chunkIndex = ChunkHelper.calcChunkIndex(x, z);
    }

    @Override
    public void addVineRagdoll(DynamicRagdoll ragdoll, BlockPos pos) {
        long chunkIndex = ChunkHelper.calcChunkIndex(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()));
        List ragdolls = (List)this.loadedVines.get(chunkIndex);
        if (ragdolls == null) {
            ragdolls = new ObjectArrayList();
            this.loadedVines.put(chunkIndex, (Object)ragdolls);
        }
        ragdolls.add(ragdoll);
    }

    @Override
    public void removeVineRagdoll(DynamicRagdoll ragdoll) {
        BlockPos pos;
        long chunkIndex;
        List ragdolls;
        if (ragdoll.getBlockPositions().size() > 0 && (ragdolls = (List)this.loadedVines.get(chunkIndex = ChunkHelper.calcChunkIndex(SectionPos.m_123171_((int)(pos = ragdoll.getBlockPositions().get(0)).m_123341_()), SectionPos.m_123171_((int)pos.m_123343_())))) != null) {
            ragdolls.remove(ragdoll);
        }
    }

    @Unique
    private List<DynamicRagdoll> searchConnections(int chunkX, int chunkZ, Long2ObjectMap<BlockState> vines) {
        ObjectArrayList ragdolls = new ObjectArrayList();
        while (vines.size() > 0) {
            DynamicRagdoll ragdoll;
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)vines.long2ObjectEntrySet().iterator().next();
            long index = entry.getLongKey();
            BlockState current = (BlockState)entry.getValue();
            int x = (int)(index >> 60) & 0xF;
            int y = (int)(index & 0xFFFFFFFFFFFFFFL);
            int z = (int)(index >> 56) & 0xF;
            DynamicSetting setting = VineHelper.getSetting(current);
            if (setting == null || (ragdoll = setting.createRagdoll(this.mod, current, new BlockPos(x + chunkX * 16, y, z + chunkZ * 16), vines)) == null) continue;
            ragdolls.add(ragdoll);
        }
        return ragdolls;
    }

    @Override
    public void setPhysicsMod(PhysicsMod physicsMod) {
        if (this.mod != null) {
            if (this.mod != physicsMod) {
                this.unloadAllRagdolls();
                this.mod = physicsMod;
                if (physicsMod != null) {
                    this.loadAllRagdolls();
                }
            }
        } else {
            this.mod = physicsMod;
            if (physicsMod != null) {
                this.loadAllRagdolls();
            }
        }
    }
}

