/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.opengl;

import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.List;
import net.diebuddies.opengl.BufferObject;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.DataStorage;
import net.diebuddies.opengl.Type;
import net.diebuddies.opengl.Usage;
import net.diebuddies.opengl.VAO;
import org.joml.Matrix4d;
import org.joml.Vector3d;
import org.lwjgl.opengl.GL32C;

public class Mesh {
    private DataStorage storage;

    public Mesh(Mesh mesh) {
        this.storage = new DataStorage(mesh.storage);
    }

    public Mesh() {
        this.storage = new DataStorage();
    }

    public VAO constructVAO(Usage usage) {
        VAO vao = new VAO(usage);
        int oldVao = GL32C.glGetInteger((int)34229);
        vao.bind();
        for (Data type : Data.values()) {
            Object dataArray = this.storage.getNative(type);
            if (type == Data.INDEX || dataArray == null) continue;
            if (dataArray instanceof float[]) {
                vao.attachAttribute(type, (float[])dataArray, this.storage.size(type));
                continue;
            }
            if (dataArray instanceof int[]) {
                vao.attachAttribute(type, (int[])dataArray, this.storage.size(type));
                continue;
            }
            if (dataArray instanceof short[]) {
                vao.attachAttribute(type, (short[])dataArray, this.storage.size(type));
                continue;
            }
            if (!(dataArray instanceof byte[])) continue;
            vao.attachAttribute(type, (byte[])dataArray, this.storage.size(type));
        }
        if (this.storage.getNative(Data.INDEX) instanceof int[]) {
            vao.attachIndices((int[])this.storage.getNative(Data.INDEX), this.storage.size(Data.INDEX));
        } else {
            vao.attachIndices((short[])this.storage.getNative(Data.INDEX), this.storage.size(Data.INDEX));
        }
        vao.finish();
        GL32C.glBindVertexArray((int)oldVao);
        BufferObject.unbind(Type.DATA.getType());
        return vao;
    }

    public static Mesh createFromMultiple(List<Mesh> meshes, List<Matrix4d> transformations) {
        if (meshes.isEmpty()) {
            return new Mesh();
        }
        Mesh mesh = new Mesh();
        Vector3d newPos = new Vector3d();
        for (Data type : Data.values()) {
            int size = 0;
            for (Mesh toAdd : meshes) {
                size += toAdd.size(type);
            }
            if (size <= 0) continue;
            if (type != Data.INDEX) {
                Object[] newData = null;
                int offset = 0;
                for (int i = 0; i < meshes.size(); ++i) {
                    Mesh toAdd = meshes.get(i);
                    Matrix4d transformation = transformations.get(i);
                    Object dataArray = toAdd.getNative(type);
                    if (dataArray != null) {
                        if (dataArray instanceof float[]) {
                            if (newData == null) {
                                newData = new float[size];
                            }
                            System.arraycopy(dataArray, 0, newData, offset, ((float[])dataArray).length);
                            if (type == Data.POSITION) {
                                int length = ((float[])dataArray).length;
                                Object[] d = newData;
                                for (int j = 0; j < length / 3; ++j) {
                                    int vp = offset + j * 3;
                                    transformation.transformPosition(d[vp], d[vp + 1], d[vp + 2], newPos);
                                    d[vp] = (float)newPos.x;
                                    d[vp + 1] = (float)newPos.y;
                                    d[vp + 2] = (float)newPos.z;
                                }
                            }
                        } else if (dataArray instanceof int[]) {
                            if (newData == null) {
                                newData = new int[size];
                            }
                            System.arraycopy(dataArray, 0, newData, offset, ((int[])dataArray).length);
                        } else if (dataArray instanceof short[]) {
                            if (newData == null) {
                                newData = new short[size];
                            }
                            System.arraycopy(dataArray, 0, newData, offset, ((short[])dataArray).length);
                        } else if (dataArray instanceof byte[]) {
                            if (newData == null) {
                                newData = new byte[size];
                            }
                            System.arraycopy(dataArray, 0, newData, offset, ((byte[])dataArray).length);
                        }
                    }
                    offset += toAdd.size(type);
                }
                if (newData instanceof float[]) {
                    mesh.set((float[])newData, type);
                    continue;
                }
                if (newData instanceof int[]) {
                    mesh.set((int[])newData, type);
                    continue;
                }
                if (newData instanceof short[]) {
                    mesh.set((short[])newData, type);
                    continue;
                }
                if (!(newData instanceof byte[])) continue;
                mesh.set((byte[])newData, type);
                continue;
            }
            int[] indices = new int[size];
            int count = 0;
            int currentOffset = 0;
            for (Mesh toAdd : meshes) {
                int[] mIndices = (int[])toAdd.getNative(type);
                for (int i = 0; i < mIndices.length; ++i) {
                    indices[count++] = mIndices[i] + currentOffset;
                }
                currentOffset += toAdd.size(Data.POSITION) / 3;
            }
            mesh.set(indices, type);
        }
        return mesh;
    }

    public static Vector3d calculateCenter(List<Mesh> meshes, DoubleList volumes) {
        int i;
        Vector3d center = new Vector3d();
        double totalVolume = 0.0;
        for (i = 0; i < volumes.size(); ++i) {
            totalVolume += volumes.getDouble(i);
        }
        for (i = 0; i < meshes.size(); ++i) {
            Mesh mesh = meshes.get(i);
            int count = 0;
            float[] positions = (float[])mesh.getNative(Data.POSITION);
            Vector3d meshCenter = new Vector3d();
            if (positions != null) {
                for (int j = 0; j < positions.length / 3; ++j) {
                    meshCenter.add(positions[j * 3], positions[j * 3 + 1], positions[j * 3 + 2]);
                    ++count;
                }
            }
            meshCenter.mul(1.0 / (double)count);
            center.add(meshCenter.mul(volumes.getDouble(i) / totalVolume));
        }
        return center;
    }

    public static Vector3d calculateCenter(List<Mesh> meshes) {
        Vector3d center = new Vector3d();
        int count = 0;
        for (Mesh mesh : meshes) {
            float[] positions = (float[])mesh.getNative(Data.POSITION);
            if (positions == null) continue;
            for (int i = 0; i < positions.length / 3; ++i) {
                center.add(positions[i * 3], positions[i * 3 + 1], positions[i * 3 + 2]);
                ++count;
            }
        }
        return center.mul(1.0 / (double)count);
    }

    public void transform(Matrix4d transformation) {
        float[] positions = (float[])this.getNative(Data.POSITION);
        Vector3d tmp = new Vector3d();
        if (positions != null) {
            for (int i = 0; i < positions.length / 3; ++i) {
                transformation.transformPosition(positions[i * 3], positions[i * 3 + 1], positions[i * 3 + 2], tmp);
                positions[i * 3] = (float)tmp.x;
                positions[i * 3 + 1] = (float)tmp.y;
                positions[i * 3 + 2] = (float)tmp.z;
            }
        }
    }

    public VAO constructVAO() {
        return this.constructVAO(Usage.STATIC);
    }

    public int size(Data type) {
        return this.storage.size(type);
    }

    public void setSize(Data type, int size) {
        this.storage.setSize(type, size);
    }

    public Object getNative(Data type) {
        return this.storage.getNative(type);
    }

    public void set(byte[] data, Data type) {
        if (data == null || data.length == 0) {
            return;
        }
        this.storage.set(data, type);
    }

    public void set(short[] data, Data type) {
        if (data == null || data.length == 0) {
            return;
        }
        this.storage.set(data, type);
    }

    public void set(float[] data, Data type) {
        if (data == null || data.length == 0) {
            return;
        }
        this.storage.set(data, type);
    }

    public void set(double[] data, Data type) {
        if (data == null || data.length == 0) {
            return;
        }
        this.storage.set(data, type);
    }

    public void set(int[] data, Data type) {
        if (data == null || data.length == 0) {
            return;
        }
        this.storage.set(data, type);
    }

    public DataStorage getStorage() {
        return this.storage;
    }
}

