/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.opengl;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.List;
import net.diebuddies.opengl.BufferObject;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.Type;
import net.diebuddies.opengl.Usage;
import net.diebuddies.physics.StarterClient;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryStack;

public class VAO {
    public int id = this.createBuffer();
    public Usage usage;
    public List<BufferObjectData> dataBuffer = new ObjectArrayList();
    public BufferObject indexBuffer;
    public int numberIndices;
    public int indexBufferType;

    public VAO(Usage usage) {
        this.usage = usage;
        this.numberIndices = 0;
    }

    public VAO() {
        this(Usage.STATIC);
    }

    private int createBuffer() {
        return GL32C.glGenVertexArrays();
    }

    public void bind() {
        this.bindVAO();
    }

    public static void unbind() {
        VAO.unbindVAO();
    }

    public void render() {
        this.render(4);
    }

    public void render(int type) {
        if (this.numberIndices == 0) {
            return;
        }
        this.bind();
        GL32C.glDrawElements((int)type, (int)this.numberIndices, (int)this.indexBufferType, (long)0L);
    }

    public void renderArrays(int type, int first, int count) {
        if (count == 0) {
            return;
        }
        this.bind();
        GL32C.glDrawArrays((int)type, (int)first, (int)count);
    }

    public void renderEmptyTriangle() {
        this.renderArrays(4, 0, 3);
    }

    public void renderInstanced(int count) {
        this.renderInstanced(4, count);
    }

    public void renderInstanced(int type, int count) {
        this.bind();
        GL32C.glDrawElementsInstanced((int)type, (int)this.numberIndices, (int)this.indexBufferType, (long)0L, (int)count);
    }

    public void bindAttributes() {
        this.bindVAO();
        for (int i = 0; i < this.dataBuffer.size(); ++i) {
            BufferObjectData bod = this.dataBuffer.get(i);
            bod.buffer.bind();
            GL32C.glEnableVertexAttribArray((int)bod.data.getAttribute());
            if (bod.data == Data.OVERLAY || bod.data == Data.LIGHT || bod.data == Data.LIGHT_SHADER) {
                GL32C.glVertexAttribIPointer((int)bod.data.getAttribute(), (int)bod.data.getSize(), (int)bod.data.getDataType(), (int)(bod.data.getSize() * bod.data.getDataTypeSize()), (long)0L);
                continue;
            }
            GL32C.glVertexAttribPointer((int)bod.data.getAttribute(), (int)bod.data.getSize(), (int)bod.data.getDataType(), (boolean)bod.data.normalize(), (int)(bod.data.getSize() * bod.data.getDataTypeSize()), (long)0L);
        }
    }

    public void finish() {
        this.bindAttributes();
    }

    public void updateAttribute(Data attribute, int[] data, long offset) {
        this.updateAttribute(attribute, data, data.length, offset);
    }

    public void updateAttribute(Data attribute, int[] data, int length, long offset) {
        try (MemoryStack stack = StarterClient.memoryStack.push();){
            IntBuffer fb = stack.mallocInt(length);
            fb.put(0, data, 0, length);
            this.updateAttribute(attribute, fb, offset);
        }
    }

    public void updateAttribute(Data attribute, float[] data) {
        try (MemoryStack stack = StarterClient.memoryStack.push();){
            FloatBuffer fb = stack.mallocFloat(data.length);
            fb.put(0, data, 0, data.length);
            this.updateAttribute(attribute, fb);
        }
    }

    public void updateAttribute(Data attribute, byte[] data) {
        try (MemoryStack stack = StarterClient.memoryStack.push();){
            ByteBuffer fb = stack.malloc(data.length);
            fb.put(0, data, 0, data.length);
            this.updateAttribute(attribute, fb);
        }
    }

    public void updateAttribute(Data attribute, short[] data, int length) {
        try (MemoryStack stack = StarterClient.memoryStack.push();){
            ShortBuffer fb = stack.mallocShort(length);
            fb.put(0, data, 0, length);
            this.updateAttribute(attribute, fb);
        }
    }

    public void updateAttribute(Data attribute, short[] data) {
        this.updateAttribute(attribute, data, data.length);
    }

    public void updateAttribute(Data attribute, int[] data) {
        try (MemoryStack stack = StarterClient.memoryStack.push();){
            IntBuffer fb = stack.mallocInt(data.length);
            fb.put(0, data, 0, data.length);
            this.updateAttribute(attribute, fb);
        }
    }

    public void updateAttribute(Data attribute, Buffer data) {
        if (data instanceof FloatBuffer) {
            this.updateAttribute(attribute, (FloatBuffer)data);
        } else if (data instanceof IntBuffer) {
            this.updateAttribute(attribute, (IntBuffer)data);
        } else if (data instanceof ByteBuffer) {
            this.updateAttribute(attribute, (ByteBuffer)data);
        } else if (data instanceof ShortBuffer) {
            this.updateAttribute(attribute, (ShortBuffer)data);
        }
    }

    public void updateAttribute(Data attr, FloatBuffer data) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferDataFast(data);
    }

    public void updateAttribute(Data attr, IntBuffer data) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferDataFast(data);
    }

    public void updateAttribute(Data attr, ByteBuffer data) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferDataFast(data);
    }

    public void updateAttribute(Data attr, ShortBuffer data) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferDataFast(data);
    }

    public void updateAttribute(Data attr, FloatBuffer data, long offset) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferSubData(data, offset);
    }

    public void updateAttribute(Data attr, IntBuffer data, long offset) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferSubData(data, offset);
    }

    public void updateAttribute(Data attr, ByteBuffer data, long offset) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferSubData(data, offset);
    }

    public void updateAttribute(Data attr, ShortBuffer data, long offset) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferSubData(data, offset);
    }

    public void updateAttributeSubData(Data attr, FloatBuffer data) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferSubData(data, 0L);
    }

    public void updateAttributeSubData(Data attr, IntBuffer data) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferSubData(data, 0L);
    }

    public void updateAttributeSubData(Data attr, ByteBuffer data) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferSubData(data, 0L);
    }

    public void updateAttributeSubData(Data attr, ShortBuffer data) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferSubData(data, 0L);
    }

    public void updateAttributeSubData(Data attr, FloatBuffer data, long offset) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferSubData(data, offset);
    }

    public void updateAttributeSubData(Data attr, IntBuffer data, long offset) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferSubData(data, offset);
    }

    public void updateAttributeSubData(Data attr, ByteBuffer data, long offset) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferSubData(data, offset);
    }

    public void updateAttributeSubData(Data attr, ShortBuffer data, long offset) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferSubData(data, offset);
    }

    public BufferObject dataBufferGet(Data data) {
        for (int i = 0; i < this.dataBuffer.size(); ++i) {
            BufferObjectData bod = this.dataBuffer.get(i);
            if (bod.data != data) continue;
            return bod.buffer;
        }
        return null;
    }

    public void dataBufferPut(Data data, BufferObject obj) {
        this.dataBuffer.add(new BufferObjectData(obj, data));
    }

    public void attachAttribute(Data attribute, Buffer data) {
        if (data instanceof FloatBuffer) {
            this.attachAttribute(attribute, (FloatBuffer)data);
        } else if (data instanceof IntBuffer) {
            this.attachAttribute(attribute, (IntBuffer)data);
        } else if (data instanceof ByteBuffer) {
            this.attachAttribute(attribute, (ByteBuffer)data);
        } else if (data instanceof ShortBuffer) {
            this.attachAttribute(attribute, (ShortBuffer)data);
        }
    }

    public void attachAttribute(Data attr, ByteBuffer data) {
        BufferObject vbo = new BufferObject(Type.DATA, this.usage);
        vbo.bind();
        vbo.bufferData(data);
        this.dataBufferPut(attr, vbo);
    }

    public void attachAttribute(Data attr, ShortBuffer data) {
        BufferObject vbo = new BufferObject(Type.DATA, this.usage);
        vbo.bind();
        vbo.bufferData(data);
        this.dataBufferPut(attr, vbo);
    }

    public void attachAttribute(Data attr, FloatBuffer data) {
        BufferObject vbo = new BufferObject(Type.DATA, this.usage);
        vbo.bind();
        vbo.bufferData(data);
        this.dataBufferPut(attr, vbo);
    }

    public void attachAttribute(Data attr, IntBuffer data) {
        BufferObject vbo = new BufferObject(Type.DATA, this.usage);
        vbo.bind();
        vbo.bufferData(data);
        this.dataBufferPut(attr, vbo);
    }

    public void attachInstancedAttribute(Data attr, Usage usage, long size) {
        BufferObject vbo = new BufferObject(Type.DATA, usage);
        vbo.bind();
        vbo.bufferData(size);
        this.dataBufferPut(attr, vbo);
    }

    public void updateInstancedAttribute(Data attr, FloatBuffer data) {
        this.dataBufferGet(attr).bind();
        this.dataBufferGet(attr).bufferDataFast(data);
    }

    public void attachAttribute(Data attr, float[] data, int length) {
        try (MemoryStack stack = StarterClient.memoryStack.push();){
            FloatBuffer fb = stack.mallocFloat(length);
            fb.put(0, data, 0, length);
            this.attachAttribute(attr, fb);
        }
    }

    public void attachAttribute(Data attr, float[] data) {
        this.attachAttribute(attr, data, data.length);
    }

    public void attachAttribute(Data attr, short[] data, int length) {
        try (MemoryStack stack = StarterClient.memoryStack.push();){
            ShortBuffer fb = stack.mallocShort(length);
            fb.put(0, data, 0, length);
            this.attachAttribute(attr, fb);
        }
    }

    public void attachAttribute(Data attr, short[] data) {
        this.attachAttribute(attr, data, data.length);
    }

    public void attachAttribute(Data attr, byte[] data, int length) {
        try (MemoryStack stack = StarterClient.memoryStack.push();){
            ByteBuffer fb = stack.malloc(length);
            fb.put(0, data, 0, length);
            this.attachAttribute(attr, fb);
        }
    }

    public void attachAttribute(Data attr, byte[] data) {
        this.attachAttribute(attr, data, data.length);
    }

    public void attachAttribute(Data attr, int[] data, int length) {
        try (MemoryStack stack = StarterClient.memoryStack.push();){
            IntBuffer fb = stack.mallocInt(length);
            fb.put(0, data, 0, length);
            this.attachAttribute(attr, fb);
        }
    }

    public void attachAttribute(Data attr, int[] data) {
        this.attachAttribute(attr, data, data.length);
    }

    public void attachIndices(Buffer indices) {
        if (indices instanceof IntBuffer) {
            this.attachIndices((IntBuffer)indices);
        } else if (indices instanceof ByteBuffer) {
            this.attachIndices((ByteBuffer)indices);
        } else if (indices instanceof ShortBuffer) {
            this.attachIndices((ShortBuffer)indices);
        }
    }

    public void attachIndices(ByteBuffer indices) {
        this.numberIndices = indices.capacity();
        this.indexBuffer = new BufferObject(Type.INDEX, this.usage);
        this.indexBuffer.bind();
        this.indexBuffer.bufferData(indices);
        this.indexBufferType = 5121;
    }

    public void attachIndices(IntBuffer indices) {
        this.numberIndices = indices.capacity();
        this.indexBuffer = new BufferObject(Type.INDEX, this.usage);
        this.indexBuffer.bind();
        this.indexBuffer.bufferData(indices);
        this.indexBufferType = 5125;
    }

    public void attachIndices(ShortBuffer indices) {
        this.numberIndices = indices.capacity();
        this.indexBuffer = new BufferObject(Type.INDEX, this.usage);
        this.indexBuffer.bind();
        this.indexBuffer.bufferData(indices);
        this.indexBufferType = 5123;
    }

    public void create(long size, Data ... values) {
        this.bindVAO();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == Data.INDEX) {
                this.indexBuffer = new BufferObject(Type.INDEX, this.usage);
                this.indexBuffer.bind();
                this.indexBuffer.createSize(size * 4L);
                this.indexBufferType = 5125;
                this.numberIndices = (int)size;
                continue;
            }
            BufferObject vbo = new BufferObject(Type.DATA, this.usage);
            vbo.bind();
            vbo.createSize(size * (long)values[i].getSize() * (long)values[i].getDataTypeSize());
            this.dataBufferPut(values[i], vbo);
        }
    }

    public void attachIndices(int[] data, int length) {
        try (MemoryStack stack = StarterClient.memoryStack.push();){
            IntBuffer fb = stack.mallocInt(length);
            fb.put(0, data, 0, length);
            this.attachIndices(fb);
        }
    }

    public void attachIndices(short[] data, int length) {
        try (MemoryStack stack = StarterClient.memoryStack.push();){
            ShortBuffer fb = stack.mallocShort(length);
            fb.put(0, data, 0, length);
            this.attachIndices(fb);
        }
    }

    public void attachIndices(int[] indices) {
        this.attachIndices(indices, indices.length);
    }

    public void updateIndices(Buffer indices) {
        if (indices instanceof IntBuffer) {
            this.updateIndices((IntBuffer)indices);
        } else if (indices instanceof ByteBuffer) {
            this.updateIndices((ByteBuffer)indices);
        } else if (indices instanceof ByteBuffer) {
            this.updateIndices((ShortBuffer)indices);
        }
    }

    public void updateIndices(int[] indices, long offset) {
        try (MemoryStack stack = StarterClient.memoryStack.push();){
            IntBuffer fb = stack.mallocInt(indices.length);
            fb.put(0, indices, 0, indices.length);
            this.indexBuffer.bind();
            this.indexBuffer.bufferSubData(fb, offset);
        }
    }

    public void updateIndices(int[] indices) {
        this.updateIndices(indices, indices.length);
    }

    public void updateIndices(IntBuffer indices) {
        this.indexBuffer.bind();
        this.numberIndices = indices.capacity();
        this.indexBuffer.bufferDataFast(indices);
    }

    public void updateIndices(ShortBuffer indices) {
        this.indexBuffer.bind();
        this.numberIndices = indices.capacity();
        this.indexBuffer.bufferDataFast(indices);
    }

    public void updateIndices(ByteBuffer indices) {
        this.indexBuffer.bind();
        this.numberIndices = indices.capacity() / 4;
        this.indexBuffer.bufferDataFast(indices);
    }

    public void updateIndicesSubData(IntBuffer indices) {
        this.indexBuffer.bind();
        this.numberIndices = indices.capacity();
        this.indexBuffer.bufferSubData(indices, 0L);
    }

    public void updateIndicesSubData(ShortBuffer indices) {
        this.indexBuffer.bind();
        this.numberIndices = indices.capacity();
        this.indexBuffer.bufferSubData(indices, 0L);
    }

    public void updateIndicesSubData(ByteBuffer indices) {
        this.indexBuffer.bind();
        this.numberIndices = indices.capacity() / 4;
        this.indexBuffer.bufferSubData(indices, 0L);
    }

    public void bindVAO() {
        GL32C.glBindVertexArray((int)this.id);
    }

    public static void unbindVAO() {
        GL32C.glBindVertexArray((int)0);
    }

    public BufferObject getBufferObject(Data data) {
        if (data == Data.INDEX) {
            return this.indexBuffer;
        }
        return this.dataBufferGet(data);
    }

    public void destroy() {
        GL32C.glDeleteVertexArrays((int)this.id);
        for (int i = 0; i < this.dataBuffer.size(); ++i) {
            BufferObjectData bod = this.dataBuffer.get(i);
            bod.buffer.destroy();
        }
        if (this.indexBuffer != null) {
            this.indexBuffer.destroy();
        }
    }

    public class BufferObjectData {
        BufferObject buffer;
        Data data;

        public BufferObjectData(BufferObject buffer, Data data) {
            this.buffer = buffer;
            this.data = data;
        }
    }

    public class Attribute {
        int id;
        int size;

        public Attribute(int id, int size) {
            this.id = id;
            this.size = size;
        }
    }
}

