/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.sound.ContactSimulationCallback;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.lwjgl.system.MemoryStack;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.extensions.PxRigidBodyExt;
import physx.geomutils.PxBoxGeometry;
import physx.physics.PxFilterData;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBody;
import physx.physics.PxRigidDynamic;
import physx.physics.PxShape;
import physx.physics.PxShapeFlagEnum;
import physx.physics.PxShapeFlags;

public class BoxRigidBody
extends IRigidBody {
    public float width;
    public float height;
    public float depth;

    private BoxRigidBody() {
    }

    public static BoxRigidBody create(PhysicsEntity entity, float width, float height, float depth, boolean dynamic) {
        BoxRigidBody boxRigidBody = new BoxRigidBody();
        Vector3d scale = entity.getTransformation().getScale(new Vector3d());
        Vector3d translation = entity.getTransformation().getTranslation(new Vector3d());
        boxRigidBody.entity = entity;
        Quaterniond rotation = new Quaterniond();
        entity.getTransformation().getNormalizedRotation(rotation);
        try (MemoryStack mem = MemoryStack.stackPush();){
            PxShapeFlags shapeFlags = PxShapeFlags.createAt(mem, MemoryStack::nmalloc, (byte)PxShapeFlagEnum.eSIMULATION_SHAPE);
            PxVec3 tmpVec = PxVec3.createAt(mem, MemoryStack::nmalloc, (float)translation.x, (float)translation.y, (float)translation.z);
            PxQuat tmpQuat = PxQuat.createAt(mem, MemoryStack::nmalloc, (float)rotation.x, (float)rotation.y, (float)rotation.z, (float)rotation.w);
            PxTransform tmpPose = PxTransform.createAt(mem, MemoryStack::nmalloc, tmpVec, tmpQuat);
            PxFilterData tmpFilterData = null;
            tmpFilterData = entity.noCollision ? PxFilterData.createAt(mem, MemoryStack::nmalloc, 0, 0, dynamic ? ContactSimulationCallback.REPORT_CONTACT_FLAGS : 0, 0) : (entity.stopCollision ? PxFilterData.createAt(mem, MemoryStack::nmalloc, 1, 0, dynamic ? ContactSimulationCallback.REPORT_CONTACT_FLAGS : 0, 0) : PxFilterData.createAt(mem, MemoryStack::nmalloc, 1, 1, dynamic ? ContactSimulationCallback.REPORT_CONTACT_FLAGS : 0, 0));
            PxBoxGeometry boxGeometry = PxBoxGeometry.createAt(mem, MemoryStack::nmalloc, width / 2.0f * (float)Math.abs(scale.x), height / 2.0f * (float)Math.abs(scale.y), depth / 2.0f * (float)Math.abs(scale.z));
            PxShape boxShape = StarterClient.physics.createShape(boxGeometry, StarterClient.defaultMaterial, true, shapeFlags);
            PxRigidActor box = null;
            if (dynamic) {
                box = StarterClient.physics.createRigidDynamic(tmpPose);
                boxRigidBody.setMass(((PxRigidBody)box).getMass());
            } else {
                box = StarterClient.physics.createRigidStatic(tmpPose);
            }
            boxRigidBody.shape = boxShape;
            boxRigidBody.rigidBody = box;
            boxShape.setSimulationFilterData(tmpFilterData);
            box.attachShape(boxShape);
            if (dynamic) {
                PxRigidBodyExt.updateMassAndInertia((PxRigidBody)box, 0.1f);
                boxRigidBody.setMass(((PxRigidBody)box).getMass());
                ((PxRigidDynamic)boxRigidBody.rigidBody).setContactReportThreshold(0.25f);
            }
        }
        boxRigidBody.width = width;
        boxRigidBody.height = height;
        boxRigidBody.depth = depth;
        return boxRigidBody;
    }
}

