/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.sound.ContactSimulationCallback;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;
import physx.PxTopLevelFunctions;
import physx.common.PxVec3;
import physx.physics.PxActor;
import physx.physics.PxArticulationBase;
import physx.physics.PxPairFilteringModeEnum;
import physx.physics.PxScene;
import physx.physics.PxSceneDesc;
import physx.physics.PxSolverTypeEnum;

public class DynamicsWorld {
    public static final Vector3f DEFAULT_GRAVITY = new Vector3f(0.0f, -9.81f, 0.0f);
    public static final Vector3f DEFAULT_BUOYANCY = new Vector3f(0.0f, 2.0f, 0.0f);
    private PxSceneDesc sceneDesc;
    private PxScene scene;
    private float fixedTimeStep;
    private boolean destroyed;
    private double time = 0.0;
    private boolean skipFirst;
    private Level level;
    private Vector3f buoyancy;
    private List<VerletSimulation> verletSimulations;
    private ContactSimulationCallback contactCallback;

    public DynamicsWorld(Level level, float fixedTimeStep) {
        this.level = level;
        this.destroyed = false;
        this.fixedTimeStep = fixedTimeStep;
        int numThreads = ConfigClient.cpuThreads;
        this.sceneDesc = new PxSceneDesc(StarterClient.tolerances);
        Vector3f gravity = ConfigClient.getGravity(level.m_46472_().m_135782_());
        this.buoyancy = ConfigClient.getBuoyancy(level.m_46472_().m_135782_());
        this.verletSimulations = new ObjectArrayList();
        try (MemoryStack mem = MemoryStack.stackPush();){
            this.sceneDesc.setGravity(PxVec3.createAt(mem, MemoryStack::nmalloc, gravity.x, gravity.y, gravity.z));
        }
        this.sceneDesc.setCpuDispatcher(PxTopLevelFunctions.DefaultCpuDispatcherCreate(numThreads));
        this.sceneDesc.setFilterShader(PxTopLevelFunctions.DefaultFilterShader());
        this.sceneDesc.setSolverType(PxSolverTypeEnum.ePGS);
        this.sceneDesc.setKineKineFilteringMode(PxPairFilteringModeEnum.eKILL);
        this.sceneDesc.setStaticKineFilteringMode(PxPairFilteringModeEnum.eKILL);
        this.scene = StarterClient.physics.createScene(this.sceneDesc);
        this.contactCallback = new ContactSimulationCallback(level);
        this.scene.setSimulationEventCallback(this.contactCallback);
    }

    public Vector3f getBuoyancy() {
        return this.buoyancy;
    }

    public boolean update(PhysicsWorld physics, double diff) {
        boolean updated = false;
        if (!this.destroyed) {
            this.time += diff;
            if (ConfigClient.gravityChanged) {
                ConfigClient.gravityChanged = false;
                Vector3f gravity = ConfigClient.getGravity(this.level.m_46472_().m_135782_());
                try (MemoryStack mem = MemoryStack.stackPush();){
                    this.scene.setGravity(PxVec3.createAt(mem, MemoryStack::nmalloc, gravity.x, gravity.y, gravity.z));
                }
                this.buoyancy = ConfigClient.getBuoyancy(this.level.m_46472_().m_135782_());
            }
            while (this.time >= (double)this.fixedTimeStep) {
                this.time -= (double)this.fixedTimeStep;
                if (!this.skipFirst) {
                    this.skipFirst = true;
                } else {
                    this.scene.fetchResults(true);
                }
                this.scene.simulate(this.fixedTimeStep);
                this.contactCallback.soundCount = 0;
                updated = true;
            }
        }
        return updated;
    }

    public boolean willUpdate(double diff) {
        return !this.destroyed && this.time + diff >= (double)this.fixedTimeStep;
    }

    public void destroy() {
        if (!this.destroyed) {
            this.scene.fetchResults(true);
            this.scene.release();
            if (this.contactCallback != null) {
                this.contactCallback.destroy();
            }
        }
        this.destroyed = true;
    }

    public void addActor(PxActor actor) {
        this.scene.addActor(actor);
    }

    public void removeActor(PxActor actor) {
        this.scene.removeActor(actor);
    }

    public void addArticulation(PxArticulationBase articulation) {
        this.scene.addArticulation(articulation);
    }

    public void removeArticulation(PxArticulationBase articulation) {
        this.scene.removeArticulation(articulation);
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public double getTime() {
        return this.time;
    }

    public float getFixedTimeStep() {
        return this.fixedTimeStep;
    }

    public void addVerletSimulation(int index, VerletSimulation simulation) {
        this.verletSimulations.add(index, simulation);
    }

    public void addVerletSimulation(VerletSimulation simulation) {
        this.verletSimulations.add(simulation);
    }

    public void removeVerletSimulation(VerletSimulation simulation) {
        this.verletSimulations.remove(simulation);
    }

    public List<VerletSimulation> getVerletSimulations() {
        return this.verletSimulations;
    }
}

