/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.opengl.Pack;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class Mesh {
    private static final Vector3f[] faceNormals = new Vector3f[]{new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f)};
    public List<Vector3d> positions;
    public List<Vector2f> uvs;
    public List<Vector3f> normals;
    public IntList colors;
    public ByteList sides;
    public IntList light;
    public List<Vector3i> indices;
    public List<Vector3i> indicesQuads;
    public Vector3d offset;
    public double radius = Double.MAX_VALUE;

    public Mesh() {
        this.positions = new ObjectArrayList();
        this.uvs = new ObjectArrayList();
        this.normals = new ObjectArrayList();
        this.indices = new ObjectArrayList();
        this.indicesQuads = new ObjectArrayList();
        this.colors = new IntArrayList();
        this.light = new IntArrayList();
        this.sides = new ByteArrayList();
    }

    public void calculateOffset() {
        this.calculateOffset(false);
    }

    public void addColor(float r, float g, float b) {
        this.colors.add(Pack.color(r, g, b));
    }

    public void addColor(float r, float g, float b, float a) {
        this.colors.add(Pack.color(r, g, b, a));
    }

    public double getRadius(boolean reculalcate) {
        if (this.radius == Double.MAX_VALUE) {
            for (int i = 0; i < this.positions.size(); ++i) {
                Vector3d position = this.positions.get(i);
                double radiusSquared = position.lengthSquared();
                if (!(radiusSquared > this.radius)) continue;
                this.radius = radiusSquared;
            }
            this.radius = Math.sqrt(this.radius);
        }
        return this.radius;
    }

    public double getRadius() {
        return this.getRadius(false);
    }

    public void calculateOffset(boolean needsSides) {
        this.offset = new Vector3d();
        for (Vector3d position : this.positions) {
            this.offset.add(position);
        }
        this.offset.div(this.positions.size());
        for (Vector3d position : this.positions) {
            position.sub(this.offset);
            double radiusSquared = position.lengthSquared();
            if (!(radiusSquared > this.radius)) continue;
            this.radius = radiusSquared;
        }
        this.radius = Math.sqrt(this.radius);
        if (needsSides) {
            for (int j = 0; j < this.normals.size(); ++j) {
                boolean hasSide = false;
                for (int i = 0; i < faceNormals.length; ++i) {
                    if (!((double)Math.abs(org.joml.Math.acos(this.normals.get(j).dot(Mesh.faceNormals[i].x, Mesh.faceNormals[i].y, Mesh.faceNormals[i].z))) < 0.01)) continue;
                    this.sides.add((byte)i);
                    hasSide = true;
                    break;
                }
                if (hasSide) continue;
                this.sides.add((byte)-1);
            }
        }
    }

    public List<Integer> calculedAngleSides() {
        ObjectArrayList sides = new ObjectArrayList();
        for (int j = 0; j < this.normals.size(); ++j) {
            int maxComp;
            Vector3f normal = this.normals.get(j);
            double max = normal.get(maxComp = normal.maxComponent());
            if (max >= 0.0) {
                if (maxComp == 0) {
                    sides.add(1);
                    continue;
                }
                if (maxComp == 1) {
                    sides.add(4);
                    continue;
                }
                sides.add(0);
                continue;
            }
            if (maxComp == 0) {
                sides.add(3);
                continue;
            }
            if (maxComp == 1) {
                sides.add(5);
                continue;
            }
            sides.add(2);
        }
        return sides;
    }

    public boolean isEmpty() {
        return this.indices.size() == 0;
    }
}

