/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.math.LinearCurve;
import net.diebuddies.math.Math;
import net.diebuddies.physics.Animation;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsWorld;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4d;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class PhysicsEntity {
    private Matrix4d transformation;
    private Matrix4d oldTransformation;
    public List<Model> models = new ObjectArrayList();
    public Type type;
    public double time;
    public Vector3d min = new Vector3d(0.0);
    public Vector3d max = new Vector3d(1.0);
    public Vector3d pivot = new Vector3d();
    public double scale = 1.0;
    public int color = -1;
    public Vector3d scalePhysics = new Vector3d(1.0);
    public Vector3f enlargeHitbox = new Vector3f(1.0f);
    public boolean stopCollision;
    public boolean noCollision;
    public boolean noVolume;
    public boolean backfaceCulling = true;
    public boolean staticPhysics = false;
    public boolean shade = true;
    public BlockState state;
    public SoundType sound;
    public long lastSoundTime = 0L;
    public RenderLayer feature = null;
    private int cachedBrightness;
    private BlockPos cachedBrightnessPos;
    public List<PhysicsEntity> children = new ObjectArrayList();
    private static Animation animation = new Animation(new LinearCurve(), 0.5, null, 0, 0.0);

    public PhysicsEntity(Type type, BlockState state) {
        this.state = state;
        if (state != null) {
            this.sound = state.m_60734_().m_49962_(state);
        }
        this.transformation = new Matrix4d();
        this.oldTransformation = new Matrix4d();
        this.models.add(new Model());
        this.type = type;
    }

    public Matrix4d getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Matrix4d transformation) {
        this.transformation = transformation;
    }

    public void setOldTransformation(Matrix4d oldTransformation) {
        this.oldTransformation = oldTransformation;
    }

    public Matrix4d getOldTransformation() {
        return this.oldTransformation;
    }

    public double getBoundingSphereRadius() {
        double maxRadius = 0.0;
        for (int i = 0; i < this.models.size(); ++i) {
            maxRadius = java.lang.Math.max(maxRadius, this.models.get((int)i).mesh.getRadius());
        }
        return maxRadius * java.lang.Math.max(this.scalePhysics.x, java.lang.Math.max(this.scalePhysics.y, this.scalePhysics.z)) * this.scale;
    }

    public void destroy() {
        this.destroyModels();
    }

    public void destroyModels() {
        if (this.models != null) {
            for (int i = 0; i < this.models.size(); ++i) {
                Model model = this.models.get(i);
                if (model.vao == null) continue;
                model.vao.destroy();
            }
        }
    }

    public int getLight(Level level, BlockPos.MutableBlockPos blockPos) {
        if (this.cachedBrightnessPos == null) {
            this.cachedBrightnessPos = blockPos.m_7949_();
        } else if (this.cachedBrightnessPos.equals((Object)blockPos)) {
            return this.cachedBrightness;
        }
        BlockState bState = level.m_8055_((BlockPos)blockPos);
        int x = blockPos.m_123341_();
        int y = blockPos.m_123342_();
        int z = blockPos.m_123343_();
        int brightness = 0;
        if (!bState.m_60815_()) {
            brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
        } else {
            bState = level.m_8055_((BlockPos)blockPos.m_122178_(x, y + 1, z));
            if (!bState.m_60815_()) {
                brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
            } else {
                bState = level.m_8055_((BlockPos)blockPos.m_122178_(x, y - 1, z));
                if (!bState.m_60815_()) {
                    brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
                } else {
                    bState = level.m_8055_((BlockPos)blockPos.m_122178_(x, y, z - 1));
                    if (!bState.m_60815_()) {
                        brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
                    } else {
                        bState = level.m_8055_((BlockPos)blockPos.m_122178_(x + 1, y, z));
                        if (!bState.m_60815_()) {
                            brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
                        } else {
                            bState = level.m_8055_((BlockPos)blockPos.m_122178_(x, y, z + 1));
                            if (!bState.m_60815_()) {
                                brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
                            } else {
                                bState = level.m_8055_((BlockPos)blockPos.m_122178_(x - 1, y, z));
                                if (!bState.m_60815_()) {
                                    brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
                                }
                            }
                        }
                    }
                }
            }
        }
        blockPos.m_122178_(x, y, z);
        this.cachedBrightness = brightness;
        return brightness;
    }

    public void invalidateBrightness() {
        this.cachedBrightnessPos = null;
    }

    public double getDespawnSpeed() {
        return PhysicsEntity.animation.speed;
    }

    public void spawnDeathAnimation(PhysicsWorld world) {
    }

    public void startDespawnAnimation(Level world) {
        if (this.time > PhysicsEntity.animation.speed) {
            this.time = PhysicsEntity.animation.speed;
        }
    }

    public float getDespawnScale(Level level) {
        return PhysicsEntity.animation.curve.get(Math.clamp((float)(this.time / PhysicsEntity.animation.speed), 0.0f, 1.0f));
    }

    public static enum Type {
        MOB,
        BLOCK,
        VINE,
        ITEM,
        PARTICLE,
        LIQUID,
        OTHER;

    }
}

