/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.diebuddies.bridge.ModLoaderFunctions;
import net.diebuddies.compat.Replay;
import net.diebuddies.config.ConfigMobs;
import net.diebuddies.math.Math;
import net.diebuddies.opengl.Texture;
import net.diebuddies.opengl.TextureHelper;
import net.diebuddies.physics.BlockEntityVertexConsumerProvider;
import net.diebuddies.physics.BlockUpdate;
import net.diebuddies.physics.Cape;
import net.diebuddies.physics.DummyMultiBufferSource;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.ItemVertexConsumerProvider;
import net.diebuddies.physics.JsonUnbakedModelHolder;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.ragdoll.RagdollMapper;
import net.diebuddies.physics.verlet.VerletHelper;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.vines.VineLoader;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4d;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.lwjgl.system.MemoryStack;
import physx.common.PxVec3;
import physx.physics.PxRigidBody;
import physx.physics.PxRigidBodyFlagEnum;
import physx.physics.PxRigidDynamic;

public class PhysicsMod {
    public static final Path CAPES_DIRECTORY = ModLoaderFunctions.getGameDir().resolve("capes");
    public static final ResourceLocation SNOWBALL_TEXTURE = new ResourceLocation("physicsmod:textures/items/snowball.png");
    public static final ResourceLocation ENDERPEARL_TEXTURE = new ResourceLocation("physicsmod:textures/items/enderpearl.png");
    public static final ResourceLocation EGG_TEXTURE = new ResourceLocation("physicsmod:textures/items/egg.png");
    public static Object2ObjectMap<Level, PhysicsMod> instances = new Object2ObjectOpenHashMap();
    private static PhysicsMod currentInstance;
    public static final Map<EntityType<?>, EntityRenderer<?>> renderers;
    public static final Map<Block, String> registeredBlocks;
    public static final Map<String, Block> invRegisteredBlocks;
    public static final Map<ModelPart.Cube, Boolean> mirroredCuboids;
    public static boolean hudRendering;
    public static boolean sodiumCatch;
    public static Map<BakedModel, JsonUnbakedModelHolder> loadedModels;
    public static volatile AtlasSet atlasSet;
    public static Matrix4f projectionMatrix;
    public static Matrix4f viewMatrix;
    public static List<VerletSimulation> optifineClothCompat;
    public PhysicsWorld physicsWorld;
    public boolean init = false;
    public ConcurrentLinkedQueue<PhysicsEntity> entityBlocks = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<PhysicsEntity> additionalPhysics = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<BlockPos> blockUpdates = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<Explosion> explosions = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<Ragdoll> ragdolls = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<Ragdoll> sodiumRemoveRagdolls = new ConcurrentLinkedQueue();
    public List<BlockUpdate> updateQueue = new ObjectArrayList();
    public List<PhysicsEntity> blockifiedEntity = new ObjectArrayList();
    public List<ModelPart> cuboidEntity = new ObjectArrayList();
    public PhysicsEntity itemStackEntity;
    public Set<BlockUpdate> removeUpdates = new ObjectOpenHashSet();
    public Set<Integer> alreadyBlockified = new ObjectOpenHashSet();
    public LongSet invalidLightChunks = new LongOpenHashSet();
    public PoseStack localPivotMatrix = new PoseStack();
    public EntityRenderer cubifyEntityRenderer;
    public Entity cubifyEntity;
    public Map<Player, Float> players = new Object2ObjectOpenHashMap();
    public long time;
    public boolean blockify;
    public boolean ragdollBlockify;
    public AbstractTexture blockifyTexture;
    public Entity blockifyEntity;
    public int blockifyFeatureIndex;
    public RenderLayer blockifyFeature;
    public Map<Long, Integer> builtChunks = new ConcurrentHashMap<Long, Integer>();
    public static final List<List<Mesh>> brokenBlocksLittle;
    public static final List<List<Mesh>> brokenBlocksLots;
    public static final List<Mesh> brokenBlock;
    public static final List<Mesh> snowballMesh;
    public static final List<List<Mesh>> snowballMeshFractured;
    public static final List<Mesh> enderpearlMesh;
    public static final List<List<Mesh>> enderpearlMeshFractured;
    public static final List<Mesh> eggMesh;
    public static final List<List<Mesh>> eggMeshFractured;
    public static Cape defaultCape;
    public static Texture whiteTexture;
    public static Map<String, Cape> capes;
    private static final Direction[] DIRECTIONS;

    private static List<Mesh> readBlock(String asset) {
        ObjectArrayList meshes = new ObjectArrayList();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(PhysicsMod.class.getClassLoader().getResourceAsStream(asset)));){
            String line = "";
            Mesh mesh = null;
            int ov = 0;
            int ot = 0;
            int on = 0;
            while ((line = reader.readLine()) != null) {
                String[] data;
                if (line.startsWith("o")) {
                    if (mesh != null) {
                        mesh.calculateOffset(true);
                        meshes.add(mesh);
                        ov += mesh.positions.size();
                        ot += mesh.uvs.size();
                        on += mesh.normals.size();
                    }
                    mesh = new Mesh();
                    continue;
                }
                if (line.startsWith("vt")) {
                    data = line.split(" ");
                    mesh.uvs.add(new Vector2f(Float.parseFloat(data[1]), Float.parseFloat(data[2])));
                    continue;
                }
                if (line.startsWith("vn")) {
                    data = line.split(" ");
                    mesh.normals.add(new org.joml.Vector3f(Float.parseFloat(data[1]), Float.parseFloat(data[2]), Float.parseFloat(data[3])));
                    continue;
                }
                if (line.startsWith("v")) {
                    data = line.split(" ");
                    mesh.positions.add(new Vector3d(Double.parseDouble(data[1]), Double.parseDouble(data[2]), Double.parseDouble(data[3])));
                    continue;
                }
                if (!line.startsWith("f")) continue;
                data = line.split(" ");
                boolean quads = data.length == 5;
                for (int i = 1; i < data.length; ++i) {
                    String[] idata = data[i].split("/");
                    if (quads) {
                        mesh.indicesQuads.add(new Vector3i(Integer.parseInt(idata[0]) - ov, Integer.parseInt(idata[1]) - ot, Integer.parseInt(idata[2]) - on));
                        continue;
                    }
                    mesh.indices.add(new Vector3i(Integer.parseInt(idata[0]) - ov, Integer.parseInt(idata[1]) - ot, Integer.parseInt(idata[2]) - on));
                }
                if (!quads) continue;
                int index = mesh.indicesQuads.size() - 4;
                mesh.indices.add(mesh.indicesQuads.get(index));
                mesh.indices.add(mesh.indicesQuads.get(index + 1));
                mesh.indices.add(mesh.indicesQuads.get(index + 2));
                mesh.indices.add(mesh.indicesQuads.get(index));
                mesh.indices.add(mesh.indicesQuads.get(index + 2));
                mesh.indices.add(mesh.indicesQuads.get(index + 3));
            }
            if (mesh != null) {
                mesh.calculateOffset(true);
                meshes.add(mesh);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return meshes;
    }

    public static void createCapeDirectory() {
        try {
            Files.createDirectories(CAPES_DIRECTORY, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            PhysicsMod.copyResource("assets/capes/Example Cape.blend", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Physics Mod Cape.dae", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Physics Mod Cape.png", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Physics Mod Cape Ripped.dae", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Physics Mod Cape Ripped.png", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Curtain.dae", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Curtain.png", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Bat Cape.dae", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Bat Cape.png", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Flag Cape.dae", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Flag Cape.png", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Kings Cape.dae", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Kings Cape.png", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Stripes Cape.dae", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/Stripes Cape.png", CAPES_DIRECTORY);
            PhysicsMod.copyResource("assets/capes/TUTORIAL.txt", CAPES_DIRECTORY);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadCapes() {
    }

    public static void copyResource(String res, Path dest) throws IOException {
        String[] split = res.split("/");
        InputStream src = PhysicsMod.class.getClassLoader().getResourceAsStream(res);
        Files.copy(src, dest.resolve(split[split.length - 1]), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void resetClothSimulations() {
        for (PhysicsMod mod : instances.values()) {
            for (VerletSimulation simulation : mod.getPhysicsWorld().getVerletSimulations()) {
                simulation.destroyed = true;
            }
        }
    }

    public static double getPlaybackSpeed() {
        if (Minecraft.m_91087_().m_91104_()) {
            return 0.0;
        }
        return 1.0 * Replay.getPlaybackSpeed();
    }

    public static PhysicsMod getInstance(Level level) {
        PhysicsMod mod = (PhysicsMod)instances.get((Object)level);
        if (mod == null) {
            mod = new PhysicsMod(level);
            instances.put((Object)level, (Object)mod);
        }
        return mod;
    }

    public static PhysicsMod getCurrentInstance() {
        return currentInstance;
    }

    public static void setCurrentInstance(PhysicsMod currentInstance) {
        PhysicsMod.currentInstance = currentInstance;
    }

    public static Object2ObjectMap<Level, PhysicsMod> getInstances() {
        return instances;
    }

    public PhysicsMod(Level level) {
        this.physicsWorld = new PhysicsWorld(level);
        if (level instanceof ClientLevel) {
            ((VineLoader)((ClientLevel)level).m_7726_()).setPhysicsMod(this);
        }
    }

    public PhysicsWorld getPhysicsWorld() {
        return this.physicsWorld;
    }

    public static void addSnowball(Level level, Snowball snowball) {
    }

    public static void addEnderpearl(Level level, ThrownEnderpearl enderpearl) {
    }

    public static void addEgg(Level level, ThrownEgg egg) {
    }

    public static void addThrowableProjectile(Level level, ThrowableItemProjectile projectile, Mesh mesh, int textureID, boolean shade, List<Mesh> fractures) {
        VoxelShape voxelShape;
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.ITEM, null);
        VerletHelper helper = new VerletHelper();
        BlockState state = level.m_8055_(projectile.m_142538_());
        Vector3d snowballPos = new Vector3d(projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_());
        float snowballRadius = 0.14f;
        if (state.m_60734_() != Blocks.f_50016_ && !(voxelShape = state.m_60812_((BlockGetter)level, projectile.m_142538_())).m_83281_()) {
            for (AABB aabb : voxelShape.m_83299_()) {
                helper.movePointOutOfBox(snowballPos, 0.7, snowballRadius, aabb.f_82288_, aabb.f_82289_, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
            }
        }
        entity.getTransformation().translation(snowballPos);
        Random random = new Random(projectile.m_142049_());
        float progress = projectile.f_19797_;
        entity.getTransformation().rotateX(random.nextDouble() * java.lang.Math.PI);
        entity.getTransformation().rotateY(random.nextDouble() * java.lang.Math.PI);
        entity.getTransformation().rotateZ(random.nextDouble() * java.lang.Math.PI + (double)progress * 0.5);
        entity.getOldTransformation().set(entity.getTransformation());
        entity.models.get((int)0).textureIDs = new int[]{textureID};
        entity.backfaceCulling = true;
        entity.shade = shade;
        entity.models.get((int)0).mesh = mesh;
        ObjectArrayList bodies = new ObjectArrayList();
        if (fractures != null) {
            mod.physicsWorld.addBlockParticle(fractures, entity, (List<IRigidBody>)bodies);
        } else {
            IRigidBody body = mod.physicsWorld.addPhysicsSphere(entity, snowballRadius);
            ((PxRigidDynamic)body.getRigidBody()).setMaxAngularVelocity((float)java.lang.Math.toRadians(360.0));
            ((PxRigidDynamic)body.getRigidBody()).setRigidBodyFlag(PxRigidBodyFlagEnum.eENABLE_SPECULATIVE_CCD, true);
            ((PxRigidDynamic)body.getRigidBody()).setLinearDamping(0.9f);
            ((PxRigidDynamic)body.getRigidBody()).setAngularDamping(0.9f);
            bodies.add(body);
        }
        double speedX = projectile.m_20185_() - projectile.f_19790_;
        double speedY = projectile.m_20186_() - projectile.f_19791_;
        double speedZ = projectile.m_20189_() - projectile.f_19792_;
        float speedMultiplier = 10.0f;
        for (IRigidBody body : bodies) {
            MemoryStack mem = MemoryStack.stackPush();
            try {
                ((PxRigidBody)body.getRigidBody()).setLinearVelocity(PxVec3.createAt(mem, MemoryStack::nmalloc, (float)speedX * speedMultiplier, (float)speedY * speedMultiplier, (float)speedZ * speedMultiplier));
            }
            finally {
                if (mem == null) continue;
                mem.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void blockifyEntity(Level level, LivingEntity entity) {
        EntityRenderer entityRenderer;
        PhysicsMod mod = PhysicsMod.getInstance(level);
        if (ConfigMobs.getMobSetting((Entity)entity) == 0) {
            return;
        }
        if (mod.alreadyBlockified.contains(entity.m_142049_()) && !(entity instanceof Player)) {
            return;
        }
        if (entity instanceof LivingEntity && entity.m_20145_()) {
            return;
        }
        mod.alreadyBlockified.add(entity.m_142049_());
        EntityRenderer renderer = entityRenderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
        EntityModel model = null;
        if (entityRenderer instanceof LivingEntityRenderer) {
            model = ((LivingEntityRenderer)entityRenderer).m_7200_();
        }
        PoseStack stack = new PoseStack();
        stack.m_85836_();
        mod.blockify = true;
        mod.localPivotMatrix = new PoseStack();
        mod.cubifyEntityRenderer = renderer;
        mod.cubifyEntity = entity;
        PhysicsMod.setCurrentInstance(mod);
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        mod.blockifyTexture = textureManager.m_118506_(renderer.m_5478_((Entity)entity));
        mod.blockifyEntity = entity;
        mod.blockifyFeature = null;
        mod.blockifyFeatureIndex = 0;
        float partialTicks = Minecraft.m_91087_().m_91296_();
        double px = Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_());
        double py = Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_());
        double pz = Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_());
        DummyMultiBufferSource source = new DummyMultiBufferSource();
        try {
            renderer.m_7392_((Entity)entity, 0.0f, Minecraft.m_91087_().m_91296_(), stack, (MultiBufferSource)source, 0);
        }
        catch (Exception e) {
            System.err.println("error rendering " + entity.getClass());
            e.printStackTrace();
        }
        finally {
            if (source.lastLayer != null) {
                source.lastLayer.m_110188_();
            }
        }
        PhysicsMod.setCurrentInstance(null);
        mod.blockify = false;
        try {
            RagdollMapper.filterCuboidsFromEntities((Entity)entity, model);
        }
        catch (Exception e) {
            System.err.println("error filtering " + entity.getClass());
            e.printStackTrace();
        }
        stack.m_85849_();
        for (PhysicsEntity physicsEntity : mod.blockifiedEntity) {
            physicsEntity.backfaceCulling = false;
        }
        if (ConfigMobs.getMobSetting((Entity)entity) == 4) {
            Ragdoll ragdoll = null;
            try {
                ragdoll = RagdollMapper.map((Entity)entity, model);
            }
            catch (Exception e) {
                System.err.println("error creating ragdoll for " + entity.getClass());
                e.printStackTrace();
            }
            if (ragdoll == null) {
                mod.entityBlocks.addAll(mod.blockifiedEntity);
                if (mod.entityBlocks.size() > 0 && entity instanceof LivingEntity) {
                    entity.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            } else {
                Player closest;
                mod.ragdolls.add(ragdoll);
                if (level instanceof ClientLevel && (closest = ((ClientLevel)level).m_45924_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 8.0, false)) != null) {
                    ragdoll.velocity.set(entity.m_20185_() - closest.m_20185_(), 2.0, entity.m_20189_() - closest.m_20189_()).normalize().mul(5.0);
                }
                ragdoll.velocity.add(entity.m_20184_().f_82479_ * 10.0, entity.m_20184_().f_82480_ * 10.0, entity.m_20184_().f_82481_ * 10.0);
                if (entity instanceof LivingEntity) {
                    entity.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
        } else {
            mod.entityBlocks.addAll(mod.blockifiedEntity);
            if (mod.entityBlocks.size() > 0 && entity instanceof LivingEntity) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        mod.blockifiedEntity.clear();
        mod.cuboidEntity.clear();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
    }

    public static void createParticlesFromCuboids(PoseStack.Pose stack, PoseStack local, List<ModelPart.Cube> cuboids, Entity entity, EntityRenderer renderer, RenderLayer feature, int overlay, float red, float green, float blue) {
        Matrix4f m = stack.m_85861_();
        Matrix4f localM = local.m_85850_().m_85861_();
        Matrix3f localNM = local.m_85850_().m_85864_();
        Matrix4d transformation = new Matrix4d();
        Matrix4d transformationLocal = new Matrix4d();
        StarterClient.setMatrix(transformation, m);
        StarterClient.setMatrix(transformationLocal, localM);
        transformation.mul(transformationLocal.invert(new Matrix4d()));
        PhysicsMod mod = PhysicsMod.getInstance(entity.m_20193_());
        int[] textureIDs = TextureHelper.getLoadedTextures();
        float partialTicks = Minecraft.m_91087_().m_91296_();
        double px = Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_());
        double py = Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_());
        double pz = Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_());
        transformation.setTranslation(px + transformation.m30(), py + transformation.m31(), pz + transformation.m32());
        org.joml.Vector4f[] minMax = new org.joml.Vector4f[6];
        Vector3f tmpNormal = new Vector3f();
        Vector4f tmpPos = new Vector4f();
        for (int i = 0; i < minMax.length; ++i) {
            minMax[i] = new org.joml.Vector4f();
        }
        for (ModelPart.Cube box : cuboids) {
            if (box.f_104341_[2] == null || box.f_104341_[3] == null) continue;
            float minX = box.f_104341_[2].f_104359_[2].f_104371_.m_122239_();
            float minY = box.f_104341_[2].f_104359_[2].f_104371_.m_122260_();
            float minZ = box.f_104341_[2].f_104359_[2].f_104371_.m_122269_();
            float maxX = box.f_104341_[3].f_104359_[3].f_104371_.m_122239_();
            float maxY = box.f_104341_[3].f_104359_[3].f_104371_.m_122260_();
            float maxZ = box.f_104341_[3].f_104359_[3].f_104371_.m_122269_();
            int[] remap = new int[]{5, 0, 4, 1, 3, 2};
            float volume = java.lang.Math.abs(maxX - minX) / 16.0f * (java.lang.Math.abs(maxY - minY) / 16.0f) * (java.lang.Math.abs(maxZ - minZ) / 16.0f);
            boolean isBlocky = ConfigMobs.getMobSetting(entity) == 3 || ConfigMobs.getMobSetting(entity) == 4;
            boolean noVolume = false;
            if ((double)volume <= 1.0E-4) {
                if (!isBlocky) continue;
                noVolume = true;
            }
            boolean mirror = false;
            Boolean cuboidMirror = mirroredCuboids.get(box);
            if (cuboidMirror != null) {
                mirror = cuboidMirror;
            }
            List<Mesh> meshes = brokenBlocksLittle.get((int)(java.lang.Math.random() * (double)brokenBlocksLittle.size()));
            if ((double)volume <= 0.04 || isBlocky) {
                meshes = brokenBlock;
            }
            for (int i = 0; i < box.f_104341_.length; ++i) {
                float minU = 1.0f;
                float maxU = 0.0f;
                float minV = 1.0f;
                float maxV = 0.0f;
                for (ModelPart.Vertex vertex : box.f_104341_[i].f_104359_) {
                    if (vertex.f_104372_ < minU) {
                        minU = vertex.f_104372_;
                    }
                    if (vertex.f_104373_ < minV) {
                        minV = vertex.f_104373_;
                    }
                    if (vertex.f_104372_ > maxU) {
                        maxU = vertex.f_104372_;
                    }
                    if (!(vertex.f_104373_ > maxV)) continue;
                    maxV = vertex.f_104373_;
                }
                minMax[i].set(minU, maxU, minV, maxV);
            }
            PhysicsEntity parent = null;
            for (Mesh mesh : meshes) {
                Mesh clone;
                PhysicsEntity particle = new PhysicsEntity(PhysicsEntity.Type.MOB, null);
                particle.feature = feature;
                particle.noVolume = noVolume;
                particle.models.get((int)0).textureIDs = textureIDs;
                particle.models.get((int)0).overlay = overlay;
                particle.models.get((int)0).mesh = clone = new Mesh();
                particle.setTransformation(new Matrix4d(transformation));
                particle.setOldTransformation(new Matrix4d(particle.getTransformation()));
                int count = 1;
                Vector3d offset = new Vector3d();
                for (Vector3i index : mesh.indices) {
                    byte sideIndex = mesh.sides.get(index.z - 1);
                    Vector3d position = mesh.positions.get(index.x - 1);
                    Vector2f uv = mesh.uvs.get(index.y - 1);
                    org.joml.Vector3f normal = mesh.normals.get(index.z - 1);
                    if (sideIndex == -1) {
                        if (ConfigMobs.getMobSetting(entity) == 2) {
                            red = 0.6f;
                            green = 0.0f;
                            blue = 0.0f;
                        }
                        sideIndex = 0;
                    }
                    tmpNormal.m_122245_(mirror ? -normal.x : normal.x, normal.y, normal.z);
                    tmpNormal.m_122249_(localNM);
                    org.joml.Vector4f minMaxUVs = minMax[remap[sideIndex]];
                    tmpPos.m_123602_((float)Math.remap(position.x + mesh.offset.x, -0.5, 0.5, (double)minX, (double)maxX) / 16.0f, (float)Math.remap(position.y + mesh.offset.y, -0.5, 0.5, (double)minY, (double)maxY) / 16.0f, (float)Math.remap(position.z + mesh.offset.z, mirror ? 0.5 : -0.5, mirror ? -0.5 : 0.5, (double)minZ, (double)maxZ) / 16.0f, 1.0f);
                    tmpPos.m_123607_(localM);
                    clone.indices.add(new Vector3i(count, count, count));
                    offset.add(tmpPos.m_123601_(), tmpPos.m_123615_(), tmpPos.m_123616_());
                    ++count;
                    Vector3d posR = new Vector3d(tmpPos.m_123601_(), tmpPos.m_123615_(), tmpPos.m_123616_());
                    clone.positions.add(posR);
                    clone.uvs.add(new Vector2f(Math.remap(uv.x, 1.0f, 0.0f, minMaxUVs.x, minMaxUVs.y), Math.remap(uv.y, 0.0f, 1.0f, minMaxUVs.z, minMaxUVs.w)));
                    clone.normals.add(new org.joml.Vector3f(tmpNormal.m_122239_(), tmpNormal.m_122260_(), tmpNormal.m_122269_()));
                    clone.addColor(red, green, blue);
                }
                offset.div(clone.positions.size());
                for (Vector3d position : clone.positions) {
                    position.sub(offset);
                }
                clone.offset = offset;
                Vector3d ps = transformationLocal.getTranslation(new Vector3d());
                particle.pivot.set(ps);
                if (parent == null) {
                    parent = particle;
                    mod.blockifiedEntity.add(particle);
                    continue;
                }
                parent.children.add(particle);
            }
        }
    }

    public static void blockifyItemStack(ItemStack item, boolean mainHand) {
    }

    private static void renderHand(ItemStack item, Camera camera, float tickDelta, boolean mainHand) {
        Minecraft.m_91087_().f_91063_.m_109111_(Minecraft.m_91087_().f_91063_.m_172716_(Minecraft.m_91087_().f_91063_.m_109141_(camera, tickDelta, false)));
        PoseStack matrices = new PoseStack();
        matrices.m_85836_();
        matrices.m_85837_(0.0, 0.0, -0.2);
        matrices.m_85845_(Vector3f.f_122223_.m_122240_(camera.m_90589_()));
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(camera.m_90590_() + 180.0f));
        Matrix4d m = new Matrix4d();
        StarterClient.setMatrix(m, matrices.m_85850_().m_85861_());
        m.invert();
        Matrix4f view = new Matrix4f();
        StarterClient.setMojangMatrix(view, m);
        matrices.m_85849_();
        matrices.m_85836_();
        matrices.m_166854_(view);
        PhysicsMod.bobViewWhenHurt(matrices, tickDelta);
        if (Minecraft.m_91087_().f_91066_.f_92080_) {
            PhysicsMod.bobView(matrices, tickDelta);
        }
        PhysicsMod.renderItem(item, camera, mainHand, Minecraft.m_91087_().f_91063_.f_109055_, tickDelta, matrices, Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().m_91290_().m_114394_((Entity)Minecraft.m_91087_().f_91074_, tickDelta));
        matrices.m_85849_();
    }

    private static void renderItem(ItemStack item, Camera camera, boolean mainHand, ItemInHandRenderer firstPersonRenderer, float tickDelta, PoseStack matrices, LocalPlayer player, int light) {
        float f = player.m_21324_(tickDelta);
        InteractionHand hand = (InteractionHand)MoreObjects.firstNonNull((Object)player.f_20912_, (Object)InteractionHand.MAIN_HAND);
        float g = Mth.m_14179_((float)tickDelta, (float)player.f_19860_, (float)player.m_146909_());
        float h = Mth.m_14179_((float)tickDelta, (float)player.f_108588_, (float)player.f_108586_);
        float i = Mth.m_14179_((float)tickDelta, (float)player.f_108587_, (float)player.f_108585_);
        matrices.m_85845_(Vector3f.f_122223_.m_122240_((player.m_5686_(tickDelta) - h) * 0.1f));
        matrices.m_85845_(Vector3f.f_122225_.m_122240_((player.m_5675_(tickDelta) - i) * 0.1f));
        System.out.println("pitch: " + (player.m_5686_(tickDelta) - h) * 0.1f);
        System.out.println("yaw: " + (player.m_5675_(tickDelta) - i) * 0.1f);
        System.out.println("cam pitch: " + camera.m_90589_());
        System.out.println("cam yaw: " + (camera.m_90590_() + 180.0f));
        ItemVertexConsumerProvider dummy = new ItemVertexConsumerProvider();
        float l = hand == InteractionHand.MAIN_HAND ? f : 0.0f;
        float m = 1.0f - Mth.m_14179_((float)tickDelta, (float)firstPersonRenderer.f_109303_, (float)firstPersonRenderer.f_109302_);
        firstPersonRenderer.m_109371_((AbstractClientPlayer)player, tickDelta, g, mainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, l, item, m, matrices, (MultiBufferSource)dummy, light);
    }

    private static void bobView(PoseStack matrices, float f) {
        if (Minecraft.m_91087_().m_91288_() instanceof Player) {
            Player playerEntity = (Player)Minecraft.m_91087_().m_91288_();
            float g = playerEntity.f_19787_ - playerEntity.f_19867_;
            float h = -(playerEntity.f_19787_ + g * f);
            float i = Mth.m_14179_((float)f, (float)playerEntity.f_36099_, (float)playerEntity.f_36100_);
            matrices.m_85837_((double)(Mth.m_14031_((float)(h * (float)java.lang.Math.PI)) * i * 0.5f), (double)(-java.lang.Math.abs(Mth.m_14089_((float)(h * (float)java.lang.Math.PI)) * i)), 0.0);
            matrices.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14031_((float)(h * (float)java.lang.Math.PI)) * i * 3.0f));
            matrices.m_85845_(Vector3f.f_122223_.m_122240_(java.lang.Math.abs(Mth.m_14089_((float)(h * (float)java.lang.Math.PI - 0.2f)) * i) * 5.0f));
        }
    }

    private static void bobViewWhenHurt(PoseStack matrices, float f) {
        if (Minecraft.m_91087_().m_91288_() instanceof LivingEntity) {
            float i;
            LivingEntity livingEntity = (LivingEntity)Minecraft.m_91087_().m_91288_();
            float g = (float)livingEntity.f_20916_ - f;
            if (livingEntity.m_21224_()) {
                i = java.lang.Math.min((float)livingEntity.f_20919_ + f, 20.0f);
                matrices.m_85845_(Vector3f.f_122227_.m_122240_(40.0f - 8000.0f / (i + 200.0f)));
            }
            if (g < 0.0f) {
                return;
            }
            g /= (float)livingEntity.f_20917_;
            g = Mth.m_14031_((float)(g * g * g * g * (float)java.lang.Math.PI));
            i = livingEntity.f_20918_;
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(-i));
            matrices.m_85845_(Vector3f.f_122227_.m_122240_(-g * 14.0f));
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(i));
        }
    }

    public PhysicsEntity renderBlockIntoEntity(PhysicsEntity.Type type, BakedModel model, BlockState state, BlockPos pos) {
        this.itemStackEntity = new PhysicsEntity(type, state);
        this.itemStackEntity.models.get((int)0).mesh = new Mesh();
        PhysicsMod.setCurrentInstance(this);
        Vec3 blockOffset = state.m_60824_((BlockGetter)this.physicsWorld.getWorld(), pos);
        try {
            this.renderFlat(this.itemStackEntity, (BlockAndTintGetter)this.physicsWorld.getWorld(), model, state, pos, new Random(0L), state.m_60726_(pos), OverlayTexture.f_118083_);
        }
        catch (Exception e) {
            PhysicsMod.setCurrentInstance(null);
            return null;
        }
        if (this.itemStackEntity.models.get((int)0).mesh.indices.size() < 9) {
            PhysicsMod.setCurrentInstance(null);
            return null;
        }
        this.itemStackEntity.models.get((int)0).mesh.calculateOffset();
        this.itemStackEntity.models.get((int)0).textureIDs = new int[]{model.m_6160_().m_118414_().m_117963_()};
        this.itemStackEntity.getTransformation().set(new Matrix4d().translate((double)pos.m_123341_() + blockOffset.f_82479_, (double)pos.m_123342_() + blockOffset.f_82480_, (double)pos.m_123343_() + blockOffset.f_82481_));
        this.itemStackEntity.getOldTransformation().set(this.itemStackEntity.getTransformation());
        this.itemStackEntity.models.get((int)0).animationSprite = model.m_6160_();
        return this.itemStackEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhysicsEntity renderBlockIntoEntity(PhysicsEntity.Type type, BlockEntityRenderer<BlockEntity> renderer, BlockEntity blockEntity, BlockState state, BlockPos pos) {
        this.itemStackEntity = new PhysicsEntity(type, state);
        this.itemStackEntity.models.get((int)0).mesh = new Mesh();
        PhysicsMod.setCurrentInstance(this);
        sodiumCatch = true;
        float tickDelta = 0.0f;
        BlockEntityVertexConsumerProvider source = new BlockEntityVertexConsumerProvider();
        try {
            renderer.m_6922_(blockEntity, tickDelta, new PoseStack(), (MultiBufferSource)source, OverlayTexture.f_118083_, 0);
        }
        catch (Exception e) {
            PhysicsMod.setCurrentInstance(null);
            PhysicsEntity physicsEntity = null;
            return physicsEntity;
        }
        finally {
            if (source.lastLayer != null) {
                source.lastLayer.m_110188_();
            }
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
        }
        sodiumCatch = false;
        Vec3 blockOffset = state.m_60824_((BlockGetter)this.physicsWorld.getWorld(), pos);
        if (this.itemStackEntity.models.get((int)0).mesh.indices.size() < 9) {
            PhysicsMod.setCurrentInstance(null);
            return null;
        }
        this.itemStackEntity.models.get((int)0).mesh.calculateOffset();
        this.itemStackEntity.getTransformation().set(new Matrix4d().translate((double)pos.m_123341_() + blockOffset.f_82479_, (double)pos.m_123342_() + blockOffset.f_82480_, (double)pos.m_123343_() + blockOffset.f_82481_));
        this.itemStackEntity.getOldTransformation().set(this.itemStackEntity.getTransformation());
        return this.itemStackEntity;
    }

    public PhysicsEntity renderBlockIntoEntity(PhysicsEntity.Type type, BlockState state, BlockPos pos) {
        BlockRenderDispatcher manager = Minecraft.m_91087_().m_91289_();
        BakedModel model = manager.m_110910_(state);
        return this.renderBlockIntoEntity(type, model, state, pos);
    }

    private boolean renderFlat(PhysicsEntity entity, BlockAndTintGetter world, BakedModel model, BlockState state, BlockPos pos, Random random, long seed, int overlay) {
        boolean rendered = false;
        Mesh mesh = entity.models.get((int)0).mesh;
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            Direction direction = DIRECTIONS[i];
            random.setSeed(seed);
            List list = model.m_6840_(state, direction, random);
            if (list.isEmpty()) continue;
            this.renderQuadsFlat(entity, mesh, world, state, pos, overlay, list);
            rendered = true;
        }
        random.setSeed(seed);
        List quads = model.m_6840_(state, (Direction)null, random);
        if (!quads.isEmpty()) {
            this.renderQuadsFlat(entity, mesh, world, state, pos, overlay, quads);
            rendered = true;
        }
        return rendered;
    }

    private void renderQuadsFlat(PhysicsEntity entity, Mesh mesh, BlockAndTintGetter world, BlockState state, BlockPos pos, int overlay, List<BakedQuad> quads) {
        for (int i = 0; i < quads.size(); ++i) {
            this.renderQuad(entity, mesh, world, state, pos, quads.get(i), overlay);
        }
    }

    private void renderQuad(PhysicsEntity entity, Mesh mesh, BlockAndTintGetter world, BlockState state, BlockPos pos, BakedQuad quad, int overlay) {
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        if (quad.m_111304_()) {
            int i = Minecraft.m_91087_().m_91298_().m_92577_(state, world, pos, quad.m_111305_());
            red = (float)(i >> 16 & 0xFF) / 255.0f;
            green = (float)(i >> 8 & 0xFF) / 255.0f;
            blue = (float)(i & 0xFF) / 255.0f;
        }
        entity.shade = quad.m_111307_();
        int[] vertexData = quad.m_111303_();
        Vec3i normal = quad.m_111306_().m_122436_();
        int vertexSize = DefaultVertexFormat.f_85811_.m_86017_();
        int vertices = vertexData.length / vertexSize;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize;
            float x = Float.intBitsToFloat(vertexData[offset]);
            float y = Float.intBitsToFloat(vertexData[offset + 1]);
            float z = Float.intBitsToFloat(vertexData[offset + 2]);
            int rgb = vertexData[offset + 3];
            float r = (float)(rgb >> 24 & 0xFF) / 255.0f * red;
            float g = (float)(rgb >> 16 & 0xFF) / 255.0f * green;
            float b = (float)(rgb >> 8 & 0xFF) / 255.0f * blue;
            mesh.positions.add(new Vector3d(x, y, z));
            mesh.addColor(r, g, b);
            mesh.normals.add(new org.joml.Vector3f(normal.m_123341_(), normal.m_123342_(), normal.m_123343_()));
            mesh.uvs.add(new Vector2f(Float.intBitsToFloat(vertexData[offset + 4]), Float.intBitsToFloat(vertexData[offset + 5])));
        }
        int index = mesh.positions.size() - 4 + 1;
        mesh.indices.add(new Vector3i(index).add(0, 0, 0));
        mesh.indices.add(new Vector3i(index).add(1, 1, 1));
        mesh.indices.add(new Vector3i(index).add(2, 2, 2));
        mesh.indices.add(new Vector3i(index).add(0, 0, 0));
        mesh.indices.add(new Vector3i(index).add(2, 2, 2));
        mesh.indices.add(new Vector3i(index).add(3, 3, 3));
    }

    static {
        renderers = new Object2ObjectOpenHashMap();
        registeredBlocks = new Object2ObjectOpenHashMap();
        invRegisteredBlocks = new Object2ObjectOpenHashMap();
        mirroredCuboids = new Object2ObjectOpenHashMap();
        loadedModels = new Object2ObjectOpenHashMap();
        projectionMatrix = new Matrix4f();
        viewMatrix = new Matrix4f();
        optifineClothCompat = new ObjectArrayList();
        brokenBlocksLittle = new ObjectArrayList();
        brokenBlocksLots = new ObjectArrayList();
        snowballMesh = new ObjectArrayList();
        snowballMeshFractured = new ObjectArrayList();
        enderpearlMesh = new ObjectArrayList();
        enderpearlMeshFractured = new ObjectArrayList();
        eggMesh = new ObjectArrayList();
        eggMeshFractured = new ObjectArrayList();
        brokenBlocksLittle.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_little_1.obj"));
        brokenBlocksLittle.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_little_2.obj"));
        brokenBlocksLittle.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_little_3.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_2.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_3.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_4.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_5.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_6.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_7.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_8.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_9.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_10.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_11.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_12.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/fractures/physics_shattered_lots_13.obj"));
        brokenBlock = PhysicsMod.readBlock("assets/fractures/physics_simple.obj");
        snowballMesh.add(PhysicsMod.readBlock("assets/physicsmod/models/snowball/snowball_voxel.obj").get(0));
        snowballMesh.add(PhysicsMod.readBlock("assets/physicsmod/models/snowball/snowball_round.obj").get(0));
        snowballMeshFractured.add(PhysicsMod.readBlock("assets/physicsmod/models/snowball/snowball_voxel_fractured.obj"));
        snowballMeshFractured.add(PhysicsMod.readBlock("assets/physicsmod/models/snowball/snowball_round_fractured.obj"));
        enderpearlMesh.add(PhysicsMod.readBlock("assets/physicsmod/models/enderpearl/enderpearl_voxel.obj").get(0));
        enderpearlMesh.add(PhysicsMod.readBlock("assets/physicsmod/models/enderpearl/enderpearl_round.obj").get(0));
        enderpearlMeshFractured.add(PhysicsMod.readBlock("assets/physicsmod/models/enderpearl/enderpearl_voxel_fractured.obj"));
        enderpearlMeshFractured.add(PhysicsMod.readBlock("assets/physicsmod/models/enderpearl/enderpearl_round_fractured.obj"));
        eggMesh.add(PhysicsMod.readBlock("assets/physicsmod/models/egg/egg_voxel.obj").get(0));
        eggMesh.add(PhysicsMod.readBlock("assets/physicsmod/models/egg/egg_round.obj").get(0));
        eggMeshFractured.add(PhysicsMod.readBlock("assets/physicsmod/models/egg/egg_voxel_fractured.obj"));
        eggMeshFractured.add(PhysicsMod.readBlock("assets/physicsmod/models/egg/egg_round_fractured.obj"));
        DIRECTIONS = Direction.values();
    }
}

