/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.ragdoll;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.diebuddies.bridge.ReflectionsForge;
import net.diebuddies.config.ConfigMobs;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.ragdoll.RagdollHook;
import net.diebuddies.physics.ragdoll.VanillaRagdollHook;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.LlamaModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.level.Level;

public class RagdollMapper {
    private static final List<RagdollHook> hooks = new ObjectArrayList();
    private static final RagdollHook vanillaHook = new VanillaRagdollHook();

    public static void addHook(RagdollHook hook) {
        hooks.add(hook);
    }

    public static void removeHook(RagdollHook hook) {
        hooks.remove(hook);
    }

    public static Ragdoll map(Entity entity, EntityModel model) {
        Ragdoll ragdoll = new Ragdoll();
        ragdoll.bodies.addAll(PhysicsMod.getInstance((Level)entity.m_20193_()).blockifiedEntity);
        for (RagdollHook hook : hooks) {
            hook.map(ragdoll, entity, model);
        }
        if (ragdoll.joints.size() > 0) {
            return ragdoll;
        }
        vanillaHook.map(ragdoll, entity, model);
        if (ragdoll.joints.size() == 0) {
            return null;
        }
        return ragdoll;
    }

    public static void filterCuboidsFromEntities(Entity entity, EntityModel model) {
        PhysicsMod mod = PhysicsMod.getInstance(entity.m_20193_());
        for (RagdollHook hook : hooks) {
            hook.filterCuboidsFromEntities(mod.blockifiedEntity, entity, model);
        }
        vanillaHook.filterCuboidsFromEntities(mod.blockifiedEntity, entity, model);
    }

    public static void printModelParts(EntityModel model) {
        if (model instanceof AgeableListModel) {
            int index = 0;
            for (ModelPart part : ReflectionsForge.headParts((AgeableListModel)model)) {
                index = RagdollMapper.printModelPart(part, index);
            }
            for (ModelPart part : ReflectionsForge.bodyParts((AgeableListModel)model)) {
                index = RagdollMapper.printModelPart(part, index);
            }
            System.out.println("total: " + index);
        } else if (model instanceof HierarchicalModel) {
            int total = RagdollMapper.printModelParts((HierarchicalModel)model);
            System.out.println(model.getClass());
            System.out.println("total: " + total);
        }
    }

    public static int countModelParts(Entity entity, EntityModel model) {
        if (model instanceof LlamaModel) {
            int total = 9;
            if (!((AbstractChestedHorse)entity).m_6162_() && ((AbstractChestedHorse)entity).m_30502_()) {
                total = 11;
            }
            return total;
        }
        if (model instanceof AgeableListModel) {
            int total = 0;
            for (ModelPart part : ReflectionsForge.headParts((AgeableListModel)model)) {
                total = RagdollMapper.printModelPart(part, total, true);
            }
            for (ModelPart part : ReflectionsForge.bodyParts((AgeableListModel)model)) {
                total = RagdollMapper.printModelPart(part, total, true);
            }
            return total;
        }
        if (model instanceof HierarchicalModel) {
            int total = RagdollMapper.printModelParts((HierarchicalModel)model, true);
            return total;
        }
        return 0;
    }

    public static boolean areRagdollsEnabled(Entity entity) {
        return ConfigMobs.getMobSetting(entity) == 4;
    }

    public static boolean isMobFracturingEnabled(Entity entity) {
        return ConfigMobs.getMobSetting(entity) == 1 || ConfigMobs.getMobSetting(entity) == 2;
    }

    private static int printModelParts(HierarchicalModel entityModel, boolean hidePrint) {
        ModelPart root = entityModel.m_142109_();
        return RagdollMapper.printModelPart(root, 0, hidePrint);
    }

    private static int printModelParts(HierarchicalModel entityModel) {
        return RagdollMapper.printModelParts(entityModel, false);
    }

    public static int printModelPart(ModelPart part, int index, boolean hidePrint) {
        if (part.f_104207_) {
            for (int i = 0; i < part.f_104212_.size(); ++i) {
                ++index;
            }
            for (Map.Entry entry : part.f_104213_.entrySet()) {
                if (!hidePrint) {
                    System.out.println((String)entry.getKey() + ": " + index);
                }
                ModelPart child = (ModelPart)entry.getValue();
                index = RagdollMapper.printModelPart(child, index, hidePrint);
            }
        }
        return index;
    }

    public static int printModelPart(ModelPart part, int index) {
        return RagdollMapper.printModelPart(part, index, false);
    }

    public static int getCuboids(Ragdoll ragdoll, ModelPart part, Counter counter, boolean onlyVisual) {
        if (part.f_104207_) {
            for (int c = 1; c < part.f_104212_.size(); ++c) {
                ragdoll.addConnection(counter.count + c, counter.count, true, onlyVisual);
            }
            counter.count += part.f_104212_.size();
            for (ModelPart p : part.f_104213_.values()) {
                counter.count = RagdollMapper.getCuboids(ragdoll, p, counter);
            }
        }
        return counter.count;
    }

    public static int getCuboids(Ragdoll ragdoll, ModelPart part, Counter counter) {
        return RagdollMapper.getCuboids(ragdoll, part, counter, false);
    }

    public static class Counter {
        public int count;
    }
}

