/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.ragdoll;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ragdoll.DynamicRagdoll;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.ragdoll.RagdollJoint;
import net.diebuddies.physics.vines.VineHelper;
import net.diebuddies.physics.vines.VineSetting;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4d;
import org.joml.Vector3d;
import org.lwjgl.system.MemoryStack;
import physx.PxTopLevelFunctions;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.extensions.PxD6AxisEnum;
import physx.extensions.PxD6DriveEnum;
import physx.extensions.PxD6Joint;
import physx.extensions.PxD6JointDrive;
import physx.extensions.PxD6MotionEnum;
import physx.extensions.PxJoint;
import physx.extensions.PxJointAngularLimitPair;
import physx.extensions.PxSpring;
import physx.physics.PxFilterData;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidDynamic;

public class VineRagdoll
extends DynamicRagdoll {
    public List<Connector> connectors = new ObjectArrayList();
    public boolean bottomFixed;
    public float stiffness = 10.0f;
    public float damping = 60.0f;
    private boolean alwaysInWater;

    @Override
    public void updatePhysics(PhysicsWorld physics) {
        super.updatePhysics(physics);
        if (this.alwaysInWater) {
            for (IRigidBody body : this.btBodies) {
                body.setGravity(false);
            }
        }
    }

    @Override
    public boolean blockUpdate(PhysicsWorld physics, BlockPos pos, BlockState state) {
        if (this.bodiesPos.size() == 0) {
            return false;
        }
        BlockPos start = (BlockPos)this.bodiesPos.get(0);
        if (start.m_123341_() != pos.m_123341_() || start.m_123343_() != pos.m_123343_()) {
            return false;
        }
        int index = this.bodiesPos.indexOf(pos);
        if (index != -1) {
            VineSetting setting = (VineSetting)VineHelper.getSetting((BlockState)this.bodiesState.get(index));
            if (setting != null && !setting.canLink((BlockState)this.bodiesState.get(index), state)) {
                boolean sideConnection = setting.sideConnection;
                int cutJoint = -1;
                BlockPos connectionDir = this.bottomFixed ? pos.m_7495_() : pos.m_7494_();
                for (int i = 0; i < this.connectors.size(); ++i) {
                    if (!this.connectors.get(i).connects(pos, connectionDir)) continue;
                    cutJoint = i;
                    break;
                }
                PxJoint releasedJoint = (PxJoint)this.pxJoints.remove(cutJoint);
                releasedJoint.release();
                ObjectArrayList bodiesNew = new ObjectArrayList();
                ObjectArrayList btBodiesNew = new ObjectArrayList();
                ObjectArrayList pxJointsNew = new ObjectArrayList();
                ObjectArrayList connectorsNew = new ObjectArrayList();
                Object cutConnector = this.connectors.remove(cutJoint);
                BlockPos pos1 = pos;
                BlockPos pos2 = connectionDir;
                ObjectOpenHashSet removedPositions = new ObjectOpenHashSet();
                block11: while (cutConnector != null) {
                    cutConnector = null;
                    pos1 = this.bottomFixed ? pos1.m_7494_() : pos1.m_7495_();
                    pos2 = this.bottomFixed ? pos2.m_7494_() : pos2.m_7495_();
                    removedPositions.add(pos1);
                    removedPositions.add(pos2);
                    this.moveBodiesIntoNewRagdoll(pos1, (List<IRigidBody>)btBodiesNew, (List<PhysicsEntity>)bodiesNew);
                    this.moveBodiesIntoNewRagdoll(pos2, (List<IRigidBody>)btBodiesNew, (List<PhysicsEntity>)bodiesNew);
                    for (int i = 0; i < this.connectors.size(); ++i) {
                        Connector connection = this.connectors.get(i);
                        if (!connection.connects(pos1, pos2)) continue;
                        cutConnector = connection;
                        connectorsNew.add(this.connectors.remove(i));
                        pxJointsNew.add((PxJoint)this.pxJoints.remove(i));
                        continue block11;
                    }
                }
                removedPositions.remove(pos);
                VineRagdoll vine = new VineRagdoll();
                vine.hitboxScale = this.hitboxScale;
                vine.bottomFixed = this.bottomFixed;
                vine.bodies.addAll(bodiesNew);
                vine.btBodies.addAll(btBodiesNew);
                vine.pxJoints.addAll(pxJointsNew);
                vine.connectors.addAll((Collection<Connector>)connectorsNew);
                vine.initFreeze = false;
                ((IRigidBody)vine.btBodies.get(0)).applyRandomSpawnForces();
                for (IRigidBody body : vine.btBodies) {
                    if (body.getRigidBody() instanceof PxRigidDynamic) {
                        ((PxRigidDynamic)body.getRigidBody()).wakeUp();
                    }
                    body.setGravity(true);
                    MemoryStack mem = MemoryStack.stackPush();
                    try {
                        PxFilterData tmpFilterData = PxFilterData.createAt(mem, MemoryStack::nmalloc, 1, 1, 0, 0);
                        body.getShape().setSimulationFilterData(tmpFilterData);
                    }
                    finally {
                        if (mem == null) continue;
                        mem.close();
                    }
                }
                double rnd = vine.bodies.size() > 0 ? PhysicsWorld.calculateLifetime((PhysicsEntity)vine.bodies.get(0)) : 0.0;
                for (Object entity : vine.bodies) {
                    ((PhysicsEntity)entity).type = PhysicsEntity.Type.OTHER;
                    ((PhysicsEntity)entity).time = rnd;
                }
                if (this.hookJoint == releasedJoint) {
                    physics.getDynamicsWorld().removeActor(this.hookBody.getRigidBody());
                    this.btBodies.remove(this.hookBody);
                    this.hookBody.destroy();
                    this.hookBody = null;
                }
                physics.getRagdolls().add(vine);
                if (sideConnection) {
                    ObjectArrayList sorted = new ObjectArrayList((Collection)removedPositions);
                    Collections.sort(sorted, (a, b) -> -Integer.compare(a.m_123342_(), b.m_123342_()));
                    for (BlockPos removedPosition : sorted) {
                        physics.blockUpdate(removedPosition);
                    }
                }
                return true;
            }
            PhysicsEntity entity = PhysicsMod.getInstance(physics.getWorld()).renderBlockIntoEntity(PhysicsEntity.Type.VINE, state, pos);
            if (entity == null) {
                entity = new PhysicsEntity(PhysicsEntity.Type.VINE, state);
                entity.getTransformation().set(new Matrix4d().translate((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5));
                entity.getOldTransformation().set(entity.getTransformation());
                entity.models.get((int)0).mesh = new Mesh();
                entity.models.get((int)0).mesh.offset = new Vector3d();
            }
            entity.enlargeHitbox = this.hitboxScale;
            ((PhysicsEntity)this.bodies.get(index)).destroy();
            ((PhysicsEntity)this.bodies.get((int)index)).models = entity.models;
            this.bodiesState.set(index, state);
            return true;
        }
        if (this.bodiesPos.size() > 0) {
            int highestY = ((BlockPos)this.bodiesPos.get(0)).m_123342_();
            int highestIndex = 0;
            for (int i = 1; i < this.bodiesPos.size(); ++i) {
                int y = ((BlockPos)this.bodiesPos.get(i)).m_123342_();
                if (this.bottomFixed) {
                    if (y <= highestY) continue;
                    highestY = y;
                    highestIndex = i;
                    continue;
                }
                if (y >= highestY) continue;
                highestY = y;
                highestIndex = i;
            }
            BlockPos check = new BlockPos(pos.m_123341_(), highestY, pos.m_123343_());
            index = this.bodiesPos.indexOf(check);
            VineSetting setting = (VineSetting)VineHelper.getSetting((BlockState)this.bodiesState.get(index));
            if (setting != null && index != -1 && (this.bottomFixed ? highestY + 1 == pos.m_123342_() : highestY - 1 == pos.m_123342_()) && setting.canLink((BlockState)this.bodiesState.get(index), state)) {
                PhysicsEntity entity;
                IRigidBody appendTo = null;
                PhysicsEntity highestEntity = (PhysicsEntity)this.bodies.get(highestIndex);
                for (int i = 0; i < this.btBodies.size(); ++i) {
                    IRigidBody body = (IRigidBody)this.btBodies.get(i);
                    if (!body.getEntity().equals(highestEntity)) continue;
                    appendTo = body;
                    break;
                }
                if ((entity = PhysicsMod.getInstance(physics.getWorld()).renderBlockIntoEntity(PhysicsEntity.Type.VINE, state, pos)) == null) {
                    entity = new PhysicsEntity(PhysicsEntity.Type.VINE, state);
                    entity.getTransformation().set(new Matrix4d().translate((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5));
                    entity.getOldTransformation().set(entity.getTransformation());
                    entity.models.get((int)0).mesh = new Mesh();
                    entity.models.get((int)0).mesh.offset = new Vector3d();
                }
                entity.enlargeHitbox = this.hitboxScale;
                Connector connector = new Connector(check, pos);
                this.connectors.add(connector);
                this.bodiesPos.add(pos);
                this.bodiesState.add(state);
                this.bodies.add(entity);
                IRigidBody childLink = physics.addBlockParticle(entity);
                entity.time = ConfigClient.particleLifetimeBlocks;
                childLink.setFrozen(this.frozen);
                childLink.separateController = true;
                this.btBodies.add(childLink);
                try (MemoryStack mem = MemoryStack.stackPush();){
                    Vector3d localPos1 = childLink.getEntity().models.get((int)0).mesh.offset;
                    Vector3d localPos2 = appendTo.getEntity().models.get((int)0).mesh.offset;
                    double childOffY = this.bottomFixed ? -localPos1.y : localPos1.y;
                    double parentOffY = this.bottomFixed ? localPos2.y : -localPos2.y;
                    PxTransform parentPose = PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, 0.0f, (float)parentOffY, 0.0f), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f));
                    PxTransform childPose = PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, (float)(localPos2.x - localPos1.x), (float)childOffY, (float)(localPos2.z - localPos1.z)), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f));
                    PxD6Joint joint = this.createJoint(appendTo.getRigidBody(), parentPose, childLink.getRigidBody(), childPose);
                    this.pxJoints.add(joint);
                }
                return true;
            }
        }
        return false;
    }

    private void moveBodiesIntoNewRagdoll(BlockPos pos, List<IRigidBody> btBodiesNew, List<PhysicsEntity> bodiesNew) {
        int removeBody = this.bodiesPos.indexOf(pos);
        if (removeBody != -1) {
            this.bodiesPos.remove(removeBody);
            this.bodiesState.remove(removeBody);
            PhysicsEntity entity = (PhysicsEntity)this.bodies.remove(removeBody);
            bodiesNew.add(entity);
            for (int i = 0; i < this.btBodies.size(); ++i) {
                IRigidBody btBody = (IRigidBody)this.btBodies.get(i);
                if (!btBody.getEntity().equals(entity)) continue;
                this.btBodies.remove(btBody);
                btBodiesNew.add(btBody);
                break;
            }
        }
    }

    public void setAlwaysInWater(boolean alwaysInWater) {
        this.alwaysInWater = alwaysInWater;
        for (IRigidBody body : this.btBodies) {
            if (!body.hasGravity()) continue;
            body.setGravity(!alwaysInWater);
        }
    }

    @Override
    protected void createHook(PhysicsWorld physics, PhysicsEntity particle, IRigidBody rigidBody) {
        super.createHook(physics, particle, rigidBody);
        BlockPos pos = (BlockPos)this.bodiesPos.get(this.bodies.indexOf(rigidBody.getEntity()));
        this.connectors.add(new Connector(pos, this.bottomFixed ? pos.m_7495_() : pos.m_7494_()));
    }

    @Override
    protected void createChildLink(PhysicsWorld physics, IRigidBody rootLink, Ragdoll.Node root, double rnd) {
        PhysicsEntity particle = (PhysicsEntity)this.bodies.get(root.index);
        if (!particle.noVolume) {
            RagdollJoint rjoint = (RagdollJoint)this.joints.get(root.jointIndex);
            if (rjoint.fixed) {
                return;
            }
            particle.stopCollision = rjoint.stopCollision;
            IRigidBody childLink = physics.addBlockParticle(particle);
            particle.time = ConfigClient.particleLifetimeMobs + rnd;
            childLink.setFrozen(this.frozen);
            childLink.separateController = true;
            this.btBodies.add(childLink);
            try (MemoryStack mem = MemoryStack.stackPush();){
                PxTransform parentPose = PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, (float)rjoint.point1.x, (float)rjoint.point1.y, (float)rjoint.point1.z), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f));
                PxTransform childPose = PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, (float)rjoint.point2.x, (float)rjoint.point2.y, (float)rjoint.point2.z), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f));
                if (rjoint.index1 == root.index) {
                    PxTransform tmp = parentPose;
                    parentPose = childPose;
                    childPose = tmp;
                }
                PxD6Joint joint = this.createJoint(rootLink.getRigidBody(), parentPose, childLink.getRigidBody(), childPose);
                this.pxJoints.add(joint);
                this.connectors.add(new Connector((BlockPos)this.bodiesPos.get(this.bodies.indexOf(rootLink.getEntity())), (BlockPos)this.bodiesPos.get(this.bodies.indexOf(childLink.getEntity()))));
                for (int i = 0; i < root.children.size(); ++i) {
                    this.createChildLink(physics, childLink, root.children.get(i), rnd);
                }
            }
            if (particle.equals(this.hookedEntity)) {
                this.createHook(physics, particle, childLink);
            }
        }
    }

    @Override
    protected PxD6Joint createJoint(PxRigidActor rigidBody1, PxTransform localPose1, PxRigidActor rigidBody2, PxTransform localPose2) {
        PxD6Joint joint = null;
        try (MemoryStack mem = MemoryStack.stackPush();){
            joint = PxTopLevelFunctions.D6JointCreate(StarterClient.physics, rigidBody1, localPose1, rigidBody2, localPose2);
            joint.setMotion(PxD6AxisEnum.eTWIST, PxD6MotionEnum.eLIMITED);
            joint.setMotion(PxD6AxisEnum.eSWING1, PxD6MotionEnum.eLIMITED);
            joint.setMotion(PxD6AxisEnum.eSWING2, PxD6MotionEnum.eLIMITED);
            PxD6JointDrive drive = new PxD6JointDrive(this.stiffness, this.damping, 100000.0f, true);
            joint.setDrive(PxD6DriveEnum.eSWING, drive);
            joint.setDrive(PxD6DriveEnum.eTWIST, drive);
            joint.setDrivePosition(PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f)));
            joint.setDriveVelocity(PxVec3.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f), PxVec3.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f));
            PxSpring spring = new PxSpring(60.0f, 10.0f);
            PxJointAngularLimitPair angularLimit = new PxJointAngularLimitPair(-0.3926991f, 0.3926991f, spring);
            joint.setTwistLimit(angularLimit);
            drive.destroy();
            spring.destroy();
            angularLimit.destroy();
        }
        return joint;
    }

    class Connector {
        BlockPos pos1;
        BlockPos pos2;

        public Connector(BlockPos pos1, BlockPos pos2) {
            this.pos1 = pos1;
            this.pos2 = pos2;
        }

        public boolean connects(BlockPos pos1, BlockPos pos2) {
            return this.pos1.equals((Object)pos1) && this.pos2.equals((Object)pos2) || this.pos1.equals((Object)pos2) && this.pos2.equals((Object)pos1);
        }
    }
}

