/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.settings.BlocksCustomizeSettingsScreen;
import net.minecraft.client.CycleOption;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.ProgressOption;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;

public class BlocksSettingsScreen
extends OptionsSubScreen {
    CycleOption<BlockPhysicsType> PHYSICS_BLOCK = CycleOption.m_167764_((String)"Block Physics", (Object[])((Object[])BlockPhysicsType.values()), mobPhysicsType -> {
        String text = "OFF";
        switch ((BlockPhysicsType)((Object)((Object)mobPhysicsType))) {
            case OFF: {
                text = "OFF";
                break;
            }
            case FRACTURED: {
                text = "Fractured";
                break;
            }
            case BLOCKY: {
                text = "Blocky";
                break;
            }
            case PARTICLES: {
                text = "Particles";
                break;
            }
            default: {
                text = "OFF";
            }
        }
        return new TextComponent(text);
    }, gameOptions -> {
        int val = ConfigClient.blockPhysics;
        switch (val) {
            case 0: {
                return BlockPhysicsType.OFF;
            }
            case 1: {
                return BlockPhysicsType.FRACTURED;
            }
            case 3: {
                return BlockPhysicsType.BLOCKY;
            }
            case 4: {
                return BlockPhysicsType.PARTICLES;
            }
        }
        return BlockPhysicsType.OFF;
    }, (gameOptions, option, mobPhysicsType) -> {
        BlockPhysicsType type = (BlockPhysicsType)((Object)((Object)mobPhysicsType));
        switch (type) {
            case OFF: {
                ConfigClient.blockPhysics = 0;
                break;
            }
            case FRACTURED: {
                ConfigClient.blockPhysics = 1;
                break;
            }
            case BLOCKY: {
                ConfigClient.blockPhysics = 3;
                break;
            }
            case PARTICLES: {
                ConfigClient.blockPhysics = 4;
            }
        }
        ConfigClient.save();
    });
    private static final ProgressOption PHYSICS_PARTICLE_LIFETIME_BLOCKS = new ProgressOption("Physics Lifetime (Blocks)", 0.1, 100.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeBlocks, (gameOptions, value) -> {
        ConfigClient.particleLifetimeBlocks = value;
        ConfigClient.save();
    }, (gameOptions, option) -> new TextComponent("Physics Lifetime (Blocks): " + String.format("%.2f", option.m_92221_(gameOptions))));
    private static final ProgressOption PHYSICS_BLOCKS_RANGE = new ProgressOption("Activation Distance", 10.0, 320.0, 0.1f, gameOptions -> ConfigClient.blockPhysicsRange, (gameOptions, value) -> {
        ConfigClient.blockPhysicsRange = value;
        ConfigClient.save();
    }, (gameOptions, option) -> {
        double val = option.m_92221_(gameOptions);
        if (val >= 319.999) {
            return new TextComponent("Activation Distance: Always");
        }
        return new TextComponent("Activation Distance: " + String.format("%.2f", option.m_92221_(gameOptions)));
    }, minecraft -> {
        List list = minecraft.f_91062_.m_92923_((FormattedText)new TextComponent("Describes at which distance to the player (in blocks) it should stop activating block physics."), 200);
        return list;
    });
    private static final ProgressOption PHYSICS_BLOCK_SCALE = new ProgressOption("Physics Objects Scale", 0.05, 4.0, 0.01f, gameOptions -> ConfigClient.blockPhysicsScale, (gameOptions, value) -> {
        ConfigClient.blockPhysicsScale = value;
        ConfigClient.save();
    }, (gameOptions, option) -> new TextComponent("Physics Objects Scale: " + String.format("%.2f", option.m_92221_(gameOptions))));
    private OptionsList list;

    public BlocksSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)new TextComponent("Block Settings"));
    }

    protected void m_7856_() {
        this.list = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.list.m_94473_(this.PHYSICS_BLOCK, (Option)PHYSICS_PARTICLE_LIFETIME_BLOCKS);
        this.list.m_94473_((Option)PHYSICS_BLOCKS_RANGE, (Option)PHYSICS_BLOCK_SCALE);
        this.f_96540_.add(this.list);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 80, this.f_96544_ - 27, 75, 20, (Component)new TextComponent("Customize"), button -> this.f_96541_.m_91152_((Screen)new BlocksCustomizeSettingsScreen((Screen)this, this.f_96541_.f_91066_))));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ - 27, 75, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.f_96281_)));
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        this.list.m_6305_(matrices, mouseX, mouseY, delta);
        BlocksSettingsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        List list = BlocksSettingsScreen.m_96287_((OptionsList)this.list, (int)mouseX, (int)mouseY);
        if (list != null) {
            this.m_96617_(matrices, list, mouseX, mouseY);
        }
    }

    public static enum BlockPhysicsType {
        OFF,
        FRACTURED,
        BLOCKY,
        PARTICLES;

    }
}

