/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.settings.GravityCustomizeSettingsScreen;
import net.minecraft.client.CycleOption;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.ProgressOption;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;

public class GeneralSettingsScreen
extends OptionsSubScreen {
    private static final ProgressOption PHYSICS_MAX_OBJECTS = new ProgressOption("Physics Max Objects", 10.0, 30000.0, 1.0f, gameOptions -> ConfigClient.maxPhysicsObjects, (gameOptions, value) -> {
        ConfigClient.maxPhysicsObjects = value.intValue();
        ConfigClient.save();
    }, (gameOptions, option) -> new TextComponent("Physics Max Objects: " + (int)option.m_92221_(gameOptions)));
    private static final ProgressOption CPU_THREADS = new ProgressOption("Physics CPU Threads", 1.0, (double)Runtime.getRuntime().availableProcessors(), 1.0f, gameOptions -> ConfigClient.cpuThreads, (gameOptions, value) -> {
        ConfigClient.cpuThreads = Math.max(value.intValue(), 1);
        ConfigClient.save();
    }, (gameOptions, option) -> new TextComponent("Physics CPU Threads: " + (int)option.m_92221_(gameOptions)), minecraft -> {
        List list = minecraft.f_91062_.m_92923_((FormattedText)new TextComponent("After changing this you will need to reload the world to apply changes."), 200);
        return list;
    });
    private static final CycleOption<Boolean> MINECRAFT_BREAK_PARTICLES = CycleOption.m_167743_((String)"MC Break Particles", gameOptions -> ConfigClient.minecraftBlockBreakParticles, (gameOptions, option, value) -> {
        ConfigClient.minecraftBlockBreakParticles = value;
        ConfigClient.save();
    });
    private static final CycleOption<Boolean> PVP_COMPATIBILITY = CycleOption.m_167743_((String)"PVP Server Compatibility", gameOptions -> ConfigClient.pvpServerCompatibility, (gameOptions, option, value) -> {
        ConfigClient.pvpServerCompatibility = value;
        ConfigClient.save();
    }).m_167773_(minecraft -> {
        List list = minecraft.f_91062_.m_92923_((FormattedText)new TextComponent("Enables Physics for entities that simply disappear without triggering the death event. When enabled bees going into hives, mob transformations and spawning mobs in peaceful mode will trigger physics."), 200);
        return graphicsStatus -> list;
    });
    private static final CycleOption<Boolean> CRACK_PARTICLES = CycleOption.m_167743_((String)"Physics Crack Particles", gameOptions -> ConfigClient.crackPhysicsParticles, (gameOptions, option, value) -> {
        ConfigClient.crackPhysicsParticles = value;
        ConfigClient.save();
    }).m_167773_(minecraft -> {
        List list = minecraft.f_91062_.m_92923_((FormattedText)new TextComponent("Enables Physics for particles while cracking a block."), 200);
        return graphicsStatus -> list;
    });
    private static final ProgressOption PHYSICS_PARTICLE_LIFETIME_PARTICLES = new ProgressOption("Physics Lifetime (Particles)", 0.1, 100.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeParticles, (gameOptions, value) -> {
        ConfigClient.particleLifetimeParticles = value;
        ConfigClient.save();
    }, (gameOptions, option) -> new TextComponent("Physics Lifetime (Particles): " + String.format("%.2f", option.m_92221_(gameOptions))));
    private OptionsList list;

    public GeneralSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)new TextComponent("General Settings"));
    }

    protected void m_7856_() {
        this.list = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.list.m_94473_((Option)PHYSICS_MAX_OBJECTS, MINECRAFT_BREAK_PARTICLES);
        this.list.m_94471_((Option)CPU_THREADS);
        this.list.m_94471_(PVP_COMPATIBILITY);
        this.list.m_94471_(CRACK_PARTICLES);
        this.list.m_94471_((Option)PHYSICS_PARTICLE_LIFETIME_PARTICLES);
        this.f_96540_.add(this.list);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 80, this.f_96544_ - 27, 75, 20, (Component)new TextComponent("Gravity"), button -> this.f_96541_.m_91152_((Screen)new GravityCustomizeSettingsScreen((Screen)this, this.f_96541_.f_91066_))));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ - 27, 75, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.f_96281_)));
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        this.list.m_6305_(matrices, mouseX, mouseY, delta);
        GeneralSettingsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        List list = GeneralSettingsScreen.m_96287_((OptionsList)this.list, (int)mouseX, (int)mouseY);
        if (list != null) {
            this.m_96617_(matrices, list, mouseX, mouseY);
        }
    }
}

