/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.StringConcatFactory;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.liquid.Liquid;
import net.minecraft.Util;
import net.minecraft.client.CycleOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.ProgressOption;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;

public class LiquidSettingsScreen
extends OptionsSubScreen {
    private static final CycleOption<Boolean> PHYSICS_LIQUIDS = CycleOption.m_167743_((String)"Liquid Physics", gameOptions -> ConfigClient.liquidPhysics, (gameOptions, option, value) -> {
        ConfigClient.liquidPhysics = value;
        ConfigClient.save();
        if (!ConfigClient.liquidPhysics) {
            for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                ObjectArrayList liquids = new ObjectArrayList(mod.getPhysicsWorld().getLiquids());
                for (Liquid liquid : liquids) {
                    mod.getPhysicsWorld().removeLiquid(liquid);
                }
            }
        }
    });
    private static final ProgressOption PHYSICS_LIQUID_CPU_THREADS = new ProgressOption("Liquid CPU Threads", 1.0, (double)Runtime.getRuntime().availableProcessors(), 1.0f, gameOptions -> ConfigClient.liquidThreads, (gameOptions, value) -> {
        ConfigClient.liquidThreads = Math.max(value.intValue(), 1);
        ConfigClient.save();
        if (Liquid.threads != null) {
            for (int i = 0; i < Liquid.threads.length; ++i) {
                Liquid.threads[i].cancel();
            }
        }
        Liquid.threads = null;
        Liquid.initThreads();
    }, (gameOptions, option) -> new TextComponent("Liquid CPU Threads: " + (int)option.m_92221_(gameOptions)), minecraft -> {
        List list = minecraft.f_91062_.m_92923_((FormattedText)new TextComponent("More threads can improve the FPS of liquids but might decrease your Minecraft FPS."), 200);
        return list;
    });
    private static final ProgressOption PHYSICS_LIQUID_DENSITY = new ProgressOption("Water Density", 3.0, 8.0, 1.0f, gameOptions -> ConfigClient.waterDensity, (gameOptions, value) -> {
        ConfigClient.waterDensity = Math.max(value.intValue(), 1);
        ConfigClient.save();
    }, (gameOptions, option) -> new TextComponent("Water Density: " + (int)option.m_92221_(gameOptions)), minecraft -> {
        List list = minecraft.f_91062_.m_92923_((FormattedText)new TextComponent("This controls the density of infinite water sources."), 200);
        return list;
    });
    private static final ProgressOption PHYSICS_LIQUID_SOURCE_DISTANCE = new ProgressOption("Liquid Max Source Distance (Blocks)", 1.0, 40.0, 0.1f, gameOptions -> ConfigClient.liquidSourceDistance, (gameOptions, value) -> {
        ConfigClient.liquidSourceDistance = value;
        ConfigClient.save();
    }, (gameOptions, option) -> new TextComponent("Liquid Max Source Distance (Blocks): " + String.format("%.0f", option.m_92221_(gameOptions))));
    private static final ProgressOption PHYSICS_LIQUID_LIFETIME = new ProgressOption("Physics Lifetime (Liquid)", 0.1, 100.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeLiquids, (gameOptions, value) -> {
        ConfigClient.particleLifetimeLiquids = value;
        ConfigClient.save();
    }, (gameOptions, option) -> new TextComponent("Physics Lifetime (Liquid): " + String.format("%.2f", option.m_92221_(gameOptions))));
    private static final int MAX_INFO_WIDTH = 300;
    private OptionsList list;
    private List<FormattedCharSequence> info;

    public LiquidSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)new TextComponent((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Liquid Settings (PRO VERSION REQUIRED)"}))));
        this.info = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)new TextComponent("This is a beta release of the liquids so that you can play around and test them. To spawn a continuous liquid source break an enchanting table (you can stop the source by placing a block on the source, everything is only CLIENT SIDE). Blocks that create a vanishing liquid source: melon, wet sponge, pumpkin, cactus, filled water cauldron."), 300);
    }

    protected void m_7856_() {
        this.list = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.f_96540_.add(this.list);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 80, this.f_96544_ - 27, 75, 20, (Component)new TextComponent("Pro Version"), button -> Util.m_137581_().m_137646_("https://minecraftphysicsmod.com/pro")));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ - 27, 75, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.f_96281_)));
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        this.list.m_6305_(matrices, mouseX, mouseY, delta);
        LiquidSettingsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        int lineY = 0;
        for (FormattedCharSequence sequence : this.info) {
            LiquidSettingsScreen.m_168756_((PoseStack)matrices, (Font)this.f_96547_, (FormattedCharSequence)sequence, (int)((this.f_96543_ - 300) / 2), (int)(137 + lineY), (int)0xFFFF55);
            lineY += 10;
        }
        List list = LiquidSettingsScreen.m_96287_((OptionsList)this.list, (int)mouseX, (int)mouseY);
        if (list != null) {
            this.m_96617_(matrices, list, mouseX, mouseY);
        }
    }

    private /* synthetic */ void lambda$init$18(Button button) {
        this.f_96541_.m_91152_(this.f_96281_);
    }
}

