/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import net.diebuddies.config.ConfigMobs;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.client.CycleOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.EntityType;

public class MobsCustomizeSettingsScreen
extends OptionsSubScreen {
    private OptionsList list;

    public MobsCustomizeSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)new TextComponent("Mob Rules"));
    }

    protected void m_7856_() {
        EditBox search = new EditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ / 2 - 160, this.f_96544_ - 27, 100, 20, (Component)new TextComponent(""));
        search.m_94167_("Search...");
        this.updateMobs("");
        search.m_94151_(changedText -> {
            if (changedText.isEmpty()) {
                search.m_94167_("Search...");
            } else {
                search.m_94167_("");
            }
            this.updateMobs((String)changedText);
        });
        this.m_142416_((GuiEventListener)search);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 50, this.f_96544_ - 27, 100, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.f_96281_)));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 60, this.f_96544_ - 27, 100, 20, (Component)new TextComponent("RESET"), button -> {
            ConfigMobs.resetMobs();
            this.f_96541_.m_91152_((Screen)new MobsCustomizeSettingsScreen(this.f_96281_, this.f_96282_));
        }));
    }

    private void updateMobs(String matcher) {
        if (this.list != null) {
            this.f_96540_.remove(this.list);
        }
        ObjectArrayList ids = new ObjectArrayList();
        for (EntityType<?> type : PhysicsMod.renderers.keySet()) {
            ids.add(EntityType.m_20613_(type).toString());
        }
        Collections.sort(ids);
        this.list = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.f_96540_.add(this.list);
        for (String id : ids) {
            if (!id.toLowerCase().contains(matcher.toLowerCase())) continue;
            CycleOption entityOption = CycleOption.m_167764_((String)id, (Object[])((Object[])MobPhysicsType.values()), mobPhysicsType -> {
                String text = "OFF";
                switch ((MobPhysicsType)((Object)((Object)mobPhysicsType))) {
                    case OFF: {
                        text = "OFF";
                        break;
                    }
                    case FRACTURED: {
                        text = "Fractured";
                        break;
                    }
                    case FRACTURED_BLOOD: {
                        text = "Fractured Blood";
                        break;
                    }
                    case BLOCKY: {
                        text = "Blocky";
                        break;
                    }
                    case RAGDOLL: {
                        text = "Ragdoll";
                        break;
                    }
                    case MAIN_RULE: {
                        text = "Main Rule";
                        break;
                    }
                    default: {
                        text = "OFF";
                    }
                }
                return new TextComponent(text);
            }, gameOptions -> {
                Integer val = ConfigMobs.customizedMobs.get(id);
                if (val == null) {
                    val = 5;
                    ConfigMobs.customizedMobs.put(id, val);
                }
                switch (val) {
                    case 0: {
                        return MobPhysicsType.OFF;
                    }
                    case 1: {
                        return MobPhysicsType.FRACTURED;
                    }
                    case 2: {
                        return MobPhysicsType.FRACTURED_BLOOD;
                    }
                    case 3: {
                        return MobPhysicsType.BLOCKY;
                    }
                    case 4: {
                        return MobPhysicsType.RAGDOLL;
                    }
                    case 5: {
                        return MobPhysicsType.MAIN_RULE;
                    }
                }
                return MobPhysicsType.OFF;
            }, (gameOptions, option, mobPhysicsType) -> {
                MobPhysicsType type = (MobPhysicsType)((Object)((Object)mobPhysicsType));
                switch (type) {
                    case OFF: {
                        ConfigMobs.customizedMobs.put(id, 0);
                        break;
                    }
                    case FRACTURED: {
                        ConfigMobs.customizedMobs.put(id, 1);
                        break;
                    }
                    case FRACTURED_BLOOD: {
                        ConfigMobs.customizedMobs.put(id, 2);
                        break;
                    }
                    case BLOCKY: {
                        ConfigMobs.customizedMobs.put(id, 3);
                        break;
                    }
                    case RAGDOLL: {
                        ConfigMobs.customizedMobs.put(id, 4);
                        break;
                    }
                    case MAIN_RULE: {
                        ConfigMobs.customizedMobs.put(id, 5);
                    }
                }
                ConfigMobs.save();
            });
            this.list.m_94471_((Option)entityOption);
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        this.list.m_6305_(matrices, mouseX, mouseY, delta);
        MobsCustomizeSettingsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        List list = MobsCustomizeSettingsScreen.m_96287_((OptionsList)this.list, (int)mouseX, (int)mouseY);
        if (list != null) {
            this.m_96617_(matrices, list, mouseX, mouseY);
        }
    }

    public static enum MobPhysicsType {
        OFF,
        FRACTURED,
        FRACTURED_BLOOD,
        BLOCKY,
        RAGDOLL,
        MAIN_RULE;

    }
}

