/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.settings.MobsCustomizeSettingsScreen;
import net.minecraft.client.CycleOption;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.ProgressOption;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class MobsSettingsScreen
extends OptionsSubScreen {
    CycleOption<MobPhysicsType> PHYSICS_MOB_CYCLING = CycleOption.m_167764_((String)"Mob Physics", (Object[])((Object[])MobPhysicsType.values()), mobPhysicsType -> {
        String text = "OFF";
        switch ((MobPhysicsType)((Object)((Object)mobPhysicsType))) {
            case OFF: {
                text = "OFF";
                break;
            }
            case FRACTURED: {
                text = "Fractured";
                break;
            }
            case FRACTURED_BLOOD: {
                text = "Fractured Blood";
                break;
            }
            case BLOCKY: {
                text = "Blocky";
                break;
            }
            case RAGDOLL: {
                text = "Ragdoll";
                break;
            }
            default: {
                text = "OFF";
            }
        }
        return new TextComponent(text);
    }, gameOptions -> {
        int val = ConfigClient.mobPhysicsType;
        switch (val) {
            case 0: {
                return MobPhysicsType.OFF;
            }
            case 1: {
                return MobPhysicsType.FRACTURED;
            }
            case 2: {
                return MobPhysicsType.FRACTURED_BLOOD;
            }
            case 3: {
                return MobPhysicsType.BLOCKY;
            }
            case 4: {
                return MobPhysicsType.RAGDOLL;
            }
        }
        return MobPhysicsType.OFF;
    }, (gameOptions, option, mobPhysicsType) -> {
        MobPhysicsType type = (MobPhysicsType)((Object)((Object)mobPhysicsType));
        switch (type) {
            case OFF: {
                ConfigClient.mobPhysicsType = 0;
                break;
            }
            case FRACTURED: {
                ConfigClient.mobPhysicsType = 1;
                break;
            }
            case FRACTURED_BLOOD: {
                ConfigClient.mobPhysicsType = 2;
                break;
            }
            case BLOCKY: {
                ConfigClient.mobPhysicsType = 3;
                break;
            }
            case RAGDOLL: {
                ConfigClient.mobPhysicsType = 4;
            }
        }
        ConfigClient.save();
    });
    private static final ProgressOption PHYSICS_PARTICLE_LIFETIME_MOBS = new ProgressOption("Physics Lifetime (Mobs)", 0.1, 100.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeMobs, (gameOptions, value) -> {
        ConfigClient.particleLifetimeMobs = value;
        ConfigClient.save();
    }, (gameOptions, option) -> new TextComponent("Physics Lifetime (Mobs): " + String.format("%.2f", option.m_92221_(gameOptions))));
    private OptionsList list;

    public MobsSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)new TextComponent("Mob Settings"));
    }

    protected void m_7856_() {
        this.list = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.list.m_94473_(this.PHYSICS_MOB_CYCLING, (Option)PHYSICS_PARTICLE_LIFETIME_MOBS);
        this.f_96540_.add(this.list);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 80, this.f_96544_ - 27, 75, 20, (Component)new TextComponent("Customize"), button -> this.f_96541_.m_91152_((Screen)new MobsCustomizeSettingsScreen((Screen)this, this.f_96541_.f_91066_))));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ - 27, 75, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.f_96281_)));
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        this.list.m_6305_(matrices, mouseX, mouseY, delta);
        MobsSettingsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        List list = MobsSettingsScreen.m_96287_((OptionsList)this.list, (int)mouseX, (int)mouseY);
        if (list != null) {
            this.m_96617_(matrices, list, mouseX, mouseY);
        }
    }

    public static enum MobPhysicsType {
        OFF,
        FRACTURED,
        FRACTURED_BLOOD,
        BLOCKY,
        RAGDOLL;

    }
}

