/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.cloth;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Set;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.settings.cloth.BaseEntry;
import net.diebuddies.physics.settings.cloth.LabelEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class CapeCustomizationObjectSelectionList
extends ObjectSelectionList<BaseEntry> {
    private String cape;
    private Set<String> settings;
    private static final ResourceLocation REMOVE_TEXTURE = new ResourceLocation("physicsmod:textures/gui/remove.png");

    public CapeCustomizationObjectSelectionList(Minecraft minecraft, String cape, int width, int height, int top, int bottom, int itemHeight) {
        super(minecraft, width, height, top, bottom, itemHeight);
        this.cape = cape;
        this.settings = ConfigClient.getCapeSettings(cape);
        this.refreshEntries();
    }

    public void refreshEntries() {
        this.m_93516_();
        for (String name : this.settings) {
            LabelEntry entry = new LabelEntry((ObjectSelectionList)this, name);
            this.m_7085_((AbstractSelectionList.Entry)entry);
        }
    }

    public void addSetting(String setting) {
        this.settings.add(setting);
        this.refreshEntries();
    }

    public Set<String> getCapeSettings() {
        return this.settings;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float tickDelta) {
        super.m_6305_(poseStack, mouseX, mouseY, tickDelta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        return super.m_6375_(mouseX, mouseY, mouseButton) | this.listButtons(null, mouseX, mouseY, mouseButton, false);
    }

    public boolean listButtons(PoseStack poseStack, double mouseX, double mouseY, int mouseButton, boolean render) {
        boolean clicked = false;
        for (int i = 0; i < this.m_5773_(); ++i) {
            int entryY = this.m_7610_(i);
            int p = this.getRowBottomCustom(i);
            if (p < this.f_93390_ || entryY > this.f_93391_) continue;
            int entryHeight = this.f_93387_ - 4;
            BaseEntry entry = (BaseEntry)this.m_93500_(i);
            RemoveButton button = new RemoveButton(this.m_93520_() + 3, entryY, entryHeight, entryHeight - 1, (Component)new TextComponent(""), source -> {
                this.m_93502_((AbstractSelectionList.Entry)entry);
                this.settings.remove((String)entry.getUserData());
            });
            if (!render) {
                if (!button.m_6375_(mouseX, mouseY, mouseButton)) continue;
                return true;
            }
            button.m_6305_(poseStack, (int)mouseX, (int)mouseY, 0.0f);
        }
        return clicked;
    }

    protected void m_93451_(PoseStack poseStack, int x, int scrollAmount, int mouseX, int mouseY, float tickDelta) {
        super.m_93451_(poseStack, x, scrollAmount, mouseX, mouseY, tickDelta);
        this.listButtons(poseStack, mouseX, mouseY, 0, true);
    }

    private int getRowBottomCustom(int i) {
        return this.m_7610_(i) + this.f_93387_;
    }

    protected int m_5756_() {
        return this.f_93388_ - 20;
    }

    public int m_5747_() {
        return this.f_93393_ + this.f_93388_ / 2 - this.m_5759_() / 2 + 2;
    }

    public int m_5759_() {
        return 220;
    }

    public void setSelected(BaseEntry entry) {
        super.m_6987_((AbstractSelectionList.Entry)entry);
    }

    public class RemoveButton
    extends Button {
        public RemoveButton(int i, int j, int k, int l, Component component, Button.OnPress onPress) {
            super(i, j, k, l, component, onPress);
        }

        public void m_6305_(PoseStack poseStack, int i, int j, float f) {
            super.m_6305_(poseStack, i, j, f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)REMOVE_TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), (float)this.f_93620_, (float)(this.f_93621_ + 20 - 1), 100.0f).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), (float)(this.f_93620_ + 20), (float)(this.f_93621_ + 20 - 1), 100.0f).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), (float)(this.f_93620_ + 20), (float)(this.f_93621_ - 1), 100.0f).m_7421_(1.0f, 0.0f).m_5752_();
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), (float)this.f_93620_, (float)(this.f_93621_ - 1), 100.0f).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        }
    }
}

