/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.cloth;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.io.IOException;
import net.diebuddies.math.Math;
import net.diebuddies.model.ColladaMesh;
import net.diebuddies.model.ColladaParser;
import net.diebuddies.opengl.Texture;
import net.diebuddies.physics.DynamicsWorld;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.joml.Matrix4d;
import org.joml.Vector3d;

public class CapeDisplayScreen
extends Screen {
    private static final double ROTATE_SPEED = 6.0;
    private static final double START_ROTATE_SPEED = 30.0;
    private Screen parent;
    private VerletSimulation simulation;
    private Texture texture;
    private long lastTime;
    private double timeDelta;
    private static final double FIXED_TIME_STEP = 0.016666666666666666;
    private Vector3d capeMin;
    private Vector3d capeMax;
    private double rotationSpeed = 30.0;
    private int capeXPosition = 70;
    public Object selectedCape = null;

    protected CapeDisplayScreen(Screen parent, TextComponent component) {
        super((Component)component);
        this.parent = parent;
        this.lastTime = System.nanoTime();
    }

    public void loadCape() {
        if (this.selectedCape != null) {
            String file = (String)this.selectedCape;
            this.simulation = new VerletSimulation(new Vector3d(DynamicsWorld.DEFAULT_GRAVITY).negate(), 45, 0.93, new Vector3d(0.0));
            ColladaMesh mesh = ColladaParser.loadStaticModel(new File(PhysicsMod.CAPES_DIRECTORY + "/" + file));
            if (mesh == null) {
                return;
            }
            this.rotationSpeed = 30.0;
            this.simulation.addMesh(mesh, null, false);
            this.capeMin = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            this.capeMax = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
            for (int i = 0; i < this.simulation.getPoints().size(); ++i) {
                Vector3d position = this.simulation.getPoints().get((int)i).position;
                this.capeMin.min(position);
                this.capeMax.max(position);
            }
            try {
                if (this.texture != null) {
                    this.texture.destroy();
                }
                this.texture = Texture.load(PhysicsMod.CAPES_DIRECTORY + "/" + file.replace(".dae", ".png"), Texture.FILTER_MINECRAFT_TEXTURE);
                if (this.texture != null) {
                    this.simulation.textureID = this.texture.getID();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        PhysicsMod.createCapeDirectory();
        this.loadCape();
        this.m_142416_((GuiEventListener)new CustomButton(this.capeXPosition - 10, this.f_96544_ - 57, 20, 20, (Component)new TextComponent("?"), button -> {
            this.rotationSpeed = 30.0;
        }));
        this.m_142416_((GuiEventListener)new RotateButton(this.capeXPosition - 35, this.f_96544_ - 57, 20, 20, (Component)new TextComponent("<"), true));
        this.m_142416_((GuiEventListener)new RotateButton(this.capeXPosition + 15, this.f_96544_ - 57, 20, 20, (Component)new TextComponent(">"), false));
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        CapeDisplayScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)5, (int)0xFFFFFF);
        this.updateCape();
        this.renderCape();
        super.m_6305_(matrices, mouseX, mouseY, delta);
    }

    private void updateCape() {
        long time = System.nanoTime();
        double passedTime = (double)(System.nanoTime() - this.lastTime) / 1.0E9;
        this.lastTime = time;
        this.timeDelta += passedTime;
        while (this.timeDelta >= 0.016666666666666666) {
            this.timeDelta -= 0.016666666666666666;
            this.rotationSpeed = Math.lerp(this.rotationSpeed, 0.0, 0.06);
            if (this.simulation == null) continue;
            this.rotateCape();
            this.simulation.update(0.016666666666666666);
        }
    }

    private void rotateCape() {
        Matrix4d rotation = new Matrix4d();
        double capeHeight = this.capeMax.y - this.capeMin.y;
        double capeWidth = this.capeMax.x - this.capeMin.x;
        double capeDepth = this.capeMax.z - this.capeMin.z;
        rotation.translate(-capeWidth * 0.5 - this.capeMin.x, -capeHeight * 0.5 - this.capeMin.y, -capeDepth * 0.5 - this.capeMin.z);
        rotation.rotate(java.lang.Math.toRadians(this.rotationSpeed), new Vector3d(0.0, 1.0, 0.0));
        rotation.translate(capeWidth * 0.5 + this.capeMin.x, capeHeight * 0.5 + this.capeMin.y, capeDepth * 0.5 + this.capeMin.z);
        for (int i = 0; i < this.simulation.getPoints().size(); ++i) {
            VerletPoint point = this.simulation.getPoints().get(i);
            if (!point.locked) continue;
            rotation.transformPosition(point.position);
        }
    }

    private void renderCape() {
        int brightness;
        if (this.simulation == null || this.simulation.getQuads().size() == 0) {
            return;
        }
        float scale = 100.0f;
        PoseStack matrices = RenderSystem.m_157191_();
        double capeHeight = this.capeMax.y - this.capeMin.y;
        double capeWidth = this.capeMax.x - this.capeMin.x;
        double capeDepth = this.capeMax.z - this.capeMin.z;
        matrices.m_85836_();
        matrices.m_85837_((double)this.capeXPosition, (double)(this.f_96544_ / 2), 100.0);
        matrices.m_85841_(scale, scale, scale);
        matrices.m_85837_(-capeWidth * 0.5 - this.capeMin.x, -capeHeight * 0.5 - this.capeMin.y, -capeDepth * 0.5 - this.capeMin.z);
        RenderSystem.m_157182_();
        ShaderInstance shader = RenderSystem.m_157196_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172658_);
        RenderSystem.m_69482_();
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        int glID = this.simulation.textureID;
        Lighting.m_166384_();
        RenderSystem.m_69388_((int)33984);
        RenderSystem.m_157453_((int)0, (int)glID);
        RenderSystem.m_69396_((int)glID);
        RenderSystem.m_69464_();
        this.simulation.brightness = brightness = 0xF00000;
        this.simulation.render(matrices);
        matrices.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
        RenderSystem.m_157427_(() -> shader);
    }

    public void m_7379_() {
        if (this.texture != null) {
            this.texture.destroy();
        }
        this.f_96541_.m_91152_(this.parent);
    }

    public class CustomButton
    extends Button {
        public CustomButton(int x, int y, int width, int height, Component component, Button.OnPress onPress) {
            super(x, y, width, height, component, onPress);
        }

        public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 200.0);
            super.m_6303_(poseStack, mouseX, mouseY, partialTick);
            poseStack.m_85849_();
        }
    }

    public class RotateButton
    extends CustomButton {
        private boolean left;

        public RotateButton(int x, int y, int width, int height, Component component, boolean left) {
            super(x, y, width, height, component, button -> {});
            this.left = left;
        }

        @Override
        public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super.m_6303_(poseStack, mouseX, mouseY, partialTick);
            if (this.m_198029_()) {
                CapeDisplayScreen.this.rotationSpeed = this.left ? -6.0 : 6.0;
            }
        }
    }
}

