/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.cloth;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.settings.cloth.BaseEntry;
import net.diebuddies.physics.settings.cloth.CapeCustomizationScreen;
import net.diebuddies.physics.settings.cloth.LabelEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class CapeObjectSelectionList
extends ObjectSelectionList<BaseEntry> {
    private static final ResourceLocation CAPE_EDIT_TEXTURE = new ResourceLocation("physicsmod:textures/gui/cape_edit.png");

    public CapeObjectSelectionList(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
        super(minecraft, width, height, top, bottom, itemHeight);
        this.refreshEntries();
    }

    public void refreshEntries() {
        this.m_93516_();
        Path path = PhysicsMod.CAPES_DIRECTORY;
        try {
            Collection folders = Files.list(path).filter(CapeObjectSelectionList::isValidCape).collect(Collectors.toList());
            for (Path folder : folders) {
                String name = folder.getFileName().toString();
                LabelEntry entry = new LabelEntry((ObjectSelectionList)this, name);
                this.m_7085_((AbstractSelectionList.Entry)entry);
                if (!name.equalsIgnoreCase(ConfigClient.selectedPhysicsCape)) continue;
                this.setSelected(entry);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float tickDelta) {
        super.m_6305_(poseStack, mouseX, mouseY, tickDelta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        return super.m_6375_(mouseX, mouseY, mouseButton) | this.listButtons(null, mouseX, mouseY, mouseButton, false);
    }

    public boolean listButtons(PoseStack poseStack, double mouseX, double mouseY, int mouseButton, boolean render) {
        boolean clicked = false;
        int m = this.m_5773_();
        for (int index = 0; index < m; ++index) {
            int entryY = this.m_7610_(index);
            int p = this.getRowBottomCustom(index);
            if (p < this.f_93390_ || entryY > this.f_93391_) continue;
            int entryHeight = this.f_93387_ - 4;
            BaseEntry entry = (BaseEntry)this.m_93500_(index);
            CapeButton button = new CapeButton((String)entry.getUserData(), this.m_93520_() + 3, entryY, entryHeight, entryHeight - 1, (Component)new TextComponent(""), source -> Minecraft.m_91087_().m_91152_((Screen)new CapeCustomizationScreen(Minecraft.m_91087_().f_91080_, (String)entry.getUserData())));
            if (!render) {
                if (!button.m_6375_(mouseX, mouseY, mouseButton)) continue;
                return true;
            }
            button.m_6305_(poseStack, (int)mouseX, (int)mouseY, 0.0f);
        }
        return clicked;
    }

    protected void m_93451_(PoseStack poseStack, int x, int scrollAmount, int mouseX, int mouseY, float tickDelta) {
        super.m_93451_(poseStack, x, scrollAmount, mouseX, mouseY, tickDelta);
        this.listButtons(poseStack, mouseX, mouseY, 0, true);
    }

    private int getRowBottomCustom(int i) {
        return this.m_7610_(i) + this.f_93387_;
    }

    protected int m_5756_() {
        return this.f_93388_ - 20;
    }

    public int m_5747_() {
        return this.f_93393_ + this.f_93388_ / 2 - this.m_5759_() / 2 + 2;
    }

    public int m_5759_() {
        return 220;
    }

    public void setSelected(BaseEntry entry) {
        super.m_6987_((AbstractSelectionList.Entry)entry);
        ConfigClient.selectedPhysicsCape = (String)entry.getUserData();
        ConfigClient.save();
    }

    public static boolean isValidCape(Path file) {
        try {
            if (file.toFile().getName().endsWith("dae") && new File(file.toFile().getAbsolutePath().substring(0, file.toFile().getAbsolutePath().length() - 3).concat("png")).exists()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public class CapeButton
    extends Button {
        private String cape;

        public CapeButton(String cape, int i, int j, int k, int l, Component component, Button.OnPress onPress) {
            super(i, j, k, l, component, onPress);
            this.cape = cape;
        }

        public void m_6305_(PoseStack poseStack, int i, int j, float f) {
            super.m_6305_(poseStack, i, j, f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)CAPE_EDIT_TEXTURE);
            Set<String> settings = ConfigClient.getCapeSettings(this.cape);
            if (settings.contains("+ALL")) {
                RenderSystem.m_157429_((float)0.26f, (float)0.745f, (float)0.901f, (float)this.f_93625_);
            } else if (settings.size() > 0) {
                RenderSystem.m_157429_((float)0.537f, (float)0.901f, (float)0.26f, (float)this.f_93625_);
            } else {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            }
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), (float)this.f_93620_, (float)(this.f_93621_ + 20 - 1), 100.0f).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), (float)(this.f_93620_ + 20), (float)(this.f_93621_ + 20 - 1), 100.0f).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), (float)(this.f_93620_ + 20), (float)(this.f_93621_ - 1), 100.0f).m_7421_(1.0f, 0.0f).m_5752_();
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), (float)this.f_93620_, (float)(this.f_93621_ - 1), 100.0f).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        }
    }
}

