/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.cloth;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.concurrent.Executors;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.settings.cloth.CapeSelectionScreen;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.minecraft.Util;
import net.minecraft.client.CycleOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.ProgressOption;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;

public class ClothSettingsScreen
extends OptionsSubScreen {
    private static final CycleOption<Boolean> PHYSICS_CAPE = CycleOption.m_167743_((String)"Cape Physics", gameOptions -> ConfigClient.capePhysics, (gameOptions, option, value) -> {
        ConfigClient.capePhysics = value;
        ConfigClient.save();
        PhysicsMod.resetClothSimulations();
    });
    private static final CycleOption<Boolean> PHYSICS_FISHING_LINE = CycleOption.m_167743_((String)"Fishing Line Physics", gameOptions -> ConfigClient.fishingRodPhysics, (gameOptions, option, value) -> {
        ConfigClient.fishingRodPhysics = value;
        ConfigClient.save();
        PhysicsMod.resetClothSimulations();
    });
    private static final CycleOption<Boolean> PHYSICS_LEASH = CycleOption.m_167743_((String)"Leash Physics", gameOptions -> ConfigClient.leashPhysics, (gameOptions, option, value) -> {
        ConfigClient.leashPhysics = value;
        ConfigClient.save();
        PhysicsMod.resetClothSimulations();
    });
    private static final CycleOption<Boolean> PHYSICS_BANNER = CycleOption.m_167743_((String)"Banner Physics", gameOptions -> ConfigClient.bannerPhysics, (gameOptions, option, value) -> {
        ConfigClient.bannerPhysics = value;
        ConfigClient.save();
        PhysicsMod.resetClothSimulations();
    });
    private static final ProgressOption PHYSICS_BANNER_DISTANCE = new ProgressOption("Banner Distance", 5.0, 200.0, 0.1f, gameOptions -> ConfigClient.bannerPhysicsRange, (gameOptions, value) -> {
        ConfigClient.bannerPhysicsRange = value;
        ConfigClient.save();
    }, (gameOptions, option) -> new TextComponent("Banner Distance: " + String.format("%.2f", option.m_92221_(gameOptions))), minecraft -> {
        List list = minecraft.f_91062_.m_92923_((FormattedText)new TextComponent("The distance at which the banner physics switch back to default minecraft banners."), 200);
        return list;
    });
    private static final CycleOption<Boolean> PHYSICS_CLOTH_SMOOTH_SHADING = CycleOption.m_167743_((String)"Cloth Smooth Shading", gameOptions -> ConfigClient.clothSmoothShading, (gameOptions, option, value) -> {
        ConfigClient.clothSmoothShading = value;
        ConfigClient.save();
        PhysicsMod.resetClothSimulations();
    });
    private static final ProgressOption CPU_THREADS = new ProgressOption("Cloth CPU Threads", 1.0, (double)Runtime.getRuntime().availableProcessors(), 1.0f, gameOptions -> ConfigClient.clothThreads, (gameOptions, value) -> {
        ConfigClient.clothThreads = Math.max(value.intValue(), 1);
        ConfigClient.save();
        VerletSimulation.asynchronousWorker.shutdownNow();
        VerletSimulation.asynchronousWorker = Executors.newFixedThreadPool(ConfigClient.clothThreads);
    }, (gameOptions, option) -> new TextComponent("Cloth CPU Threads: " + (int)option.m_92221_(gameOptions)));
    private static final ProgressOption LEASH_LENGTH = new ProgressOption("Leash Length", 0.1, 30.0, 0.1f, gameOptions -> ConfigClient.leashLength, (gameOptions, value) -> {
        ConfigClient.leashLength = value;
        ConfigClient.save();
    }, (gameOptions, option) -> new TextComponent("Leash Length: " + String.format("%.2f", option.m_92221_(gameOptions))));
    private static final ProgressOption FISHING_LINE_LENGTH = new ProgressOption("Fishing Line Length", 0.1, 30.0, 0.1f, gameOptions -> ConfigClient.fishingLineLength, (gameOptions, value) -> {
        ConfigClient.fishingLineLength = value;
        ConfigClient.save();
    }, (gameOptions, option) -> new TextComponent("Fishing Line Length: " + String.format("%.2f", option.m_92221_(gameOptions))));
    private OptionsList list;

    public ClothSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)new TextComponent("Cloth Settings (PRO VERSION REQUIRED)"));
    }

    protected void m_7856_() {
        this.list = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.f_96540_.add(this.list);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 80, this.f_96544_ - 27, 75, 20, (Component)new TextComponent("Pro Version"), button -> Util.m_137581_().m_137646_("https://minecraftphysicsmod.com/pro")));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ - 27, 75, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.f_96281_)));
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        this.list.m_6305_(matrices, mouseX, mouseY, delta);
        ClothSettingsScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        List list = ClothSettingsScreen.m_96287_((OptionsList)this.list, (int)mouseX, (int)mouseY);
        if (list != null) {
            this.m_96617_(matrices, list, mouseX, mouseY);
        }
    }

    private static /* synthetic */ CycleButton.TooltipSupplier lambda$init$30(Minecraft minecraft) {
        List list = minecraft.f_91062_.m_92923_((FormattedText)new TextComponent("Enable/Disable your Mojang cape when cape physics are enabled"), 200);
        return graphicsStatus -> list;
    }

    private static /* synthetic */ void lambda$init$28(Options gameOptions, Option option, Boolean value) {
        ConfigClient.physicsModCape = value;
        ConfigClient.save();
        PhysicsMod.resetClothSimulations();
    }

    private static /* synthetic */ Boolean lambda$init$27(Options gameOptions) {
        return ConfigClient.physicsModCape;
    }

    private /* synthetic */ void lambda$init$26(Button button) {
        this.f_96541_.m_91152_(this.f_96281_);
    }

    private /* synthetic */ void lambda$init$25(Button button) {
        this.f_96541_.m_91152_((Screen)new CapeSelectionScreen((Screen)this));
    }
}

