/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.vines;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import net.diebuddies.config.ConfigVines;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.settings.cloth.BaseEntry;
import net.diebuddies.physics.settings.vines.BlockEntry;
import net.diebuddies.physics.settings.vines.VineEditScreen;
import net.diebuddies.physics.vines.DynamicSetting;
import net.diebuddies.physics.vines.VineHelper;
import net.diebuddies.physics.vines.VineSetting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class VineObjectSelectionList
extends ObjectSelectionList<BaseEntry> {
    private Map<Block, DynamicSetting> settings = ConfigVines.configSettings;
    private static final ResourceLocation REMOVE_TEXTURE = new ResourceLocation("physicsmod:textures/gui/remove.png");
    private static final ResourceLocation EDIT_TEXTURE = new ResourceLocation("physicsmod:textures/gui/edit.png");

    public VineObjectSelectionList(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
        super(minecraft, width, height, top, bottom, itemHeight);
        this.refreshEntries();
    }

    public void refreshEntries() {
        this.m_93516_();
        for (Block block : this.settings.keySet()) {
            String id = PhysicsMod.registeredBlocks.get(block);
            if (id == null) continue;
            BlockEntry entry = new BlockEntry(this, id, block);
            this.m_7085_((AbstractSelectionList.Entry)entry);
        }
    }

    public void addSetting(Block block, VineSetting setting) {
        this.settings.put(block, setting);
        this.refreshEntries();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float tickDelta) {
        super.m_6305_(poseStack, mouseX, mouseY, tickDelta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        return super.m_6375_(mouseX, mouseY, mouseButton) | this.listButtons(null, mouseX, mouseY, mouseButton, false);
    }

    public boolean listButtons(PoseStack poseStack, double mouseX, double mouseY, int mouseButton, boolean render) {
        boolean clicked = false;
        for (int i = 0; i < this.m_5773_(); ++i) {
            int entryY = this.m_7610_(i);
            int p = this.getRowBottomCustom(i);
            if (p < this.f_93390_ || entryY > this.f_93391_) continue;
            int entryHeight = this.f_93387_ - 4;
            BaseEntry entry = (BaseEntry)this.m_93500_(i);
            EditButton editButton = new EditButton(this.m_93520_() + 3, entryY, entryHeight, entryHeight - 1, (Component)new TextComponent(""), source -> {
                Block block = (Block)((BlockEntry)entry).getUserData();
                if (block != null) {
                    this.f_93386_.m_91152_((Screen)new VineEditScreen(this.f_93386_.f_91080_, this.f_93386_.f_91066_, this.settings.get(block), block));
                }
            });
            RemoveButton removeButton = new RemoveButton(this.m_93520_() + 26, entryY, entryHeight, entryHeight - 1, (Component)new TextComponent(""), source -> {
                this.m_93502_((AbstractSelectionList.Entry)entry);
                this.settings.remove((Block)entry.getUserData());
                ConfigVines.save();
                VineHelper.initFromConfigSettings();
            });
            if (!render) {
                if (editButton.m_6375_(mouseX, mouseY, mouseButton)) {
                    return true;
                }
                if (!removeButton.m_6375_(mouseX, mouseY, mouseButton)) continue;
                return true;
            }
            removeButton.m_6305_(poseStack, (int)mouseX, (int)mouseY, 0.0f);
            editButton.m_6305_(poseStack, (int)mouseX, (int)mouseY, 0.0f);
        }
        return clicked;
    }

    protected void m_93451_(PoseStack poseStack, int x, int scrollAmount, int mouseX, int mouseY, float tickDelta) {
        super.m_93451_(poseStack, x, scrollAmount, mouseX, mouseY, tickDelta);
        this.listButtons(poseStack, mouseX, mouseY, 0, true);
    }

    private int getRowBottomCustom(int i) {
        return this.m_7610_(i) + this.f_93387_;
    }

    protected int m_5756_() {
        return this.f_93388_ - 20;
    }

    public int m_5747_() {
        return this.f_93393_ + this.f_93388_ / 2 - this.m_5759_() / 2 + 2;
    }

    public int m_5759_() {
        return 220;
    }

    public void setSelected(BaseEntry entry) {
        super.m_6987_((AbstractSelectionList.Entry)entry);
    }

    public class EditButton
    extends FunctionButton {
        public EditButton(int i, int j, int k, int l, Component component, Button.OnPress onPress) {
            super(i, j, k, l, component, onPress);
            this.texture = EDIT_TEXTURE;
        }
    }

    public class RemoveButton
    extends FunctionButton {
        public RemoveButton(int i, int j, int k, int l, Component component, Button.OnPress onPress) {
            super(i, j, k, l, component, onPress);
            this.texture = REMOVE_TEXTURE;
        }
    }

    public class FunctionButton
    extends Button {
        protected ResourceLocation texture;

        public FunctionButton(int i, int j, int k, int l, Component component, Button.OnPress onPress) {
            super(i, j, k, l, component, onPress);
        }

        public void m_6305_(PoseStack poseStack, int i, int j, float f) {
            super.m_6305_(poseStack, i, j, f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), (float)this.f_93620_, (float)(this.f_93621_ + 20 - 1), 100.0f).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), (float)(this.f_93620_ + 20), (float)(this.f_93621_ + 20 - 1), 100.0f).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), (float)(this.f_93620_ + 20), (float)(this.f_93621_ - 1), 100.0f).m_7421_(1.0f, 0.0f).m_5752_();
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), (float)this.f_93620_, (float)(this.f_93621_ - 1), 100.0f).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        }
    }
}

