/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.sound;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import org.joml.Vector3d;
import physx.common.PxVec3;
import physx.physics.JavaSimulationEventCallback;
import physx.physics.PxContactPair;
import physx.physics.PxContactPairHeader;
import physx.physics.PxContactPairPoint;
import physx.physics.PxPairFlagEnum;
import physx.physics.PxPairFlags;
import physx.physics.PxRigidActor;
import physx.support.TypeHelpers;
import physx.support.Vector_PxContactPairPoint;

public class ContactSimulationCallback
extends JavaSimulationEventCallback {
    public static final float FORCE_THRESHOLD = 0.25f;
    public static final int REPORT_CONTACT_FLAGS = PxPairFlagEnum.eNOTIFY_THRESHOLD_FORCE_FOUND | PxPairFlagEnum.eNOTIFY_CONTACT_POINTS;
    public static final long OBJECT_SOUND_DELAY = 500000000L;
    public static final int MAX_SOUNDS_PER_TICK = 1;
    private Level level;
    private Vector_PxContactPairPoint contacts = new Vector_PxContactPairPoint(64);
    public int soundCount;

    public ContactSimulationCallback(Level level) {
        this.level = level;
    }

    @Override
    public void onContact(PxContactPairHeader pairHeader, PxContactPair pairs, int nbPairs) {
        super.onContact(pairHeader, pairs, nbPairs);
        if (this.soundCount >= 1 || !ConfigClient.impactSounds) {
            return;
        }
        PxRigidActor actor0 = pairHeader.getActors(0);
        PxRigidActor actor1 = pairHeader.getActors(1);
        for (int i = 0; i < nbPairs; ++i) {
            IRigidBody body1;
            PxContactPair pair = TypeHelpers.getContactPairAt(pairs, i);
            PxPairFlags events = pair.getEvents();
            if (!events.isSet(PxPairFlagEnum.eNOTIFY_THRESHOLD_FORCE_FOUND)) continue;
            double largestImpulse = 0.0;
            PxVec3 impulsePos = null;
            int contactPoints = pair.extractContacts(this.contacts.data(), 64);
            for (int j = 0; j < contactPoints; ++j) {
                double z;
                double y;
                PxContactPairPoint cp = this.contacts.at(j);
                PxVec3 impulse = cp.getImpulse();
                PxVec3 position = cp.getPosition();
                double x = impulse.getX();
                double impulseMagnitude = x * x + (y = (double)impulse.getY()) * y + (z = (double)impulse.getZ()) * z;
                if (!(largestImpulse < impulseMagnitude)) continue;
                largestImpulse = impulseMagnitude;
                impulsePos = position;
            }
            double volume = Math.remapClamp(largestImpulse, 2.0E-5, 0.0015, 0.0, 1.0) * (double)ConfigClient.soundVolume;
            if (volume <= 0.0) continue;
            PhysicsMod mod = PhysicsMod.getInstance(this.level);
            long time = mod.time;
            PhysicsWorld physics = mod.getPhysicsWorld();
            IRigidBody body0 = physics.getBody(actor0);
            SoundType sound = null;
            if (body0 != null && body0.getEntity().lastSoundTime > 500000000L) {
                sound = body0.getEntity().sound;
                body0.getEntity().lastSoundTime = time;
            }
            if ((body1 = physics.getBody(actor1)) != null && time - body1.getEntity().lastSoundTime > 500000000L) {
                if (sound == null) {
                    sound = body1.getEntity().sound;
                }
                body1.getEntity().lastSoundTime = time;
            }
            if (sound == null) continue;
            Vector3d offset = physics.getOffset();
            SoundEvent soundEvent = sound.m_56778_();
            if (soundEvent == null) continue;
            float pitch = 0.85f * (float)java.lang.Math.random() * 0.3f;
            this.level.m_7785_((double)impulsePos.getX() + offset.x, (double)impulsePos.getY() + offset.y, (double)impulsePos.getZ() + offset.z, soundEvent, SoundSource.BLOCKS, (float)volume, pitch, true);
            ++this.soundCount;
        }
    }

    private String vec3ToString(PxVec3 position) {
        return position.getX() + ", " + position.getY() + ", " + position.getZ();
    }
}

