/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet;

import org.joml.Vector3d;

public class VerletHelper {
    private double[] dist = new double[6];

    public boolean movePointOutOfBox(Vector3d point, float preferUpMovement, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (point.x > (double)minX && point.x < (double)maxX && point.y > (double)minY && point.y < (double)maxY && point.z > (double)minZ && point.z < (double)maxZ) {
            this.dist[0] = point.x - (double)minX;
            this.dist[1] = (double)maxX - point.x;
            this.dist[2] = point.y - (double)minY;
            this.dist[3] = ((double)maxY - point.y) * (double)preferUpMovement;
            this.dist[4] = point.z - (double)minZ;
            this.dist[5] = (double)maxZ - point.z;
            double smallest = this.dist[0];
            int index = 0;
            for (int i = 1; i < this.dist.length; ++i) {
                if (!(this.dist[i] < smallest)) continue;
                smallest = this.dist[i];
                index = i;
            }
            if (index == 0) {
                point.x = minX;
            } else if (index == 1) {
                point.x = maxX;
            } else if (index == 2) {
                point.y = minY;
            } else if (index == 3) {
                point.y = maxY;
            } else if (index == 4) {
                point.z = minZ;
            } else if (index == 5) {
                point.z = maxZ;
            }
            return true;
        }
        return false;
    }

    public boolean movePointOutOfBox(Vector3d point, double preferUpMovement, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (point.x > minX && point.x < maxX && point.y > minY && point.y < maxY && point.z > minZ && point.z < maxZ) {
            this.dist[0] = point.x - minX;
            this.dist[1] = maxX - point.x;
            this.dist[2] = point.y - minY;
            this.dist[3] = (maxY - point.y) * preferUpMovement;
            this.dist[4] = point.z - minZ;
            this.dist[5] = maxZ - point.z;
            double smallest = this.dist[0];
            int index = 0;
            for (int i = 1; i < this.dist.length; ++i) {
                if (!(this.dist[i] < smallest)) continue;
                smallest = this.dist[i];
                index = i;
            }
            if (index == 0) {
                point.x = minX;
            } else if (index == 1) {
                point.x = maxX;
            } else if (index == 2) {
                point.y = minY;
            } else if (index == 3) {
                point.y = maxY;
            } else if (index == 4) {
                point.z = minZ;
            } else if (index == 5) {
                point.z = maxZ;
            }
            return true;
        }
        return false;
    }

    public boolean movePointOutOfBox(Vector3d point, double preferUpMovement, double offset, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (point.x > minX && point.x < maxX && point.y > minY && point.y < maxY && point.z > minZ && point.z < maxZ) {
            this.dist[0] = point.x - minX;
            this.dist[1] = maxX - point.x;
            this.dist[2] = point.y - minY;
            this.dist[3] = (maxY - point.y) * preferUpMovement;
            this.dist[4] = point.z - minZ;
            this.dist[5] = maxZ - point.z;
            double smallest = this.dist[0];
            int index = 0;
            for (int i = 1; i < this.dist.length; ++i) {
                if (!(this.dist[i] < smallest)) continue;
                smallest = this.dist[i];
                index = i;
            }
            if (index == 0) {
                point.x = minX - offset;
            } else if (index == 1) {
                point.x = maxX + offset;
            } else if (index == 2) {
                point.y = minY - offset;
            } else if (index == 3) {
                point.y = maxY + offset;
            } else if (index == 4) {
                point.z = minZ - offset;
            } else if (index == 5) {
                point.z = maxZ + offset;
            }
            return true;
        }
        return false;
    }

    public boolean movePointOutOfBox(Vector3d point, Vector3d prevPoint, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (point.x > (double)minX && point.x < (double)maxX && point.y > (double)minY && point.y < (double)maxY && point.z > (double)minZ && point.z < (double)maxZ) {
            double dz;
            this.dist[0] = point.x - (double)minX;
            this.dist[1] = (double)maxX - point.x;
            this.dist[2] = point.y - (double)minY;
            this.dist[3] = (double)maxY - point.y;
            this.dist[4] = point.z - (double)minZ;
            this.dist[5] = (double)maxZ - point.z;
            double dx = this.dist[0] < this.dist[1] ? (double)minX : (double)maxX;
            double dy = this.dist[2] < this.dist[3] ? (double)minY : (double)maxY;
            double d = dz = this.dist[4] < this.dist[5] ? (double)minZ : (double)maxZ;
            if (Math.abs(dx - prevPoint.x) < Math.abs(point.x - prevPoint.x)) {
                point.x = dx;
            }
            if (Math.abs(dy - prevPoint.y) < Math.abs(point.y - prevPoint.y)) {
                point.y = dy;
            }
            if (Math.abs(dz - prevPoint.z) < Math.abs(point.z - prevPoint.z)) {
                point.z = dz;
            }
            return true;
        }
        return false;
    }

    public boolean movePointOutOfBoxFastZ(Vector3d point, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (point.x > (double)minX && point.x < (double)maxX && point.y > (double)minY && point.y < (double)maxY && point.z > (double)minZ && point.z < (double)maxZ) {
            this.dist[0] = point.x - (double)minX;
            this.dist[1] = (double)maxX - point.x;
            this.dist[2] = point.y - (double)minY;
            this.dist[3] = (double)maxY - point.y;
            this.dist[4] = point.z - (double)minZ;
            this.dist[5] = (double)maxZ - point.z;
            double smallest = this.dist[0];
            int index = 0;
            for (int i = 1; i < this.dist.length; ++i) {
                if (!(this.dist[i] < smallest)) continue;
                smallest = this.dist[i];
                index = i;
            }
            if (index == 4) {
                index = 5;
            }
            if (index == 0) {
                point.x -= this.dist[index];
            } else if (index == 1) {
                point.x += this.dist[index];
            } else if (index == 2) {
                point.y -= this.dist[index];
            } else if (index == 3) {
                point.y += this.dist[index];
            } else if (index == 4) {
                point.z -= this.dist[index];
            } else if (index == 5) {
                point.z += this.dist[index];
            }
            return true;
        }
        return false;
    }

    public boolean movePointOutOfBoxInvFastZ(Vector3d point, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (point.x > (double)minX && point.x < (double)maxX && point.y > (double)minY && point.y < (double)maxY && point.z > (double)minZ && point.z < (double)maxZ) {
            this.dist[0] = point.x - (double)minX;
            this.dist[1] = (double)maxX - point.x;
            this.dist[2] = point.y - (double)minY;
            this.dist[3] = (double)maxY - point.y;
            this.dist[4] = point.z - (double)minZ;
            this.dist[5] = (double)maxZ - point.z;
            double smallest = this.dist[0];
            int index = 0;
            for (int i = 1; i < this.dist.length; ++i) {
                if (!(this.dist[i] < smallest)) continue;
                smallest = this.dist[i];
                index = i;
            }
            if (index == 5) {
                index = 4;
            }
            if (index == 0) {
                point.x -= this.dist[index];
            } else if (index == 1) {
                point.x += this.dist[index];
            } else if (index == 2) {
                point.y -= this.dist[index];
            } else if (index == 3) {
                point.y += this.dist[index];
            } else if (index == 4) {
                point.z -= this.dist[index];
            } else if (index == 5) {
                point.z += this.dist[index];
            }
            return true;
        }
        return false;
    }
}

