/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.verlet.VerletHelper;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletQuad;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.VerletStick;
import net.diebuddies.physics.verlet.constraints.RenderConstraint;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4d;
import org.joml.Vector2f;
import org.joml.Vector3d;

public class BannerConstraint
implements VerletConstraint {
    private ModelPart[] partsToCheck;
    private PartPose[] modelPoses;
    private BannerBlockEntity bannerBlock;
    private Matrix4d transformation = new Matrix4d();
    private Matrix4d invTransformation = new Matrix4d();
    private VerletHelper helper = new VerletHelper();
    private Vector3d invPoint = new Vector3d();
    private static Vector3d[] tmp;
    private Vector2f[] tmpUV;

    public BannerConstraint(VerletSimulation simulation, BannerBlockEntity bannerBlock, ModelPart pole, ModelPart bar, float tickDelta) {
        int i;
        this.bannerBlock = bannerBlock;
        List<VerletConstraint> constraints = simulation.getConstraints();
        for (int i2 = 0; i2 < constraints.size(); ++i2) {
            if (!(constraints.get(i2) instanceof RenderConstraint)) continue;
            constraints.remove(i2--);
        }
        this.partsToCheck = bannerBlock.m_58900_().m_60734_() instanceof BannerBlock ? new ModelPart[]{pole, bar} : new ModelPart[]{bar};
        this.modelPoses = new PartPose[this.partsToCheck.length];
        this.calculateTransformation(simulation, tickDelta);
        int capeXPoints = 9;
        int capeYPoints = 17;
        double distance = 0.15000000001500002;
        VerletPoint[][] points = new VerletPoint[capeXPoints][capeYPoints];
        float uvXOff = 0.015625f;
        float uvYOff = 0.015625f;
        float uvXMod = 0.3125f;
        float uvYMod = 0.625f;
        for (int y = 0; y < points[0].length; ++y) {
            for (int x = 0; x < points.length; ++x) {
                Vector3d position = new Vector3d((double)x * distance - (double)capeXPoints * 0.5 * distance + distance * 0.5, (double)y * distance, -0.08928571428571429);
                this.transformation.transformPosition(position);
                VerletPoint point = new VerletPoint(position);
                point.uv.set((float)x / (float)(points.length - 1) * uvXMod + uvXOff, (float)y / (float)(points[0].length - 1) * uvYMod + uvYOff);
                if (y == 0) {
                    point.locked = true;
                }
                points[x][y] = point;
                simulation.addPoint(points[x][y]);
            }
        }
        for (int x = 0; x < points.length; ++x) {
            for (int y = 0; y < points[0].length; ++y) {
                if (x < points.length - 1) {
                    simulation.addStick(new VerletStick(points[x][y], points[x + 1][y]));
                }
                if (y < points[0].length - 1) {
                    simulation.addStick(new VerletStick(points[x][y], points[x][y + 1]));
                }
                if (x >= points.length - 1 || y >= points[0].length - 1) continue;
                simulation.addQuad(new VerletQuad(points[x][y + 1], points[x + 1][y + 1], points[x + 1][y], points[x][y]));
                simulation.addStick(new VerletStick(points[x][y], points[x + 1][y + 1]));
                simulation.addStick(new VerletStick(points[x + 1][y], points[x][y + 1]));
            }
        }
        simulation.calculateNormals();
        simulation.downloadData();
        this.calculateTransformation(simulation, tickDelta);
        List usedPatterns = bannerBlock.m_58508_();
        List<VerletQuad> quads = simulation.getQuads();
        int drawCalls = java.lang.Math.min(17, usedPatterns.size());
        int size = quads.size();
        this.tmpUV = new Vector2f[drawCalls * size * 4];
        for (i = 0; i < this.tmpUV.length; ++i) {
            this.tmpUV[i] = new Vector2f();
        }
        if (tmp == null) {
            tmp = new Vector3d[size * 4];
            for (i = 0; i < tmp.length; ++i) {
                BannerConstraint.tmp[i] = new Vector3d();
            }
        }
        for (i = 0; i < 17 && i < usedPatterns.size(); ++i) {
            Pair pair = (Pair)usedPatterns.get(i);
            BannerPattern bannerPattern = (BannerPattern)pair.getFirst();
            Material bannerMaterial = Sheets.m_173379_((BannerPattern)bannerPattern);
            TextureAtlasSprite sprite = bannerMaterial.m_119204_();
            float minU = sprite.m_118409_();
            float maxU = sprite.m_118410_();
            float minV = sprite.m_118411_();
            float maxV = sprite.m_118412_();
            for (int j = 0; j < quads.size(); ++j) {
                VerletQuad quad = quads.get(j);
                this.remap(quad.point1.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4]);
                this.remap(quad.point2.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4 + 1]);
                this.remap(quad.point3.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4 + 2]);
                this.remap(quad.point4.uv, minU, maxU, minV, maxV, this.tmpUV[size * i * 4 + j * 4 + 3]);
            }
        }
    }

    private void calculateTransformation(VerletSimulation simulation, float tickDelta) {
        PoseStack worldPose = new PoseStack();
        BlockState blockState = this.bannerBlock.m_58900_();
        BlockPos blockPos = this.bannerBlock.m_58899_();
        Vector3d offset = simulation.getOffset();
        if (offset != null) {
            worldPose.m_85837_((double)blockPos.m_123341_() - offset.x, (double)blockPos.m_123342_() - offset.y, (double)blockPos.m_123343_() - offset.z);
        } else {
            worldPose.m_85837_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        }
        if (blockState.m_60734_() instanceof BannerBlock) {
            worldPose.m_85837_(0.5, 0.5, 0.5);
            blockRotation = (float)(-((Integer)blockState.m_61143_((Property)BannerBlock.f_49007_)).intValue() * 360) / 16.0f;
            worldPose.m_85845_(Vector3f.f_122225_.m_122240_(blockRotation));
        } else {
            worldPose.m_85837_(0.5, -0.1666666716337204, 0.5);
            blockRotation = -((Direction)blockState.m_61143_((Property)WallBannerBlock.f_57916_)).m_122435_();
            worldPose.m_85845_(Vector3f.f_122225_.m_122240_(blockRotation));
            worldPose.m_85837_(0.0, -0.3125, -0.4375);
        }
        worldPose.m_85841_(0.6666667f, -0.6666667f, -0.6666667f);
        if (simulation.getOffset() == null) {
            long gameTime = this.bannerBlock.m_58904_().m_46467_();
            float n = ((float)java.lang.Math.floorMod((long)(blockPos.m_123341_() * 7 + blockPos.m_123342_() * 9 + blockPos.m_123343_() * 13) + gameTime, 100L) + tickDelta) / 100.0f;
            float xRot = (-0.0125f + 0.01f * Mth.m_14089_((float)((float)java.lang.Math.PI * 2 * n))) * (float)java.lang.Math.PI;
            double yPos = -32.0;
            worldPose.m_85837_(0.0, yPos / 16.0, 0.0);
            if (xRot != 0.0f) {
                worldPose.m_85845_(Vector3f.f_122223_.m_122270_(xRot));
            }
        }
        StarterClient.setMatrix(this.transformation, worldPose.m_85850_().m_85861_());
        this.transformation.invert(this.invTransformation);
    }

    @Override
    public boolean initAsyncData(VerletSimulation simulation) {
        for (int i = 0; i < this.modelPoses.length; ++i) {
            this.modelPoses[i] = this.partsToCheck[i].m_171308_();
        }
        return false;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
    }

    public void translateAndRotate(PoseStack poseStack, PartPose pose) {
        poseStack.m_85837_((double)(pose.f_171405_ / 16.0f), (double)(pose.f_171406_ / 16.0f), (double)(pose.f_171407_ / 16.0f));
        if (pose.f_171410_ != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122270_(pose.f_171410_));
        }
        if (pose.f_171409_ != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122270_(pose.f_171409_));
        }
        if (pose.f_171408_ != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122270_(pose.f_171408_));
        }
    }

    @Override
    public void renderBefore(PoseStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderAfter(PoseStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void render(PoseStack matrixStack, double renderPercent, VerletSimulation simulation) {
        List usedPatterns = this.bannerBlock.m_58508_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        int brightness = simulation.brightness;
        List<VerletQuad> quads = simulation.getQuads();
        int size = quads.size();
        if (simulation.getQuads().size() > 0) {
            for (int j = 0; j < quads.size(); ++j) {
                VerletQuad quad = quads.get(j);
                int multiple = j * 4;
                quad.point1.bufferPrevPosition.lerp(quad.point1.bufferPosition, renderPercent, tmp[multiple]);
                quad.point2.bufferPrevPosition.lerp(quad.point2.bufferPosition, renderPercent, tmp[multiple + 1]);
                quad.point3.bufferPrevPosition.lerp(quad.point3.bufferPosition, renderPercent, tmp[multiple + 2]);
                quad.point4.bufferPrevPosition.lerp(quad.point4.bufferPosition, renderPercent, tmp[multiple + 3]);
            }
            for (int i = 0; i < 17 && i < usedPatterns.size(); ++i) {
                Pair pair = (Pair)usedPatterns.get(i);
                float[] color = ((DyeColor)pair.getSecond()).m_41068_();
                BannerPattern bannerPattern = (BannerPattern)pair.getFirst();
                Material bannerMaterial = Sheets.m_173379_((BannerPattern)bannerPattern);
                bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85812_);
                TextureAtlasSprite sprite = bannerMaterial.m_119204_();
                int glID = sprite.m_118414_().m_117963_();
                RenderSystem.m_157453_((int)0, (int)glID);
                RenderSystem.m_69396_((int)glID);
                int drawCallIndex = i * size * 4;
                for (int j = 0; j < quads.size(); ++j) {
                    VerletQuad quad = quads.get(j);
                    int multiple = j * 4;
                    int uvIndex = drawCallIndex + multiple;
                    if (ConfigClient.clothSmoothShading) {
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, tmp[multiple + 3], this.tmpUV[uvIndex + 3], quad.point4.bufferNormal, brightness, color);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, tmp[multiple + 2], this.tmpUV[uvIndex + 2], quad.point3.bufferNormal, brightness, color);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, tmp[multiple + 1], this.tmpUV[uvIndex + 1], quad.point2.bufferNormal, brightness, color);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, tmp[multiple], this.tmpUV[uvIndex], quad.point1.bufferNormal, brightness, color);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, tmp[multiple + 3], this.tmpUV[uvIndex + 3], quad.point4.bufferNormal, brightness, color);
                        this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, tmp[multiple + 1], this.tmpUV[uvIndex + 1], quad.point2.bufferNormal, brightness, color);
                        continue;
                    }
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, tmp[multiple + 3], this.tmpUV[uvIndex + 3], quad.point1.bufferNormal, brightness, color);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, tmp[multiple + 2], this.tmpUV[uvIndex + 2], quad.point1.bufferNormal, brightness, color);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, tmp[multiple + 1], this.tmpUV[uvIndex + 1], quad.point1.bufferNormal, brightness, color);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, tmp[multiple], this.tmpUV[uvIndex], quad.point1.bufferNormal, brightness, color);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, tmp[multiple + 3], this.tmpUV[uvIndex + 3], quad.point1.bufferNormal, brightness, color);
                    this.bufferVertex((VertexConsumer)bufferbuilder, renderPercent, tmp[multiple + 1], this.tmpUV[uvIndex + 1], quad.point1.bufferNormal, brightness, color);
                }
                tesselator.m_85914_();
            }
        }
    }

    private void remap(Vector2f uv, float minU, float maxU, float minV, float maxV, Vector2f dst) {
        dst.set(Math.remap(uv.x, 0.0f, 1.0f, minU, maxU), Math.remap(uv.y, 0.0f, 1.0f, minV, maxV));
    }

    private void bufferVertex(VertexConsumer bufferbuilder, double renderPercent, Vector3d position, Vector2f uv, Vector3d normal, int brightness, float[] color) {
        bufferbuilder.m_5954_((float)position.x, (float)position.y, (float)position.z, color[0], color[1], color[2], 1.0f, uv.x, uv.y, 0, brightness, (float)normal.x, (float)normal.y, (float)normal.z);
    }
}

