/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.lang.reflect.InvocationTargetException;
import net.diebuddies.bridge.ReflectionsForge;
import net.diebuddies.physics.verlet.VerletHelper;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4d;
import org.joml.Vector3d;

public class ClosestPlayerConstraint
implements VerletConstraint {
    private Player player;
    private Level level;
    private PlayerModel<Player> model;
    private PartPose[] modelPoses = new PartPose[6];
    private ModelPart[] partsToCheck = new ModelPart[6];
    private VerletHelper helper = new VerletHelper();
    private Vector3d invPoint = new Vector3d();
    private Matrix4d transform = new Matrix4d();
    private Matrix4d invTransform = new Matrix4d();
    private PoseStack modelMatrix = new PoseStack();

    public ClosestPlayerConstraint(Level level) {
        this.level = level;
    }

    @Override
    public boolean initAsyncData(VerletSimulation simulation) {
        Vector3d offset = simulation.getOffset();
        double px = offset.x;
        double py = offset.y;
        double pz = offset.z;
        if (simulation.getPoints().size() > 0) {
            Vector3d pos = simulation.getPoints().get((int)0).position;
            px += pos.x;
            py += pos.y;
            pz += pos.z;
        }
        this.player = this.level.m_45924_(px, py, pz, 10.0, false);
        this.modelMatrix.m_85836_();
        if (this.player != null) {
            LivingEntityRenderer renderer = (LivingEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)this.player);
            this.model = (PlayerModel)renderer.m_7200_();
            this.partsToCheck[0] = this.model.f_102809_;
            this.partsToCheck[1] = this.model.f_102810_;
            this.partsToCheck[2] = this.model.f_102811_;
            this.partsToCheck[3] = this.model.f_102812_;
            this.partsToCheck[4] = this.model.f_102813_;
            this.partsToCheck[5] = this.model.f_102814_;
            for (int i = 0; i < this.modelPoses.length; ++i) {
                this.modelPoses[i] = this.partsToCheck[i].m_171308_();
            }
            this.setupModelAnimations(1.0f);
            this.playerTransformation(this.modelMatrix, simulation, this.player, 1.0f, 1.0f, false);
        }
        return false;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
        if (this.player != null) {
            this.doCollisionCheck(this.modelMatrix, simulation);
        }
        this.modelMatrix.m_85849_();
    }

    private void playerTransformation(PoseStack modelMatrix, VerletSimulation simulation, Player player, float tickDelta, float animationProgress, boolean doCollision) {
        Direction direction;
        LivingEntityRenderer renderer = (LivingEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)player);
        double px = Mth.m_14139_((double)tickDelta, (double)player.f_19790_, (double)player.m_20185_());
        double py = Mth.m_14139_((double)tickDelta, (double)player.f_19791_, (double)player.m_20186_());
        double pz = Mth.m_14139_((double)tickDelta, (double)player.f_19792_, (double)player.m_20189_());
        Vec3 positionOffset = renderer.m_7860_((Entity)player, tickDelta);
        modelMatrix.m_85837_(positionOffset.f_82479_ + (px -= simulation.getOffset().x), positionOffset.f_82480_ + (py -= simulation.getOffset().y), positionOffset.f_82481_ + (pz -= simulation.getOffset().z));
        float yaw = Mth.m_14189_((float)tickDelta, (float)player.f_20884_, (float)player.f_20883_);
        if (player.m_20089_() == Pose.SLEEPING && (direction = player.m_21259_()) != null) {
            float eyeHeight = player.m_20236_(Pose.STANDING) - 0.1f;
            modelMatrix.m_85837_((double)((float)(-direction.m_122429_()) * eyeHeight), 0.0, (double)((float)(-direction.m_122431_()) * eyeHeight));
        }
        try {
            ReflectionsForge.setupRotations.invoke((Object)renderer, player, modelMatrix, Float.valueOf(animationProgress), Float.valueOf(yaw), Float.valueOf(tickDelta));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        modelMatrix.m_85841_(-1.0f, -1.0f, 1.0f);
        modelMatrix.m_85841_(0.9375f, 0.9375f, 0.9375f);
        modelMatrix.m_85837_(0.0, (double)-1.501f, 0.0);
        if (simulation != null && doCollision) {
            this.doCollisionCheck(modelMatrix, simulation);
        }
    }

    private void doCollisionCheck(PoseStack modelMatrix, VerletSimulation simulation) {
    }

    private void setupModelAnimations(float tickDelta) {
        Direction direction;
        float o;
        float h = Mth.m_14189_((float)tickDelta, (float)this.player.f_20884_, (float)this.player.f_20883_);
        float j = Mth.m_14189_((float)tickDelta, (float)this.player.f_20886_, (float)this.player.f_20885_);
        float k = j - h;
        if (this.player.m_20159_() && this.player.m_20202_() instanceof LivingEntity) {
            LivingEntity livingEntity2 = (LivingEntity)this.player.m_20202_();
            h = Mth.m_14189_((float)tickDelta, (float)livingEntity2.f_20884_, (float)livingEntity2.f_20883_);
            k = j - h;
            o = Mth.m_14177_((float)k);
            if (o < -85.0f) {
                o = -85.0f;
            }
            if (o >= 85.0f) {
                o = 85.0f;
            }
            h = j - o;
            if (o * o > 2500.0f) {
                h += o * 0.2f;
            }
            k = j - h;
        }
        float m = Mth.m_14179_((float)tickDelta, (float)this.player.f_19860_, (float)this.player.m_146909_());
        if (this.player.m_20089_() == Pose.SLEEPING && (direction = this.player.m_21259_()) != null) {
            float f = this.player.m_20236_(Pose.STANDING) - 0.1f;
        }
        o = tickDelta;
        float p = 0.0f;
        float q = 0.0f;
        if (!this.player.m_20159_() && this.player.m_6084_()) {
            p = Mth.m_14179_((float)tickDelta, (float)this.player.f_20923_, (float)this.player.f_20924_);
            q = this.player.f_20925_ - this.player.f_20924_ * (1.0f - tickDelta);
            if (this.player.m_6162_()) {
                q *= 3.0f;
            }
            if (p > 1.0f) {
                p = 1.0f;
            }
        }
        this.model.f_102817_ = this.player.m_6047_();
        this.model.m_6973_((LivingEntity)this.player, q, p, o, k, m);
    }

    public void translateAndRotate(PoseStack poseStack, PartPose pose) {
        poseStack.m_85837_((double)(pose.f_171405_ / 16.0f), (double)(pose.f_171406_ / 16.0f), (double)(pose.f_171407_ / 16.0f));
        if (pose.f_171410_ != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122270_(pose.f_171410_));
        }
        if (pose.f_171409_ != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122270_(pose.f_171409_));
        }
        if (pose.f_171408_ != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122270_(pose.f_171408_));
        }
    }

    @Override
    public void renderBefore(PoseStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderAfter(PoseStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void render(PoseStack matrixStack, double delta, VerletSimulation simulation) {
    }
}

