/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import com.mojang.blaze3d.vertex.PoseStack;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.physics.verlet.VerletLine;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.VerletStick;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class FishingHookConstraint
implements VerletConstraint {
    private Vector3d playerPosAsync = new Vector3d();
    private Vector3d hookPosAsync = new Vector3d();
    private Vector3d playerPos = new Vector3d();
    private Vector3d hookPos = new Vector3d();
    private FishingHook fishingHook;
    private Player player;
    private EntityRenderDispatcher entityRenderDispatcher;

    public FishingHookConstraint(VerletSimulation simulation, FishingHook fishingHook, Player player, EntityRenderDispatcher entityRenderDispatcher, float tickDelta) {
        int i;
        this.fishingHook = fishingHook;
        this.player = player;
        this.entityRenderDispatcher = entityRenderDispatcher;
        this.calculatePlayerAndHookPos(tickDelta, this.playerPos, this.hookPos);
        int pointCount = 48;
        double totalLength = ConfigClient.fishingLineLength;
        for (i = 0; i < pointCount; ++i) {
            float perc = (float)(i - 1) / (float)pointCount;
            Vector3d position = new Vector3d(Math.lerp(this.playerPos.x, this.hookPos.x, (double)perc), Math.lerp(this.playerPos.y, this.hookPos.y, (double)perc), Math.lerp(this.playerPos.z, this.hookPos.z, (double)perc));
            VerletPoint point = new VerletPoint(position);
            point.uv.set(0.01f, 0.99f);
            point.rgba.set(0.0f, 0.0f, 0.0f, 1.0f);
            point.locked = i == 0 || i == pointCount - 1;
            simulation.addPoint(point);
        }
        for (i = 0; i < pointCount - 1; ++i) {
            simulation.addStick(new VerletStick(simulation.getPoints().get(i), simulation.getPoints().get(i + 1), totalLength / (double)pointCount));
            simulation.addLine(new VerletLine(simulation.getPoints().get(i), simulation.getPoints().get(i + 1)));
        }
    }

    private void calculatePlayerAndHookPos(float tickDelta, Vector3d playerPos, Vector3d hookPos) {
        float playerEyeHeight;
        double playerZ;
        double playerY;
        double playerX;
        double hookX;
        int arm = this.player.m_5737_() == HumanoidArm.RIGHT ? 1 : -1;
        ItemStack itemStack = this.player.m_21205_();
        if (!itemStack.m_150930_(Items.f_42523_)) {
            arm = -arm;
        }
        float attackRotation = this.player.m_21324_(tickDelta);
        float attackRotationSin = Mth.m_14031_((float)(Mth.m_14116_((float)attackRotation) * (float)java.lang.Math.PI));
        float bodyRotation = Mth.m_14179_((float)tickDelta, (float)this.player.f_20884_, (float)this.player.f_20883_) * ((float)java.lang.Math.PI / 180);
        double bodyRotationSin = Mth.m_14031_((float)bodyRotation);
        double bodyRotationCos = Mth.m_14089_((float)bodyRotation);
        double armShort = (double)arm * 0.35;
        if ((this.entityRenderDispatcher.f_114360_ == null || this.entityRenderDispatcher.f_114360_.m_92176_().m_90612_()) && this.player == Minecraft.m_91087_().f_91074_) {
            hookX = 960.0 / this.entityRenderDispatcher.f_114360_.f_92068_;
            Vec3 firstPersonOffset = this.entityRenderDispatcher.f_114358_.m_167684_().m_167695_((float)arm * 0.525f, -0.1f);
            firstPersonOffset = firstPersonOffset.m_82490_(hookX);
            firstPersonOffset = firstPersonOffset.m_82524_(attackRotationSin * 0.5f);
            firstPersonOffset = firstPersonOffset.m_82496_(-attackRotationSin * 0.7f);
            playerX = Mth.m_14139_((double)tickDelta, (double)this.player.f_19854_, (double)this.player.m_20185_()) + firstPersonOffset.f_82479_;
            playerY = Mth.m_14139_((double)tickDelta, (double)this.player.f_19855_, (double)this.player.m_20186_()) + firstPersonOffset.f_82480_;
            playerZ = Mth.m_14139_((double)tickDelta, (double)this.player.f_19856_, (double)this.player.m_20189_()) + firstPersonOffset.f_82481_;
            playerEyeHeight = this.player.m_20192_();
        } else {
            playerX = Mth.m_14139_((double)tickDelta, (double)this.player.f_19854_, (double)this.player.m_20185_()) - bodyRotationCos * armShort - bodyRotationSin * 0.8;
            playerY = this.player.f_19855_ + (double)this.player.m_20192_() + (this.player.m_20186_() - this.player.f_19855_) * (double)tickDelta - 0.45;
            playerZ = Mth.m_14139_((double)tickDelta, (double)this.player.f_19856_, (double)this.player.m_20189_()) - bodyRotationSin * armShort + bodyRotationCos * 0.8;
            playerEyeHeight = this.player.m_6047_() ? -0.1875f : 0.0f;
        }
        hookX = Mth.m_14139_((double)tickDelta, (double)this.fishingHook.f_19854_, (double)this.fishingHook.m_20185_());
        double hookY = Mth.m_14139_((double)tickDelta, (double)this.fishingHook.f_19855_, (double)this.fishingHook.m_20186_()) + 0.25;
        double hookZ = Mth.m_14139_((double)tickDelta, (double)this.fishingHook.f_19856_, (double)this.fishingHook.m_20189_());
        playerPos.set(playerX, playerY + (double)playerEyeHeight, playerZ);
        hookPos.set(hookX, hookY, hookZ);
    }

    @Override
    public boolean initAsyncData(VerletSimulation simulation) {
        this.calculatePlayerAndHookPos(1.0f, this.playerPosAsync, this.hookPosAsync);
        return false;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
        VerletPoint armPoint = simulation.getPoints().get(0);
        VerletPoint hookPoint = simulation.getPoints().get(simulation.getPoints().size() - 1);
        armPoint.position.set(this.playerPosAsync).sub(simulation.getOffset());
        hookPoint.position.set(this.hookPosAsync).sub(simulation.getOffset());
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderBefore(PoseStack matrixStack, double delta, VerletSimulation simulation) {
        this.calculatePlayerAndHookPos((float)delta, this.playerPos, this.hookPos);
        VerletPoint armPoint = simulation.getPoints().get(0);
        VerletPoint hookPoint = simulation.getPoints().get(simulation.getPoints().size() - 1);
        armPoint.bufferPosition.set(this.playerPos).sub(simulation.getOffset());
        armPoint.bufferPrevPosition.set(armPoint.bufferPosition);
        hookPoint.bufferPosition.set(this.hookPos).sub(simulation.getOffset());
        hookPoint.bufferPrevPosition.set(hookPoint.bufferPosition);
    }

    @Override
    public void renderAfter(PoseStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void render(PoseStack matrixStack, double delta, VerletSimulation simulation) {
    }
}

