/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.vines;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.settings.vines.BlockOption;
import net.diebuddies.physics.vines.Adjustable;
import net.diebuddies.physics.vines.DynamicSetting;
import net.diebuddies.physics.vines.DynamicSettingEnum;
import net.minecraft.client.CycleOption;
import net.minecraft.client.Option;
import net.minecraft.client.ProgressOption;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.block.Block;
import org.joml.Vector3f;

public class AdjustableUtil {
    private static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        if (type.getSuperclass() != null) {
            AdjustableUtil.getAllFields(fields, type.getSuperclass());
        }
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        return fields;
    }

    public static DynamicSetting readAllFields(JsonObject json) {
        int settingID = json.get("settingID").getAsInt();
        Class<?> type = null;
        for (DynamicSettingEnum ds : DynamicSettingEnum.values()) {
            if (ds.getID() != settingID) continue;
            type = ds.getType();
        }
        if (type == null) {
            return null;
        }
        ObjectArrayList fields = new ObjectArrayList();
        AdjustableUtil.getAllFields((List<Field>)fields, type);
        json.add("settingID", (JsonElement)new JsonPrimitive((Number)settingID));
        DynamicSetting object = null;
        try {
            object = (DynamicSetting)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        for (Field f : fields) {
            try {
                if (!f.isAnnotationPresent(Adjustable.class)) continue;
                Adjustable adjustable = f.getAnnotation(Adjustable.class);
                if (f.getType().equals(Byte.TYPE)) {
                    f.setByte(object, json.get(adjustable.name()).getAsByte());
                    continue;
                }
                if (f.getType().equals(Integer.TYPE)) {
                    f.setInt(object, json.get(adjustable.name()).getAsInt());
                    continue;
                }
                if (f.getType().equals(Long.TYPE)) {
                    f.setLong(object, json.get(adjustable.name()).getAsLong());
                    continue;
                }
                if (f.getType().equals(Float.TYPE)) {
                    f.setFloat(object, json.get(adjustable.name()).getAsFloat());
                    continue;
                }
                if (f.getType().equals(Double.TYPE)) {
                    f.setDouble(object, json.get(adjustable.name()).getAsDouble());
                    continue;
                }
                if (f.getType().equals(Short.TYPE)) {
                    f.setShort(object, json.get(adjustable.name()).getAsShort());
                    continue;
                }
                if (f.getType().equals(Boolean.TYPE)) {
                    f.setBoolean(object, json.get(adjustable.name()).getAsBoolean());
                    continue;
                }
                if (f.getType().equals(Vector3f.class)) {
                    Field xField = Vector3f.class.getDeclaredField("x");
                    Field yField = Vector3f.class.getDeclaredField("y");
                    Field zField = Vector3f.class.getDeclaredField("z");
                    Vector3f value = (Vector3f)f.get(object);
                    xField.setFloat(value, json.get(adjustable.name() + " x").getAsFloat());
                    yField.setFloat(value, json.get(adjustable.name() + " y").getAsFloat());
                    zField.setFloat(value, json.get(adjustable.name() + " z").getAsFloat());
                    continue;
                }
                if (!f.getType().equals(Block.class)) continue;
                JsonElement linkObj = json.get(adjustable.name());
                Block link = null;
                if (linkObj != null && !linkObj.isJsonNull()) {
                    link = PhysicsMod.invRegisteredBlocks.get(linkObj.getAsString());
                }
                f.set(object, link);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public static void saveAllFields(JsonObject json, DynamicSetting object) {
        Class<?> type = object.getClass();
        ObjectArrayList fields = new ObjectArrayList();
        AdjustableUtil.getAllFields((List<Field>)fields, type);
        int settingID = 0;
        for (DynamicSettingEnum ds : DynamicSettingEnum.values()) {
            if (ds.getType() != object.getClass()) continue;
            settingID = ds.getID();
        }
        json.add("settingID", (JsonElement)new JsonPrimitive((Number)settingID));
        for (Field f : fields) {
            try {
                if (!f.isAnnotationPresent(Adjustable.class)) continue;
                Adjustable adjustable = f.getAnnotation(Adjustable.class);
                if (f.getType().equals(Byte.TYPE)) {
                    json.add(adjustable.name(), (JsonElement)new JsonPrimitive((Number)f.getByte(object)));
                    continue;
                }
                if (f.getType().equals(Integer.TYPE)) {
                    json.add(adjustable.name(), (JsonElement)new JsonPrimitive((Number)f.getInt(object)));
                    continue;
                }
                if (f.getType().equals(Long.TYPE)) {
                    json.add(adjustable.name(), (JsonElement)new JsonPrimitive((Number)f.getLong(object)));
                    continue;
                }
                if (f.getType().equals(Float.TYPE)) {
                    json.add(adjustable.name(), (JsonElement)new JsonPrimitive((Number)Float.valueOf(f.getFloat(object))));
                    continue;
                }
                if (f.getType().equals(Double.TYPE)) {
                    json.add(adjustable.name(), (JsonElement)new JsonPrimitive((Number)f.getDouble(object)));
                    continue;
                }
                if (f.getType().equals(Short.TYPE)) {
                    json.add(adjustable.name(), (JsonElement)new JsonPrimitive((Number)f.getShort(object)));
                    continue;
                }
                if (f.getType().equals(Boolean.TYPE)) {
                    json.add(adjustable.name(), (JsonElement)new JsonPrimitive(Boolean.valueOf(f.getBoolean(object))));
                    continue;
                }
                if (f.getType().equals(Vector3f.class)) {
                    Field xField = Vector3f.class.getDeclaredField("x");
                    Field yField = Vector3f.class.getDeclaredField("y");
                    Field zField = Vector3f.class.getDeclaredField("z");
                    Vector3f value = (Vector3f)f.get(object);
                    json.add(adjustable.name() + " x", (JsonElement)new JsonPrimitive((Number)Float.valueOf(xField.getFloat(value))));
                    json.add(adjustable.name() + " y", (JsonElement)new JsonPrimitive((Number)Float.valueOf(yField.getFloat(value))));
                    json.add(adjustable.name() + " z", (JsonElement)new JsonPrimitive((Number)Float.valueOf(zField.getFloat(value))));
                    continue;
                }
                if (!f.getType().equals(Block.class)) continue;
                Block block = (Block)f.get(object);
                if (block == null) {
                    json.add(adjustable.name(), (JsonElement)JsonNull.INSTANCE);
                    continue;
                }
                json.add(adjustable.name(), (JsonElement)new JsonPrimitive(PhysicsMod.registeredBlocks.get(block)));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<Option> generateOptions(Screen screen, Object object) {
        Class<?> type = object.getClass();
        ObjectArrayList fields = new ObjectArrayList();
        AdjustableUtil.getAllFields((List<Field>)fields, type);
        ObjectArrayList options = new ObjectArrayList();
        for (Field f : fields) {
            try {
                if (!f.isAnnotationPresent(Adjustable.class)) continue;
                Adjustable adjustable = f.getAnnotation(Adjustable.class);
                if (f.getType().equals(Byte.TYPE)) {
                    options.add(AdjustableUtil.createProgressOptionByte(adjustable.name(), adjustable.min(), adjustable.max(), adjustable.step(), f, object));
                    continue;
                }
                if (f.getType().equals(Integer.TYPE)) {
                    options.add(AdjustableUtil.createProgressOptionInt(adjustable.name(), adjustable.min(), adjustable.max(), adjustable.step(), f, object));
                    continue;
                }
                if (f.getType().equals(Long.TYPE)) {
                    options.add(AdjustableUtil.createProgressOptionLong(adjustable.name(), adjustable.min(), adjustable.max(), adjustable.step(), f, object));
                    continue;
                }
                if (f.getType().equals(Float.TYPE)) {
                    options.add(AdjustableUtil.createProgressOptionFloat(adjustable.name(), adjustable.min(), adjustable.max(), adjustable.step(), f, object));
                    continue;
                }
                if (f.getType().equals(Double.TYPE)) {
                    options.add(AdjustableUtil.createProgressOptionDouble(adjustable.name(), adjustable.min(), adjustable.max(), adjustable.step(), f, object));
                    continue;
                }
                if (f.getType().equals(Short.TYPE)) {
                    options.add(AdjustableUtil.createProgressOptionShort(adjustable.name(), adjustable.min(), adjustable.max(), adjustable.step(), f, object));
                    continue;
                }
                if (f.getType().equals(Boolean.TYPE)) {
                    options.add(CycleOption.m_167743_((String)adjustable.name(), gameOptions -> {
                        try {
                            return f.getBoolean(object);
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }, (gameOptions, option, value) -> {
                        try {
                            f.setBoolean(object, (boolean)value);
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                    }));
                    continue;
                }
                if (f.getType().equals(Vector3f.class)) {
                    Field xField = Vector3f.class.getDeclaredField("x");
                    Field yField = Vector3f.class.getDeclaredField("y");
                    Field zField = Vector3f.class.getDeclaredField("z");
                    Vector3f value2 = (Vector3f)f.get(object);
                    options.add(AdjustableUtil.createProgressOptionFloat(adjustable.name() + " x", adjustable.min(), adjustable.max(), adjustable.step(), xField, value2));
                    options.add(AdjustableUtil.createProgressOptionFloat(adjustable.name() + " y", adjustable.min(), adjustable.max(), adjustable.step(), yField, value2));
                    options.add(AdjustableUtil.createProgressOptionFloat(adjustable.name() + " z", adjustable.min(), adjustable.max(), adjustable.step(), zField, value2));
                    continue;
                }
                if (!f.getType().equals(Block.class)) continue;
                Block block = (Block)f.get(object);
                options.add(new BlockOption(adjustable.name(), PhysicsMod.registeredBlocks.get(block), true, screen, blockChange -> {
                    try {
                        if (blockChange == null) {
                            f.set(object, null);
                        } else {
                            f.set(object, PhysicsMod.invRegisteredBlocks.get(blockChange));
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                }));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        }
        return options;
    }

    private static ProgressOption createProgressOptionDouble(String name, double min, double max, double step, Field f, Object object) {
        ProgressOption progressOption = new ProgressOption(name, min, max, (float)step, options -> {
            try {
                return f.getDouble(object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                return 0.0;
            }
        }, (options, value) -> {
            try {
                f.setDouble(object, (double)value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }, (options, option) -> new TextComponent(name + ": " + String.format("%.2f", option.m_92221_(options))));
        return progressOption;
    }

    private static ProgressOption createProgressOptionFloat(String name, double min, double max, double step, Field f, Object object) {
        ProgressOption progressOption = new ProgressOption(name, min, max, (float)step, options -> {
            try {
                return f.getFloat(object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                return 0.0;
            }
        }, (options, value) -> {
            try {
                f.setFloat(object, value.floatValue());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }, (options, option) -> new TextComponent(name + ": " + String.format("%.2f", option.m_92221_(options))));
        return progressOption;
    }

    private static ProgressOption createProgressOptionInt(String name, double min, double max, double step, Field f, Object object) {
        ProgressOption progressOption = new ProgressOption(name, min, max, (float)step, options -> {
            try {
                return f.getInt(object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                return 0.0;
            }
        }, (options, value) -> {
            try {
                f.setInt(object, value.intValue());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }, (options, option) -> new TextComponent(name + ": " + String.format("%.2f", option.m_92221_(options))));
        return progressOption;
    }

    private static ProgressOption createProgressOptionLong(String name, double min, double max, double step, Field f, Object object) {
        ProgressOption progressOption = new ProgressOption(name, min, max, (float)step, options -> {
            try {
                return f.getLong(object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                return 0.0;
            }
        }, (options, value) -> {
            try {
                f.setLong(object, value.longValue());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }, (options, option) -> new TextComponent(name + ": " + String.format("%.2f", option.m_92221_(options))));
        return progressOption;
    }

    private static ProgressOption createProgressOptionShort(String name, double min, double max, double step, Field f, Object object) {
        ProgressOption progressOption = new ProgressOption(name, min, max, (float)step, options -> {
            try {
                return f.getShort(object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                return 0.0;
            }
        }, (options, value) -> {
            try {
                f.setShort(object, value.shortValue());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }, (options, option) -> new TextComponent(name + ": " + String.format("%.2f", option.m_92221_(options))));
        return progressOption;
    }

    private static ProgressOption createProgressOptionByte(String name, double min, double max, double step, Field f, Object object) {
        ProgressOption progressOption = new ProgressOption(name, min, max, (float)step, options -> {
            try {
                return f.getByte(object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                return 0.0;
            }
        }, (options, value) -> {
            try {
                f.setByte(object, value.byteValue());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }, (options, option) -> new TextComponent(name + ": " + String.format("%.2f", option.m_92221_(options))));
        return progressOption;
    }
}

