/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.vines;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigVines;
import net.diebuddies.physics.vines.DynamicSetting;
import net.diebuddies.physics.vines.VineSetting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class VineHelper {
    public static volatile BlockPos playerPos = new BlockPos(0, 0, 0);
    private static Map<Block, DynamicSetting> dynamicSettings = new Object2ObjectOpenHashMap();

    public static void initFromConfigSettings() {
        dynamicSettings = new Object2ObjectOpenHashMap(ConfigVines.configSettings);
        for (Map.Entry<Block, DynamicSetting> entry : ConfigVines.configSettings.entrySet()) {
            DynamicSetting setting = entry.getValue();
            if (!(setting instanceof VineSetting)) continue;
            VineSetting vsetting = (VineSetting)setting;
            if (vsetting.link == null) continue;
            dynamicSettings.put(vsetting.link, new VineSetting(vsetting.bottomFixed, vsetting.waterPhysics, vsetting.sideConnection, vsetting.hitboxScale, vsetting.stiffness, vsetting.damping, entry.getKey()));
        }
    }

    public static boolean isChunkInRange(int chunkX, int chunkZ) {
        int dz;
        int bx = SectionPos.m_175554_((int)chunkX, (int)8);
        int bz = SectionPos.m_175554_((int)chunkZ, (int)8);
        int dx = SectionPos.m_175554_((int)SectionPos.m_123171_((int)playerPos.m_123341_()), (int)8) - bx;
        return (double)(dx * dx + (dz = SectionPos.m_175554_((int)SectionPos.m_123171_((int)playerPos.m_123343_()), (int)8) - bz) * dz) < ConfigClient.vineRange * ConfigClient.vineRange;
    }

    public static boolean isChunkInRange(BlockPos pos) {
        return VineHelper.isChunkInRange(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()));
    }

    public static DynamicSetting getSetting(BlockState state) {
        return dynamicSettings.get(state.m_60734_());
    }

    static {
        ConfigVines.init();
    }
}

